/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data;

import java.lang.reflect.Array;
import java.util.Objects;

public class ParameterSpec
implements Cloneable {
    public String propertyName;
    public Object parameter;

    public String toString() {
        return "propertyName: " + this.propertyName + ", parameter: " + ParameterSpec.stringValue(this.parameter);
    }

    public ParameterSpec clone() throws CloneNotSupportedException {
        ParameterSpec copy = (ParameterSpec)super.clone();
        copy.propertyName = this.propertyName;
        copy.parameter = this.parameter;
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ParameterSpec)) {
            return false;
        }
        ParameterSpec that = (ParameterSpec)obj;
        return Objects.equals(this.propertyName, that.propertyName) && Objects.equals(this.parameter, that.parameter);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.propertyName);
        result = 31 * result + Objects.hashCode(this.parameter);
        return result;
    }

    private static String stringValue(Object parameter) {
        if (ParameterSpec.isArray(parameter)) {
            return ParameterSpec.arrayToString(parameter);
        }
        return String.valueOf(parameter);
    }

    private static boolean isArray(Object o) {
        return o == null ? false : o.getClass().isArray();
    }

    private static String arrayToString(Object propertyValue) {
        StringBuilder sb = new StringBuilder("[");
        int length = Array.getLength(propertyValue);
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(Array.get(propertyValue, i));
        }
        sb.append("]");
        return sb.toString();
    }
}

