/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.plugin.manifest.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vmware.vise.plugin.manifest.model.Definitions;
import com.vmware.vise.plugin.manifest.model.PluginConfig;
import com.vmware.vise.plugin.manifest.model.deployment.DeploymentScope;
import com.vmware.vise.plugin.manifest.model.devcenter.DevCenterScope;
import com.vmware.vise.plugin.manifest.model.home.HomeScope;
import com.vmware.vise.plugin.manifest.model.internal.InternalScope;
import com.vmware.vise.plugin.manifest.model.object.ObjectScope;
import com.vmware.vise.plugin.manifest.model.object.ObjectType;
import com.vmware.vise.plugin.manifest.model.requirement.PluginRequirements;
import com.vmware.vise.plugin.manifest.model.sharedmodal.SharedModal;
import java.util.List;
import java.util.Map;

public class PluginData {
    @JsonProperty(value="manifestVersion")
    public String manifestVersion;
    @JsonProperty(value="configuration")
    private PluginConfig configuration;
    @JsonProperty(value="internal")
    public InternalScope internalScope;
    @JsonProperty(value="deployment")
    public DeploymentScope deploymentScope;
    @JsonProperty(value="devCenter")
    public DevCenterScope devCenterScope;
    @JsonProperty(value="global")
    public HomeScope homeScope;
    @JsonProperty(value="objects")
    private Map<ObjectType, ObjectScope> objectScopes;
    @JsonProperty(value="definitions")
    public Definitions definitions;
    @JsonProperty(value="requirements")
    public PluginRequirements requirements;
    @JsonProperty(value="sharedModals")
    public List<SharedModal> sharedModals;

    public final String getManifestVersion() {
        return this.manifestVersion;
    }

    public final PluginConfig getConfiguration() {
        return this.configuration;
    }

    public final HomeScope getHomeScope() {
        return this.homeScope;
    }

    public final DeploymentScope getDeploymentScope() {
        return this.deploymentScope;
    }

    public final Map<ObjectType, ObjectScope> getObjectScopes() {
        return this.objectScopes;
    }

    public final Definitions getDefinitions() {
        return this.definitions;
    }

    public final PluginRequirements getRequirements() {
        return this.requirements;
    }

    @JsonCreator
    public PluginData(@JsonProperty(value="objects") Map<ObjectType, ObjectScope> objectScopes, @JsonProperty(value="configuration") PluginConfig configuration) {
        if (objectScopes != null) {
            for (Map.Entry<ObjectType, ObjectScope> entry : objectScopes.entrySet()) {
                ObjectType objectType = entry.getKey();
                ObjectScope objectScope = entry.getValue();
                if (objectScope == null) continue;
                objectScope.setObjectType(objectType);
                objectScope.setConfiguration(configuration);
            }
        }
        this.objectScopes = objectScopes;
        this.configuration = configuration;
    }
}

