/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.plugin.manifest.model.object;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vmware.vise.plugin.manifest.model.PluginConfig;
import com.vmware.vise.plugin.manifest.model.object.ObjectType;
import com.vmware.vise.plugin.manifest.model.object.menu.Action;
import com.vmware.vise.plugin.manifest.model.object.menu.Menu;
import com.vmware.vise.plugin.manifest.model.object.menu.MenuItem;
import com.vmware.vise.plugin.manifest.model.object.summary.Card;
import com.vmware.vise.plugin.manifest.model.object.summary.Summary;
import com.vmware.vise.plugin.manifest.model.object.view.Category;
import com.vmware.vise.plugin.manifest.model.object.view.ObjectView;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class ObjectScope {
    public Menu menu;
    public Summary summary;
    @JsonProperty(value="monitor")
    public Category monitorCategory;
    @JsonProperty(value="configure")
    public Category configureCategory;
    @JsonProperty(value="updates")
    public Category updatesCategory;
    @JsonIgnore
    public ObjectType objectType;

    @JsonProperty(value="menu")
    private void configureMenu(Menu menu) {
        this.menu = menu;
        MenuItem[] menuItems = this.menu.getActions();
        if (menuItems != null) {
            for (int i = 0; i < menuItems.length; ++i) {
                Action action;
                MenuItem menuItem = menuItems[i];
                menuItem.setLocalId(String.valueOf(i));
                if (this.menu.getDynamicItemConfig() == null || !(menuItem instanceof Action) || !(action = (Action)menuItem).isDynamic()) continue;
                action.setDynamicItemConfig(menu.getDynamicItemConfig());
            }
        }
    }

    @JsonProperty(value="summary")
    private void configureSummary(Summary summary) {
        this.summary = summary;
        Card[] cards = this.summary.getCards();
        if (cards != null) {
            for (int i = 0; i < cards.length; ++i) {
                Card card = cards[i];
                card.setLocalId(String.valueOf(i));
                if (this.summary.getDynamicItemConfig() == null || !card.isDynamic()) continue;
                card.setDynamicItemConfig(this.summary.getDynamicItemConfig());
            }
        }
    }

    public final Summary getSummary() {
        return this.summary;
    }

    private void setMonitorCategory(Category category) {
        this.monitorCategory = this.configureCategory(category);
    }

    public final Category getMonitorCategory() {
        return this.monitorCategory;
    }

    private void setConfigureCategory(Category category) {
        this.configureCategory = this.configureCategory(category);
    }

    public final Category getConfigureCategory() {
        return this.configureCategory;
    }

    private void setUpdatesCategory(Category category) {
        this.updatesCategory = this.configureCategory(category);
    }

    public final Category getUpdatesCategory() {
        return this.updatesCategory;
    }

    public final Menu getMenu() {
        return this.menu;
    }

    public final ObjectType getObjectType() {
        return this.objectType;
    }

    public final void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    @JsonIgnore
    public final List<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        if (this.monitorCategory != null) {
            categories.add(this.monitorCategory);
        }
        if (this.configureCategory != null) {
            categories.add(this.configureCategory);
        }
        if (this.updatesCategory != null) {
            categories.add(this.updatesCategory);
        }
        return categories;
    }

    public final void setConfiguration(PluginConfig config) {
        Card[] cards;
        Validate.notNull(config);
        Card[] cardArray = cards = this.summary != null ? this.summary.getCards() : null;
        if (cards != null) {
            for (Card card : cards) {
                if (card.getTitleKey() == null) {
                    card.setTitleKey(config.getNameKey());
                }
                if (card.getIcon() != null) continue;
                card.setIcon(config.getIcon());
            }
        }
        if (this.monitorCategory != null) {
            this.monitorCategory.setDefaultCategoryLabelKey(config.getNameKey());
            this.configureCategory(this.monitorCategory);
        }
        if (this.configureCategory != null) {
            this.configureCategory.setDefaultCategoryLabelKey(config.getNameKey());
            this.configureCategory(this.configureCategory);
        }
        if (this.updatesCategory != null) {
            this.updatesCategory.setDefaultCategoryLabelKey(config.getNameKey());
            this.configureCategory(this.updatesCategory);
        }
        if (this.menu != null) {
            this.menu.setLabelKey(config.getNameKey());
            this.menu.setIcon(config.getIcon());
        }
    }

    private Category configureCategory(Category category) {
        ObjectView[] views = category.getStandardViews();
        if (views != null) {
            for (ObjectView view : views) {
                if (view.isDynamic() && category.getDynamicItemConfig() != null) {
                    view.setDynamicItemConfig(category.getDynamicItemConfig());
                }
                if (view.isDynamic() || view.getRelevanceFilteringConditions() != null) {
                    category.setDynamic(true);
                }
                view.setPluginNameKey(category.getDefaultCategoryLabelKey());
            }
        }
        return category;
    }
}

