/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.plugin.manifest.model.object;

import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ObjectType {
    CLUSTER_COMPUTE_RESOURCE{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Arrays.asList(1.clusterComputeResourceType(), 1.supervisorModelType());
        }

        @Override
        public String getExtensionName() {
            return "cluster";
        }
    }
    ,
    DATACENTER{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("Datacenter");
        }

        @Override
        public String getExtensionName() {
            return "datacenter";
        }
    }
    ,
    DATASTORE{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("Datastore");
        }

        @Override
        public String getExtensionName() {
            return "datastore";
        }
    }
    ,
    DISTRIBUTED_VIRTUAL_PORTGROUP{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("DistributedVirtualPortgroup");
        }

        @Override
        public String getExtensionName() {
            return "dvPortgroup";
        }
    }
    ,
    DISTRIBUTED_VIRTUAL_SWITCH{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("VmwareDistributedVirtualSwitch");
        }

        @Override
        public String getExtensionName() {
            return "dvs";
        }
    }
    ,
    FOLDER_DATACENTER{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("Folder");
        }

        @Override
        public String getExtensionName() {
            return "folder";
        }

        @Override
        public Map<String, Object> getMetadata() {
            Map<String, Object> metadata = super.getMetadata();
            metadata.put("folderType", "DatacenterFolder");
            return metadata;
        }
    }
    ,
    FOLDER_DATASTORE{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("Folder");
        }

        @Override
        public String getExtensionName() {
            return "folder";
        }

        @Override
        public Map<String, Object> getMetadata() {
            Map<String, Object> metadata = super.getMetadata();
            metadata.put("folderType", "DatastoreFolder");
            return metadata;
        }
    }
    ,
    FOLDER_HOST{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("Folder");
        }

        @Override
        public String getExtensionName() {
            return "folder";
        }

        @Override
        public Map<String, Object> getMetadata() {
            Map<String, Object> metadata = super.getMetadata();
            metadata.put("folderType", "HostFolder");
            return metadata;
        }
    }
    ,
    FOLDER_NETWORK{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("Folder");
        }

        @Override
        public String getExtensionName() {
            return "folder";
        }

        @Override
        public Map<String, Object> getMetadata() {
            Map<String, Object> metadata = super.getMetadata();
            metadata.put("folderType", "NetworkFolder");
            return metadata;
        }
    }
    ,
    FOLDER_ROOT{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("Folder");
        }

        @Override
        public String getExtensionName() {
            return "folder";
        }

        @Override
        public Map<String, Object> getMetadata() {
            Map<String, Object> metadata = super.getMetadata();
            metadata.put("folderType", "RootFolder");
            return metadata;
        }
    }
    ,
    FOLDER_VIRTUAL_MACHINE{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("Folder");
        }

        @Override
        public String getExtensionName() {
            return "folder";
        }

        @Override
        public Map<String, Object> getMetadata() {
            Map<String, Object> metadata = super.getMetadata();
            metadata.put("folderType", "VirtualMachineFolder");
            return metadata;
        }
    }
    ,
    HOST_SYSTEM{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("HostSystem");
        }

        @Override
        public String getExtensionName() {
            return "host";
        }
    }
    ,
    NETWORK{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("Network");
        }

        @Override
        public String getExtensionName() {
            return "network";
        }
    }
    ,
    OPAQUE_NETWORK{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("OpaqueNetwork");
        }

        @Override
        public String getExtensionName() {
            return "opaqueNetwork";
        }
    }
    ,
    RESOURCE_POOL{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("ResourcePool");
        }

        @Override
        public String getExtensionName() {
            return "resourcePool";
        }
    }
    ,
    STORAGE_POD{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("StoragePod");
        }

        @Override
        public String getExtensionName() {
            return "dscluster";
        }
    }
    ,
    SUPERVISOR_MODEL{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Arrays.asList(17.supervisorModelType(), 17.clusterComputeResourceType());
        }

        @Override
        public String getExtensionName() {
            return "supervisor";
        }

        @Override
        public Map<String, Object> getMetadata() {
            Map<String, Object> metadata = super.getMetadata();
            CompositeConstraint isSupervisorConstraint = new CompositeConstraint();
            isSupervisorConstraint.conjoiner = Conjoiner.OR;
            isSupervisorConstraint.nestedConstraints = new PropertyConstraint[]{ObjectType.getWcpEnabledPropertyConstraint(), ObjectType.getSupervisorModelObjectTypePropertyConstraint()};
            metadata.put("propertyConditions", isSupervisorConstraint);
            return metadata;
        }
    }
    ,
    VIRTUAL_APP{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("VirtualApp");
        }

        @Override
        public String getExtensionName() {
            return "vApp";
        }
    }
    ,
    VIRTUAL_MACHINE{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("VirtualMachine");
        }

        @Override
        public String getExtensionName() {
            return "vm";
        }

        @Override
        public Map<String, Object> getActionMetadata() {
            Map<String, Object> metadata = super.getActionMetadata();
            PropertyConstraint isNormalVmPropertyConstraint = new PropertyConstraint();
            isNormalVmPropertyConstraint.propertyName = "isNormalVM";
            isNormalVmPropertyConstraint.comparator = Comparator.EQUALS;
            isNormalVmPropertyConstraint.comparableValue = true;
            CompositeConstraint isNormalVmCompositeConstraint = new CompositeConstraint();
            isNormalVmCompositeConstraint.conjoiner = Conjoiner.AND;
            isNormalVmCompositeConstraint.nestedConstraints = new PropertyConstraint[]{isNormalVmPropertyConstraint};
            metadata.put("propertyConditions", isNormalVmCompositeConstraint);
            return metadata;
        }
    }
    ,
    VIRTUAL_MACHINE_TEMPLATE{

        @Override
        public List<String> getVsphereObjectTypes() {
            return Collections.singletonList("VirtualMachine");
        }

        @Override
        public String getExtensionName() {
            return "template";
        }

        @Override
        public Map<String, Object> getActionMetadata() {
            Map<String, Object> metadata = super.getActionMetadata();
            PropertyConstraint isNotNormalVmPropertyConstraint = new PropertyConstraint();
            isNotNormalVmPropertyConstraint.propertyName = "isNormalVM";
            isNotNormalVmPropertyConstraint.comparator = Comparator.EQUALS;
            isNotNormalVmPropertyConstraint.comparableValue = false;
            CompositeConstraint isNotNormalVmCompositeConstraint = new CompositeConstraint();
            isNotNormalVmCompositeConstraint.conjoiner = Conjoiner.AND;
            isNotNormalVmCompositeConstraint.nestedConstraints = new PropertyConstraint[]{isNotNormalVmPropertyConstraint};
            metadata.put("propertyConditions", isNotNormalVmCompositeConstraint);
            return metadata;
        }
    };


    public abstract List<String> getVsphereObjectTypes();

    public abstract String getExtensionName();

    public Map<String, Object> getMetadata() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("objectType", String.join((CharSequence)",", this.getVsphereObjectTypes()));
        return metadata;
    }

    public Map<String, Object> getActionMetadata() {
        HashMap<String, Object> actionMetadata = new HashMap<String, Object>();
        return actionMetadata;
    }

    private static PropertyConstraint getWcpEnabledPropertyConstraint() {
        PropertyConstraint wcpEnabledPropertyConstraint = new PropertyConstraint();
        wcpEnabledPropertyConstraint.propertyName = "wcpEnabled";
        wcpEnabledPropertyConstraint.comparator = Comparator.EQUALS;
        wcpEnabledPropertyConstraint.comparableValue = true;
        return wcpEnabledPropertyConstraint;
    }

    private static PropertyConstraint getSupervisorModelObjectTypePropertyConstraint() {
        PropertyConstraint wcpEnabledPropertyConstraint = new PropertyConstraint();
        wcpEnabledPropertyConstraint.propertyName = "@type";
        wcpEnabledPropertyConstraint.comparator = Comparator.EQUALS;
        wcpEnabledPropertyConstraint.comparableValue = ObjectType.supervisorModelType();
        return wcpEnabledPropertyConstraint;
    }

    public static String supervisorModelType() {
        return "com.vmware.wcp.SupervisorModel";
    }

    public static String clusterComputeResourceType() {
        return "ClusterComputeResource";
    }
}

