/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFANode
extends CompositeGraphicsNode {
    String destination;
    AffineTransform transform;

    public void paint(Graphics2D g2d) {
        if (this.isVisible) {
            super.paint(g2d);
            if (g2d instanceof PDFGraphics2D) {
                PDFGraphics2D pdfg = (PDFGraphics2D)g2d;
                int type2 = 1;
                Shape outline = this.getOutline();
                if (this.destination.startsWith("#svgView(viewBox(")) {
                    type2 = 0;
                    String nums = this.destination.substring(18, this.destination.length() - 2);
                    float x = 0.0f;
                    float y = 0.0f;
                    float width = 0.0f;
                    int count = 0;
                    try {
                        StringTokenizer st = new StringTokenizer(nums, ",");
                        while (st.hasMoreTokens()) {
                            String tok = st.nextToken();
                            switch (++count) {
                                case 1: {
                                    x = Float.parseFloat(tok);
                                    break;
                                }
                                case 2: {
                                    y = Float.parseFloat(tok);
                                    break;
                                }
                                case 3: {
                                    width = Float.parseFloat(tok);
                                    break;
                                }
                                case 4: {
                                    float height = Float.parseFloat(tok);
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {}
                    this.destination = x + " " + y + " " + 200.0f / width;
                }
                pdfg.addLink(outline, this.transform, this.destination, type2);
            }
        }
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setTransform(AffineTransform tf) {
        this.transform = tf;
    }
}

