/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.util.UnitProcessor;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGObj;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGElement
extends SVGObj {
    FontState fs;

    public SVGElement(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, "svg", systemId, line, column);
        this.init();
    }

    private void init() {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        this.doc = impl.createDocument(svgNS, "svg", null);
        this.element = this.doc.getDocumentElement();
        this.buildTopLevel(this.doc, this.element);
    }

    public int layout(Area area) throws FOPException {
        if (!(area instanceof ForeignObjectArea)) {
            throw new FOPException("SVG not in fo:instream-foreign-object");
        }
        if (this.marker == -1000) {
            this.fs = area.getFontState();
            this.marker = 0;
        }
        Element svgRoot = this.element;
        final ForeignObjectArea foa = (ForeignObjectArea)area;
        SVGContext dc = new SVGContext(){

            public Rectangle2D getBBox() {
                return new Rectangle2D.Double(0.0, 0.0, foa.getContentWidth(), foa.getContentHeight());
            }

            public AffineTransform getCTM() {
                return new AffineTransform();
            }

            public float getFontSize() {
                return (float)fs.getFontSize() / 1000.0f;
            }

            public AffineTransform getGlobalTransform() {
                return new AffineTransform();
            }

            public float getPixelToMM() {
                return 0.35277778f;
            }

            public float getPixelUnitToMillimeter() {
                return 0.35277778f;
            }

            public AffineTransform getScreenTransform() {
                throw new UnsupportedOperationException("NYI");
            }

            public float getViewportHeight() {
                return foa.getContentHeight();
            }

            public float getViewportWidth() {
                return foa.getContentWidth();
            }

            public void setScreenTransform(AffineTransform at) {
                throw new UnsupportedOperationException("NYI");
            }
        };
        ((SVGOMElement)svgRoot).setSVGContext(dc);
        try {
            URL baseURL = Configuration.getBaseURL();
            if (baseURL != null) {
                ((SVGOMDocument)this.doc).setURLObject(baseURL);
            }
        }
        catch (Exception e) {
            this.log.error("Could not set base URL for svg", e);
        }
        SVGSVGElement e = ((SVGDocument)this.doc).getRootElement();
        e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
        SVGUserAgent userAgent = new SVGUserAgent(new AffineTransform());
        userAgent.setLogger(this.log);
        BridgeContext ctx = new BridgeContext(userAgent);
        UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)ctx, (Element)e);
        String s = e.getAttributeNS(null, "width");
        if (s.length() == 0) {
            s = "100%";
        }
        float width = UnitProcessor.svgHorizontalLengthToUserSpace((String)s, (String)"width", (UnitProcessor.Context)uctx);
        s = e.getAttributeNS(null, "height");
        if (s.length() == 0) {
            s = "100%";
        }
        float height = UnitProcessor.svgVerticalLengthToUserSpace((String)s, (String)"height", (UnitProcessor.Context)uctx);
        SVGArea svg = new SVGArea(this.fs, width, height);
        svg.setSVGDocument(this.doc);
        svg.start();
        svg.end();
        foa.setObject(svg);
        foa.setIntrinsicWidth(svg.getWidth());
        foa.setIntrinsicHeight(svg.getHeight());
        ((SVGOMElement)svgRoot).setSVGContext(null);
        return 1;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new SVGElement(parent, propertyList, systemId, line, column);
        }
    }
}

