/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vapp.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.security.AuthorizationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class VappActionPropertyProvider {
    static final String PARENT_PROP = "parent";
    static final String HOST_CONN_STATE_PROP = "runtime/connectionState";
    static final String HOST_RECURSIVE_RP_PROP = "capability/recursiveResourcePoolsSupported";
    static final String HOST_ENTER_MMOD_DISABLED_METHOD = "EnterMaintenanceMode_Task";
    static final String HOST_EXIT_MMOD_DISABLED_METHOD = "ExitMaintenanceMode_Task";
    static final String DISABLED_METHODS_PROP = "disabledOperations";
    static final String CREATE_VAPP_PRIVILEGE = "VApp.Create";
    static final String CREATE_VAPP_METHOD_NAME = "CreateVApp";
    static final String CLUSTER_TYPE = ClusterComputeResource.class.getSimpleName();
    static final String RP_TYPE = ResourcePool.class.getSimpleName();
    private final QueryService _queryService;

    public VappActionPropertyProvider(QueryServiceFactory qsFactory) {
        this._queryService = qsFactory.getQueryService();
    }

    @PropertyProvider(value="HostSystem/isCreateVappActionAvailable")
    public Collection<Boolean> isCreateVappActionAvailableOnHost(Collection<ManagedObjectReference> objects) {
        Validate.notEmpty(objects);
        if (objects.size() > 1) {
            throw new UnsupportedOperationException("HostSystem/isCreateVappActionAvailable can only be calculated for a single object.");
        }
        ManagedObjectReference host = objects.iterator().next();
        List items = this._queryService.select(new String[]{PARENT_PROP, HOST_CONN_STATE_PROP, HOST_RECURSIVE_RP_PROP, DISABLED_METHODS_PROP}).from(new String[]{host.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)host).fetch().getItems();
        Set<Boolean> FALSE_VALUE = Collections.singleton(false);
        if (items.isEmpty()) {
            return FALSE_VALUE;
        }
        ResourceItem hostData = (ResourceItem)items.get(0);
        if (this.canCreateVappOnHost(hostData)) {
            return Collections.singleton(this.canCreateVappOnComputeResource((ManagedObjectReference)hostData.get(PARENT_PROP)));
        }
        return FALSE_VALUE;
    }

    @PropertyProvider(value="ClusterComputeResource/isCreateVappActionAvailable")
    public Collection<Boolean> isCreateVappActionAvailableOnCluster(Collection<ManagedObjectReference> objects) {
        Validate.notEmpty(objects);
        if (objects.size() > 1) {
            throw new UnsupportedOperationException("ClusterComputeResource/isCreateVappActionAvailable can only be calculated for a single object.");
        }
        ManagedObjectReference computeResource = objects.iterator().next();
        return Collections.singleton(this.canCreateVappOnComputeResource(computeResource));
    }

    private boolean canCreateVappOnHost(ResourceItem hostData) {
        HostSystem.ConnectionState state = (HostSystem.ConnectionState)hostData.get(HOST_CONN_STATE_PROP);
        ManagedObjectReference parent = (ManagedObjectReference)hostData.get(PARENT_PROP);
        String[] disabledMethods = (String[])hostData.get(DISABLED_METHODS_PROP);
        boolean isStandalone = parent != null && !CLUSTER_TYPE.equals(parent.getType());
        boolean supportsRecursiveRps = Boolean.TRUE.equals(hostData.get(HOST_RECURSIVE_RP_PROP));
        boolean inTransition = !AuthorizationUtil.isOperationAllowed((String[])disabledMethods, (String[])new String[]{HOST_ENTER_MMOD_DISABLED_METHOD}) && !AuthorizationUtil.isOperationAllowed((String[])disabledMethods, (String[])new String[]{HOST_EXIT_MMOD_DISABLED_METHOD});
        return isStandalone && HostSystem.ConnectionState.connected.equals((Object)state) && supportsRecursiveRps && !inTransition;
    }

    private boolean canCreateVappOnComputeResource(ManagedObjectReference compute) {
        Validate.notNull((Object)compute);
        List items = this._queryService.select(new String[]{DISABLED_METHODS_PROP, "grantedPrivileges"}).from(new String[]{RP_TYPE}).where(PARENT_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)compute).fetch().getItems();
        if (items.isEmpty()) {
            return false;
        }
        ResourceItem ri = (ResourceItem)items.get(0);
        String[] grantedPriv = (String[])ri.get("grantedPrivileges");
        String[] disabledMethods = (String[])ri.get(DISABLED_METHODS_PROP);
        return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{CREATE_VAPP_PRIVILEGE}, (String[])grantedPriv) && AuthorizationUtil.isOperationAllowed((String[])new String[]{CREATE_VAPP_METHOD_NAME}, (String[])disabledMethods);
    }
}

