/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp.cluster;

import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.content.registries.Harbor;
import com.vmware.vcenter.namespace_management.Clusters;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.h5.wcp.WCPUtils;
import com.vmware.vsphere.client.h5.wcp.cluster.model.ClusterUpdateSpec;
import com.vmware.vsphere.client.h5.wcp.cluster.model.DisableSpec;
import com.vmware.vsphere.client.h5.wcp.cluster.model.EnableSpec;
import com.vmware.vsphere.client.h5.wcp.cluster.model.HarborCreateSpec;
import com.vmware.vsphere.client.h5.wcp.cluster.model.HarborDisableSpec;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ClusterMutationProvider.class);
    private final Clusters _clusterService;
    private final Harbor _harborService;

    public ClusterMutationProvider(Clusters clusterService, Harbor harborService) {
        this._clusterService = clusterService;
        this._harborService = harborService;
    }

    public OperationResult apply(ManagedObjectReference clusterMoref, EnableSpec spec) {
        OperationResult result = new OperationResult();
        InvocationConfig invocationConfig = ClusterMutationProvider.getInvocationConfig(clusterMoref);
        try {
            this._clusterService.enable(WCPUtils.getFullIdFromMoRef(clusterMoref), spec.enableSpec, invocationConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling WCP Clusters.enable() ", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference clusterMoref, DisableSpec spec) {
        OperationResult result = new OperationResult();
        InvocationConfig invocationConfig = ClusterMutationProvider.getInvocationConfig(clusterMoref);
        try {
            this._clusterService.disable(WCPUtils.getFullIdFromMoRef(clusterMoref), invocationConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling WCP Clusters.disable() ", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterMoRef, HarborCreateSpec spec) {
        OperationResult result = new OperationResult();
        InvocationConfig invocationConfig = ClusterMutationProvider.getInvocationConfig(clusterMoRef);
        try {
            this._harborService.create(null, spec.createSpec, invocationConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling Harbor.create() ", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult remove(URI harborId, HarborDisableSpec disableSpec) {
        OperationResult result = new OperationResult();
        String harbor = VapiUriSchemeUtil.getId((URI)harborId);
        String nodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)harborId);
        InvocationConfig invocationConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
        try {
            this._harborService.delete(harbor, invocationConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling Harbor.delete() ", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterMoref, ClusterUpdateSpec spec) {
        OperationResult result = new OperationResult();
        InvocationConfig invocationConfig = ClusterMutationProvider.getInvocationConfig(clusterMoref);
        try {
            this._clusterService.update(WCPUtils.getFullIdFromMoRef(clusterMoref), spec.updateSpec, invocationConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling WCP Clusters.update() ", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    private static InvocationConfig getInvocationConfig(ManagedObjectReference objectRef) {
        return VapiUtil.newInvocationConfig((String)objectRef.getServerGuid());
    }
}

