/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp.cluster;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.namespace_management.ClusterSizeInfo;
import com.vmware.vcenter.namespace_management.ClusterSizeInfoTypes;
import com.vmware.vcenter.namespace_management.Clusters;
import com.vmware.vcenter.namespace_management.ClustersTypes;
import com.vmware.vcenter.namespace_management.SizingHint;
import com.vmware.vcenter.namespace_management.SupportBundle;
import com.vmware.vcenter.namespace_management.SupportBundleTypes;
import com.vmware.vcenter.namespace_management.certificate_management.TlsCsr;
import com.vmware.vcenter.namespace_management.clusters.Topology;
import com.vmware.vcenter.network.DistributedSwitches;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.commonservice.util.CertificateExtendedUtil;
import com.vmware.vsphere.client.commonservice.util.model.CertificateExtendedInfo;
import com.vmware.vsphere.client.h5.wcp.WCPUtils;
import com.vmware.vsphere.client.h5.wcp.cluster.model.GenCsrSpec;
import com.vmware.vsphere.client.h5.wcp.cluster.model.WcpClusterSizeInfo;
import com.vmware.vsphere.client.h5.wcp.cluster.model.WcpEnableVirtualDistributedSwitchSelectionInfo;
import com.vmware.vsphere.client.h5.wcp.util.StoreEntityAdapter;
import com.vmware.vsphere.client.h5.wcp.util.VcCapabilityCache;
import com.vmware.vsphere.client.h5.wcp.util.WcpCertificateHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WCPClusterPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(WCPClusterPropertyProvider.class);
    private final ClusterSizeInfo _clusterSizeInfoService;
    private final QueryService _queryService;
    private final SupportBundle _supportBundleService;
    private final DistributedSwitches _distributedSwitchesService;
    private final Clusters _clusterService;
    private final TlsCsr _tlsCsrService;
    private final Topology _topologyApi;
    private final VcCapabilityCache _vcVcCapabilityCache;
    private static final String privateKeyAndCertChain = "Private key and certificate chain";
    private static final String workloadPlatformMgmt = "workload-platform-mgt";
    private static final String nsxLoadBalancer = "nsx-load-balancer";
    private static final String WCP_DVS_TYPE = "com.vmware.wcp.DistributedSwitchResourceModel";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_GRANTED_PRIVILEGES = "grantedPrivileges";
    private static final String PROPERTY_CLUSTER_ID = "cluster_id";
    private static final String PROPERTY_WCP_COMPATIBLE = "wcp_compatible";
    private static final String PROPERTY_CLUSTERS = "clusters";
    private final String PROPERTY_GROUP_D1 = "group-d1";
    private final String FOLDER_TYPE = "Folder";
    private final String SUPERVISOR_TYPE = "com.vmware.wcp.SupervisorModel";
    private HashMap<String, String> vcGuidNameMap = new HashMap();
    private final QueryExecutor _queryExecutor;

    public WCPClusterPropertyProvider(ClusterSizeInfo clusterSizeInfoService, QueryServiceFactory queryServiceFactory, SupportBundle supportBundleService, DistributedSwitches distributedSwitchesServiceImpl, Clusters clusterService, TlsCsr tlsCsr, QueryExecutor queryExecutor, Topology topologyApi, VcCapabilityCache vcCapabilityCache) {
        Validate.notNull((Object)clusterSizeInfoService, (String)"clusterSizeInfo is null");
        this._clusterSizeInfoService = clusterSizeInfoService;
        this._queryService = queryServiceFactory.getQueryService();
        this._queryExecutor = queryExecutor;
        this._supportBundleService = supportBundleService;
        this._distributedSwitchesService = distributedSwitchesServiceImpl;
        this._clusterService = clusterService;
        this._tlsCsrService = tlsCsr;
        this._topologyApi = topologyApi;
        this._vcVcCapabilityCache = vcCapabilityCache;
    }

    @ModelMetadata(type={"ClusterComputeResource"}, property="com.vmware.wcp.ClusterModel/clusterSizeInfo")
    public List<WcpClusterSizeInfo> getClusterSizeInfo(ManagedObjectReference clusterRef) throws Exception {
        ArrayList<WcpClusterSizeInfo> clusterSizeInfoList = new ArrayList<WcpClusterSizeInfo>();
        ClusterSizeInfoTypes.Info clusterInfo = new ClusterSizeInfoTypes.Info();
        InvocationConfig invocationConfig = WCPClusterPropertyProvider.getInvocationConfig(clusterRef);
        try {
            Map sizingHintInfoMap = this._clusterSizeInfoService.get(invocationConfig);
            for (SizingHint item : sizingHintInfoMap.keySet()) {
                WcpClusterSizeInfo wcpClusterSizeInfo = new WcpClusterSizeInfo();
                clusterInfo = (ClusterSizeInfoTypes.Info)sizingHintInfoMap.get(item);
                wcpClusterSizeInfo.numSupportedPods = clusterInfo.getNumSupportedPods();
                wcpClusterSizeInfo.numSupportedServices = clusterInfo.getNumSupportedServices();
                wcpClusterSizeInfo.defaultServiceCidr = clusterInfo.getDefaultServiceCidr();
                wcpClusterSizeInfo.defaultPodCidr = clusterInfo.getDefaultPodCidr();
                wcpClusterSizeInfo.masterVmInfo = clusterInfo.getMasterVmInfo();
                wcpClusterSizeInfo.workerVmInfo = clusterInfo.getWorkerVmInfo();
                wcpClusterSizeInfo.name = item.name();
                clusterSizeInfoList.add(wcpClusterSizeInfo);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while getting Cluster Size Info ", (Throwable)ex);
        }
        return clusterSizeInfoList;
    }

    @ModelMetadata(type={"ClusterComputeResource"}, property="com.vmware.wcp.ClusterModel/vCenterName")
    public String getVCenterName(ManagedObjectReference clusterRef) throws Exception {
        String serverGuid = clusterRef.getServerGuid();
        return this.getVCenterName(serverGuid);
    }

    @ModelMetadata(type={"ClusterComputeResource"}, property="com.vmware.wcp.ClusterModel/vCenter")
    public ManagedObjectReference getVCenter(ManagedObjectReference clusterRef) throws Exception {
        String serverGuid = clusterRef.getServerGuid();
        ManagedObjectReference vcenterRef = new ManagedObjectReference("Folder", "group-d1", serverGuid);
        return vcenterRef;
    }

    @ModelMetadata(type={"com.vmware.wcp.SupervisorModel"}, property="com.vmware.wcp.SupervisorModel/vCenter")
    public ManagedObjectReference getVCenter(URI supervisorUri) throws Exception {
        String serverGuid = VapiUriSchemeUtil.getNodeUuid((URI)supervisorUri);
        ManagedObjectReference vcenterRef = new ManagedObjectReference("Folder", "group-d1", serverGuid);
        return vcenterRef;
    }

    @ModelMetadata(type={"com.vmware.wcp.SupervisorModel"}, property="com.vmware.wcp.SupervisorModel/vCenterName")
    public String getVCenterName(URI supervisorUri) throws Exception {
        String serverGuid = VapiUriSchemeUtil.getNodeUuid((URI)supervisorUri);
        return this.getVCenterName(serverGuid);
    }

    private String getVCenterName(String serverGuid) {
        String vcName = this.vcGuidNameMap.get(serverGuid);
        if (vcName != null) {
            return vcName;
        }
        vcName = VcServiceUtil.getServiceName((String)serverGuid);
        this.vcGuidNameMap.put(serverGuid, vcName);
        return vcName;
    }

    @ModelMetadata(type={"ClusterComputeResource"}, property="com.vmware.wcp.ClusterModel/compatibleDistributedSwitches")
    public List<WcpEnableVirtualDistributedSwitchSelectionInfo> getCompatibleDistributedSwitches(ManagedObjectReference clusterRef) {
        List wcpCompatibleClusterDvses = this._queryService.select(new String[]{"@modelKey", PROPERTY_NAME}).from(new String[]{WCP_DVS_TYPE}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(PROPERTY_CLUSTER_ID, PropertyPredicate.ComparisonOperator.EQUAL, (Object)clusterRef), new PropertyPredicate(PROPERTY_WCP_COMPATIBLE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true)}).fetch().getItems();
        ArrayList<WcpEnableVirtualDistributedSwitchSelectionInfo> switchSelectionInfos = new ArrayList<WcpEnableVirtualDistributedSwitchSelectionInfo>();
        for (ResourceItem vdsItem : wcpCompatibleClusterDvses) {
            WcpEnableVirtualDistributedSwitchSelectionInfo dvsSelectionInfo = new WcpEnableVirtualDistributedSwitchSelectionInfo();
            dvsSelectionInfo.vapiId = vdsItem.get("@modelKey").toString();
            dvsSelectionInfo.name = (String)vdsItem.get(PROPERTY_NAME);
            switchSelectionInfos.add(dvsSelectionInfo);
        }
        return switchSelectionInfos;
    }

    @type(value="ClusterComputeResource")
    public SupportBundleTypes.Location getSupportBundleLocation(ManagedObjectReference clusterRef) throws Exception {
        SupportBundleTypes.Location location = new SupportBundleTypes.Location();
        InvocationConfig invocationConfig = WCPClusterPropertyProvider.getInvocationConfig(clusterRef);
        try {
            location = this._supportBundleService.create(WCPUtils.getFullIdFromMoRef(clusterRef), invocationConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while getting support bundle for cluster", (Throwable)ex);
        }
        return location;
    }

    @ModelMetadata(type={"ClusterComputeResource"}, property="com.vmware.wcp.ClusterModel/workloadPlatformCertificate")
    public StoreEntityAdapter getworkloadPlatformCertificate(ManagedObjectReference clusterRef) throws Exception {
        InvocationConfig invocationConfig = WCPClusterPropertyProvider.getInvocationConfig(clusterRef);
        StoreEntityAdapter storeEntityAdapter = null;
        CertificateExtendedInfo certInfo = null;
        try {
            ClustersTypes.Info info = this._clusterService.get(WCPUtils.getFullIdFromMoRef(clusterRef), invocationConfig);
            certInfo = CertificateExtendedUtil.getCertificateExtendedInfo((String)info.getTlsEndpointCertificate());
            storeEntityAdapter = WcpCertificateHelper.tlsTypesToVecsEntry(certInfo, workloadPlatformMgmt, privateKeyAndCertChain);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while getting workload Platform Certificate", (Throwable)ex);
        }
        return storeEntityAdapter;
    }

    @ModelMetadata(type={"ClusterComputeResource"}, property="com.vmware.wcp.ClusterModel/nsxLoadBalancerCertificate")
    public StoreEntityAdapter getLoadBalancerCertificate(ManagedObjectReference clusterRef) throws Exception {
        InvocationConfig invocationConfig = WCPClusterPropertyProvider.getInvocationConfig(clusterRef);
        StoreEntityAdapter storeEntityAdapter = null;
        CertificateExtendedInfo certInfo = null;
        try {
            ClustersTypes.Info info = this._clusterService.get(WCPUtils.getFullIdFromMoRef(clusterRef), invocationConfig);
            certInfo = CertificateExtendedUtil.getCertificateExtendedInfo((String)info.getNcpClusterNetworkInfo().getDefaultIngressTlsCertificate());
            storeEntityAdapter = WcpCertificateHelper.tlsTypesToVecsEntry(certInfo, nsxLoadBalancer, privateKeyAndCertChain);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while getting nsx Load Balancer Certificate", (Throwable)ex);
        }
        return storeEntityAdapter;
    }

    @ModelMetadata(type={"ClusterComputeResource"}, property="com.vmware.wcp.ClusterModel/workLoadCSR")
    public String getWorkLoadCSR(ManagedObjectReference clusterRef, GenCsrSpec genCsrSpec) throws Exception {
        InvocationConfig invocationConfig = WCPClusterPropertyProvider.getInvocationConfig(clusterRef);
        String csr = null;
        try {
            csr = this._tlsCsrService.create(WCPUtils.getFullIdFromMoRef(clusterRef), genCsrSpec.spec, invocationConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while getting csr ", (Throwable)ex);
        }
        return csr;
    }

    @ModelMetadata(type={"ClusterComputeResource"}, property="com.vmware.wcp.ClusterModel/loadBalancerCSR")
    public String getloadBalancerCSR(ManagedObjectReference clusterRef, GenCsrSpec genCsrSpec) throws Exception {
        InvocationConfig invocationConfig = WCPClusterPropertyProvider.getInvocationConfig(clusterRef);
        String csr = null;
        try {
            csr = this._tlsCsrService.createNcpDefaultIngressTls(WCPUtils.getFullIdFromMoRef(clusterRef), genCsrSpec.spec, invocationConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while getting csr ", (Throwable)ex);
        }
        return csr;
    }

    @type(value="ClusterComputeResource")
    public int getRelatedNamespacesCount(ManagedObjectReference clusterRef) {
        String supervisorId = null;
        if (this._vcVcCapabilityCache.isZoneSupported(clusterRef.getServerGuid())) {
            try {
                supervisorId = this._topologyApi.get(clusterRef.getValue(), WCPClusterPropertyProvider.getInvocationConfig(clusterRef));
            }
            catch (Exception ex) {
                _logger.error((Object)("Failed to get supervisorId for cluster " + clusterRef.toString()), (Throwable)ex);
            }
        }
        PropertyConstraint workloadModelConstraint = supervisorId != null && !supervisorId.isEmpty() ? QueryUtil.createPropertyConstraint((String)"com.vmware.wcp.WorkloadModel", (String)"supervisor_id", (Comparator)Comparator.EQUALS, (Object)supervisorId) : QueryUtil.createPropertyConstraint((String)"com.vmware.wcp.WorkloadModel", (String)"cluster", (Comparator)Comparator.EQUALS, (Object)clusterRef);
        QuerySpec workloadModelQuerySpec = QueryUtil.buildQuerySpec((Constraint)workloadModelConstraint, (String[])new String[0]);
        workloadModelQuerySpec.resultSpec = new ResultSpec();
        workloadModelQuerySpec.resultSpec.maxResultCount = 0;
        try {
            ResultSet workloadModelResultSet = this._queryExecutor.getData(workloadModelQuerySpec);
            return workloadModelResultSet.totalMatchedObjectCount;
        }
        catch (Exception ex) {
            if (supervisorId != null && !supervisorId.isEmpty()) {
                _logger.error((Object)("Failed to retrieve WorkloadModel count for supervisor " + supervisorId), (Throwable)ex);
            } else {
                _logger.error((Object)("Failed to retrieve WorkloadModel count for cluster " + clusterRef.toString()), (Throwable)ex);
            }
            return 0;
        }
    }

    private static InvocationConfig getInvocationConfig(ManagedObjectReference objectRef) {
        return VapiUtil.newInvocationConfig((String)objectRef.getServerGuid());
    }

    @type(value="HostSystem")
    public boolean getHasWcpNsxtClusterParent(ManagedObjectReference hostRef) throws Exception {
        PropertyValue[] result = this._queryExecutor.getProperties((Object)hostRef, new String[]{"parent"});
        if (result.length == 0) {
            return false;
        }
        ManagedObjectReference clusterRef = (ManagedObjectReference)result[0].value;
        InvocationConfig invocationConfig = WCPClusterPropertyProvider.getInvocationConfig(clusterRef);
        try {
            ClustersTypes.Info info = this._clusterService.get(WCPUtils.getFullIdFromMoRef(clusterRef), invocationConfig);
            if (info == null) {
                return false;
            }
            ClustersTypes.NetworkProvider provider = info.getNetworkProvider();
            return provider == null || provider.isUnknown() || ClustersTypes.NetworkProvider.NSXT_CONTAINER_PLUGIN.equals((Object)provider);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @ModelMetadata(type={"com.vmware.wcp.SupervisorModel"}, property="com.vmware.wcp.SupervisorModel/grantedPrivileges")
    public String[] getGrantedPrivileges(URI resourceObject) {
        List clustersInSupervisorItems = this._queryService.select(new String[]{PROPERTY_CLUSTERS}).from(new String[]{"com.vmware.wcp.SupervisorModel"}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)resourceObject).fetch().getItems();
        if (clustersInSupervisorItems.isEmpty()) {
            return null;
        }
        List clusterRefs = (List)((ResourceItem)clustersInSupervisorItems.get(0)).get(PROPERTY_CLUSTERS);
        List clusterPrivilegeItems = this._queryService.select(new String[]{PROPERTY_GRANTED_PRIVILEGES}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, (Object)clusterRefs).fetch().getItems();
        if (clusterPrivilegeItems.isEmpty()) {
            return null;
        }
        Collection<String> commonPrivileges = Arrays.asList((String[])((ResourceItem)clusterPrivilegeItems.get(0)).get(PROPERTY_GRANTED_PRIVILEGES));
        for (int i = 1; i < clusterPrivilegeItems.size(); ++i) {
            List<String> privileges = Arrays.asList((String[])((ResourceItem)clusterPrivilegeItems.get(i)).get(PROPERTY_GRANTED_PRIVILEGES));
            commonPrivileges = CollectionUtils.intersection(commonPrivileges, privileges);
        }
        return commonPrivileges.toArray(new String[0]);
    }
}

