/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp.namespace;

import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.content.registries.harbor.Projects;
import com.vmware.vcenter.namespaces.Access;
import com.vmware.vcenter.namespaces.Instances;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.h5.wcp.WCPUtils;
import com.vmware.vsphere.client.h5.wcp.namespace.model.AddPermissionSpec;
import com.vmware.vsphere.client.h5.wcp.namespace.model.CreateSpec;
import com.vmware.vsphere.client.h5.wcp.namespace.model.ProjectPurgeSpec;
import com.vmware.vsphere.client.h5.wcp.namespace.model.RemovePermissionSpec;
import com.vmware.vsphere.client.h5.wcp.namespace.model.RemoveSpec;
import com.vmware.vsphere.client.h5.wcp.namespace.model.UpdatePermissionSpec;
import com.vmware.vsphere.client.h5.wcp.namespace.model.UpdateSpec;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamespaceMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(NamespaceMutationProvider.class);
    private final String RESOURCE_MODEL_WORKLOAD_PERMISSION = "com.vmware.wcp.WorkloadPermissionModel";
    private final Instances _workloadService;
    private final Access _workloadPermissionService;
    private final Projects _projectService;

    public NamespaceMutationProvider(Instances workloadService, Access workloadPermissionService, Projects projectService) {
        this._workloadService = workloadService;
        this._workloadPermissionService = workloadPermissionService;
        this._projectService = projectService;
    }

    public OperationResult add(CreateSpec spec) {
        OperationResult result = new OperationResult();
        String fullyQualifiedClusterId = spec.createSpec.getCluster();
        ManagedObjectReference clusterMoRef = ManagedObjectUtil.stringToMoref((String)fullyQualifiedClusterId);
        String clusterMoId = WCPUtils.getFullIdFromMoRef(clusterMoRef);
        InvocationConfig invocationConfig = NamespaceMutationProvider.getInvocationConfig(clusterMoRef);
        result.entity = fullyQualifiedClusterId;
        try {
            spec.createSpec.setCluster(clusterMoId);
            this._workloadService.create(spec.createSpec, invocationConfig);
            result.result = VapiUriSchemeUtil.createUri((String)"com.vmware.wcp.WorkloadModel", (String)spec.createSpec.getNamespace(), (String)clusterMoRef.getServerGuid());
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling WCP Instances.create() ", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult apply(URI workloadId, UpdateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = workloadId;
        String workload = VapiUriSchemeUtil.getId((URI)workloadId);
        try {
            String nodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)workloadId);
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
            this._workloadService.update(workload, spec.updateSpec, invConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling WCP Instances.update()", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult apply(URI workloadId, AddPermissionSpec addPermissionSpec) {
        OperationResult result = new OperationResult();
        result.entity = workloadId;
        String workload = VapiUriSchemeUtil.getId((URI)workloadId);
        try {
            String nodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)workloadId);
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
            this._workloadPermissionService.create(workload, addPermissionSpec.domain, addPermissionSpec.subject, addPermissionSpec.subjectType, addPermissionSpec.spec, invConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling Access.create() on a Workload", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult apply(URI workloadId, UpdatePermissionSpec updatePermissionSpec) {
        OperationResult result = new OperationResult();
        result.entity = workloadId;
        String workload = VapiUriSchemeUtil.getId((URI)workloadId);
        try {
            String nodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)workloadId);
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
            this._workloadPermissionService.set(workload, updatePermissionSpec.domain, updatePermissionSpec.subject, updatePermissionSpec.subjectType, updatePermissionSpec.spec, invConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling Access.set() on a Workload", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult remove(URI workloadId, RemovePermissionSpec removePermissionSpec) {
        OperationResult result = new OperationResult();
        String nodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)workloadId);
        result.entity = VapiUriSchemeUtil.createUri((String)"com.vmware.wcp.WorkloadPermissionModel", (String)(removePermissionSpec.subject + "@" + removePermissionSpec.domain), (String)nodeUuid);
        String workload = VapiUriSchemeUtil.getId((URI)workloadId);
        try {
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
            this._workloadPermissionService.delete(workload, removePermissionSpec.domain, removePermissionSpec.subject, removePermissionSpec.subjectType, invConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling Access.delete() on a Workload", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult remove(URI projectUri, ProjectPurgeSpec projectPurgeSpec) {
        OperationResult result = new OperationResult();
        result.entity = projectUri;
        String project = VapiUriSchemeUtil.getId((URI)projectUri);
        try {
            String nodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)projectUri);
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
            this._projectService.purge(projectPurgeSpec.harborId, project, invConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling Project.purge()", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult remove(URI workloadId, RemoveSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = workloadId;
        try {
            String nodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)workloadId);
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
            this._workloadService.delete(VapiUriSchemeUtil.getId((URI)workloadId), invConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling WCP Instances.remove() ", (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    private static InvocationConfig getInvocationConfig(ManagedObjectReference objectRef) {
        return VapiUtil.newInvocationConfig((String)objectRef.getServerGuid());
    }
}

