/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.poweractions;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.client.ApiClient;
import com.vmware.vapi.client.ApiClients;
import com.vmware.vapi.client.Configuration;
import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vapi.security.UserPassSecurityContext;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vcenter.apigw.api.sso.SsoService;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.vapi.DefaultVapiConnectionControl;
import com.vmware.vsphere.client.h5.poweractions.ExecutionHostAuthorizationProvider;
import com.vmware.vsphere.client.h5.poweractions.ExecutionHostClient;
import java.net.SocketException;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;

public class ExecutionHostApiClientProvider {
    private static final Log _logger = LogFactory.getLog(ExecutionHostApiClientProvider.class);
    private final SsoService _ssoService;
    private final UserSessionService _userSessionService;
    private ExecutionHostAuthorizationProvider _authenticator;
    private ExecutionHostClient _client;

    public ExecutionHostApiClientProvider(SsoService ssoService, UserSessionService userSessionService) {
        this._ssoService = ssoService;
        this._userSessionService = userSessionService;
    }

    public ExecutionHostClient getClient(String executionHostUrl, ClassLoader classLoader) {
        if (this._client == null) {
            this._client = this.createNewApiClient(executionHostUrl, classLoader);
        }
        return this._client;
    }

    public void closeClientConnection() {
        if (this._client != null) {
            this._client.closeClientConnection();
        }
        this._client = null;
    }

    public boolean isAuthenticated(String clientId) {
        return this._authenticator != null && this._authenticator.isAuthenticated(clientId);
    }

    public void clearAuthState(String clientId) {
        if (this._authenticator != null) {
            this._authenticator.clearState(clientId);
        }
    }

    private ExecutionHostClient createNewApiClient(String executionHostUrl, ClassLoader classLoader) {
        this._authenticator = new ExecutionHostAuthorizationProvider(this._ssoService, this._userSessionService, executionHostUrl);
        Configuration apiHttpConfiguration = this.createApiClientConfiguration();
        ApiClient apiClient = ApiClients.newRestClient((String)executionHostUrl, (Configuration)apiHttpConfiguration);
        return new ExecutionHostClient(apiClient, classLoader);
    }

    private Configuration createApiClientConfiguration() {
        HttpConfiguration.Builder builder = new HttpConfiguration.Builder();
        builder.setHeadersProvider((HttpConfiguration.HeadersProvider)this._authenticator);
        StubConfiguration stubConfig = new StubConfiguration();
        RetryPolicy retryPolicy = this.getRetryPolicy();
        stubConfig.setRetryPolicy(retryPolicy);
        UserPassSecurityContext securityContext = new UserPassSecurityContext("", new char[0]);
        stubConfig.setSecurityContext((ExecutionContext.SecurityContext)securityContext);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vapi.stub.config", stubConfig);
        map.put("http.client.config", builder.getConfig());
        Configuration.Builder configurationBuilder = new Configuration.Builder(map);
        return configurationBuilder.build();
    }

    private RetryPolicy getRetryPolicy() {
        return new RetryPolicy(){

            public RetryPolicy.RetrySpec onInvocationError(RuntimeException exceptionToRetry, RetryPolicy.RetryContext ctx, int invocationAttempt) {
                try {
                    if (exceptionToRetry instanceof Unauthenticated) {
                        HttpSession httpSession = SessionUtil.getHttpSession();
                        String clientId = SessionUtil.getClientId((HttpSession)httpSession);
                        ExecutionHostApiClientProvider.this._authenticator.clearState(clientId);
                    } else {
                        Throwable cause = exceptionToRetry.getCause();
                        if (cause != null) {
                            cause = cause.getCause();
                        }
                        if (exceptionToRetry instanceof TransportProtocolException || cause instanceof ConnectTimeoutException || cause instanceof HttpHostConnectException || cause instanceof SocketException) {
                            ExecutionHostApiClientProvider.this._authenticator.clearAllState();
                            ExecutionHostApiClientProvider.this.closeClientConnection();
                        }
                    }
                    boolean shouldRetry = new DefaultVapiConnectionControl().retryOnError(exceptionToRetry, ctx, invocationAttempt);
                    if (shouldRetry) {
                        return new RetryPolicy.RetrySpec(new InvocationConfig(ctx.getExecutionContext()));
                    }
                    return null;
                }
                catch (RuntimeException e) {
                    _logger.error((Object)e);
                    return null;
                }
            }
        };
    }
}

