/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.poweractions;

import com.vmware.ses.model.ScriptExecutionResponse;
import com.vmware.ses.model.ScriptExecutionStreams;
import com.vmware.vsphere.client.h5.poweractions.execution.ScriptExecutionService;
import com.vmware.vsphere.client.h5.poweractions.library.ScriptLibraryService;
import com.vmware.vsphere.client.h5.poweractions.model.ArgumentScript;
import com.vmware.vsphere.client.h5.poweractions.model.ExecuteScriptResult;
import com.vmware.vsphere.client.h5.poweractions.model.ExecutionHostDetails;
import com.vmware.vsphere.client.h5.poweractions.model.ScriptContent;
import com.vmware.vsphere.client.h5.poweractions.model.ScriptExecutionOutput;
import com.vmware.vsphere.client.h5.poweractions.model.ScriptLibrary;
import com.vmware.vsphere.client.h5.poweractions.model.ScriptLibraryItem;
import com.vmware.vsphere.client.h5.poweractions.specs.ExecuteScriptSpec;
import com.vmware.vsphere.client.h5.poweractions.specs.ParamSpec;
import com.vmware.vsphere.client.h5.poweractions.specs.ScriptSpec;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/poweractions"})
public class PowerActionsController {
    private final ScriptExecutionService _executionService;
    private final ScriptLibraryService _libraryService;

    public PowerActionsController(ScriptExecutionService executionService, ScriptLibraryService libraryService) {
        this._executionService = executionService;
        this._libraryService = libraryService;
    }

    @RequestMapping(value={"/scriptsExecutions"}, method={RequestMethod.GET})
    @ResponseBody
    public ScriptExecutionResponse[] getScriptsExecutions() {
        return this._executionService.retrieveScriptsExecutions();
    }

    @RequestMapping(value={"/script/result"}, method={RequestMethod.POST})
    @ResponseBody
    public ExecuteScriptResult getScriptExecutionResult(@RequestBody ScriptSpec spec) {
        if (spec.isPersistent) {
            return this._executionService.getPersistentScriptExecutionResult(spec);
        }
        return this._executionService.getNonPersistentScriptExecutionResult(spec);
    }

    @RequestMapping(value={"/script/run"}, method={RequestMethod.POST})
    @ResponseBody
    public ExecuteScriptResult executeScript(@RequestBody ExecuteScriptSpec spec) {
        return this._executionService.executeScript(spec);
    }

    @RequestMapping(value={"/script/stop"}, method={RequestMethod.POST})
    @ResponseBody
    public void stopScriptExecution(@RequestBody String scriptId) {
        this._executionService.stopScriptExecution(scriptId);
    }

    @RequestMapping(value={"/script/output"}, method={RequestMethod.POST})
    @ResponseBody
    public ScriptExecutionOutput getScriptExecutionOutput(@RequestBody String scriptId) {
        return this._executionService.getScriptExecutionOutput(scriptId);
    }

    @RequestMapping(value={"/script/console/output"}, method={RequestMethod.POST})
    @ResponseBody
    public ScriptExecutionOutput getConsoleExecutionOutput(@RequestBody String scriptId) {
        return this._executionService.getConsoleExecutionOutput(scriptId);
    }

    @RequestMapping(value={"/script/streams"}, method={RequestMethod.POST})
    @ResponseBody
    public ScriptExecutionStreams getScriptExecutionStream(@RequestBody String scriptId) {
        return this._executionService.getScriptExecutionStreams(scriptId);
    }

    @RequestMapping(value={"/argumentScripts"}, method={RequestMethod.POST})
    @ResponseBody
    public ArgumentScript getArgumentScript(@RequestBody ParamSpec spec) {
        return this._executionService.getArgumentScript(spec);
    }

    @RequestMapping(value={"/hostDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public ExecutionHostDetails hostDetails() {
        return this._executionService.retrieveExecutionHostDetails();
    }

    @RequestMapping(value={"/destroyDefaultRunspace"}, method={RequestMethod.POST})
    @ResponseBody
    public void destroyDefaultScriptExecutionRunspace() {
        this._executionService.destroyDefaultRunspace();
    }

    @RequestMapping(value={"/runspace/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void destroyRunspace(@RequestBody String id) {
        this._executionService.destroyRunspace(id);
    }

    @RequestMapping(value={"/scriptLibraries"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ScriptLibrary> getScriptLibraries() {
        return this._libraryService.getScriptLibraries();
    }

    @RequestMapping(value={"/scriptLibraryItems"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ScriptLibraryItem> getScriptLibraryItems(@RequestParam(value="libraryUri", required=true) String libraryUri) {
        return this._libraryService.getScriptLibraryItems(libraryUri);
    }

    @RequestMapping(value={"/scriptLibraryItemContent"}, method={RequestMethod.GET})
    @ResponseBody
    public ScriptContent getScriptLibraryItemContent(@RequestParam(value="libraryItemUri", required=true) String libraryItemUri) throws Exception {
        return this._libraryService.getScriptLibraryItemContent(libraryItemUri);
    }
}

