/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.poweractions.library;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.content.LibraryModel;
import com.vmware.content.library.item.DownloadSession;
import com.vmware.content.library.item.DownloadSessionModel;
import com.vmware.content.library.item.File;
import com.vmware.content.library.item.FileTypes;
import com.vmware.content.library.item.downloadsession.FileTypes;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.h5.poweractions.library.ScriptLibraryService;
import com.vmware.vsphere.client.h5.poweractions.model.ScriptContent;
import com.vmware.vsphere.client.h5.poweractions.model.ScriptLibrary;
import com.vmware.vsphere.client.h5.poweractions.model.ScriptLibraryItem;
import com.vmware.vsphere.client.h5.poweractions.utils.PowerActionsUtil;
import com.vmware.vsphere.client.h5.poweractions.utils.ScriptParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ScriptLibraryServiceImpl
implements ScriptLibraryService {
    private static final Log _logger = LogFactory.getLog(ScriptLibraryServiceImpl.class);
    public static final String LIBRARY_ITEM_MODEL = "com.vmware.content.library.ItemModel";
    private static final String SCRIPT_LIBRARY_ITEM_TYPE = "script";
    private static final String LIBRARY_ITEM_TYPE_PROPERTY = "com.vmware.content.library.ItemModel/type";
    private static final String LIBRARY_ITEM_LIBRARY_ID_PROPERTY = "com.vmware.content.library.ItemModel/libraryId";
    private static final String LIBRARY_ITEM_NAME_PROPERTY = "com.vmware.content.library.ItemModel/name";
    private static final String LIBRARY_ITEM_ID_PROPERTY = "com.vmware.content.library.ItemModel/id";
    private static final String LIBRARY_ITEM_DESCRIPTION_PROPERTY = "com.vmware.content.library.ItemModel/description";
    private static final String LIBRARY_ITEM_MODIFIED_TIME_PROPERTY = "com.vmware.content.library.ItemModel/lastModifiedTime.@formatted";
    private static final String LIBRARY_ITEM_SYNC_TIME_PROPERTY = "com.vmware.content.library.ItemModel/lastSyncTime.@formatted";
    private static final String LIBRARY_ITEM_LIBRARY_NAME_PROPERTY = "com.vmware.content.library.ItemModel/libraryName";
    private static final String LIBRARY_ITEM_SIZE_PROPERTY = "com.vmware.content.library.ItemModel/size.@formatted";
    private static final String LIBRARY_ITEM_VERSION_PROPERTY = "com.vmware.content.library.ItemModel/contentVersion";
    private static final String LIBRARY_MODEL = "com.vmware.content.LibraryModel";
    private static final String LIBRARY_NAME_PROPERTY = "com.vmware.content.LibraryModel/name";
    private static final String LIBRARY_ID_PROPERTY = "com.vmware.content.LibraryModel/id";
    private static final String LIBRARY_TYPE_PROPERTY = "com.vmware.content.LibraryModel/type";
    private static final int SESSION_STATE_POLL_LIMIT = 10;
    private final QueryService _queryService;
    private final File _fileService;
    private final KeystoreService _keystoreService;
    private final DownloadSession _downloadSession;
    private final com.vmware.content.library.item.downloadsession.File _downloadSessionFile;

    public ScriptLibraryServiceImpl(QueryServiceFactory queryServiceFactory, File fileService, KeystoreService keystoreService, DownloadSession downloadSession, com.vmware.content.library.item.downloadsession.File downloadSessionFile) {
        this._queryService = queryServiceFactory.getQueryService();
        this._fileService = fileService;
        this._keystoreService = keystoreService;
        this._downloadSession = downloadSession;
        this._downloadSessionFile = downloadSessionFile;
    }

    @Override
    public List<ScriptLibrary> getScriptLibraries() {
        ResultSet librariesResult = this._queryService.select(new String[]{LIBRARY_ID_PROPERTY, LIBRARY_NAME_PROPERTY, LIBRARY_TYPE_PROPERTY}).from(new String[]{LIBRARY_MODEL}).fetch();
        ArrayList<ScriptLibrary> scriptLibraries = new ArrayList<ScriptLibrary>(librariesResult.getItems().size());
        for (ResourceItem resultItem : librariesResult.getItems()) {
            ScriptLibrary scriptLibrary = new ScriptLibrary();
            URI libraryUri = (URI)resultItem.get(LIBRARY_ID_PROPERTY);
            scriptLibrary.id = libraryUri.toString();
            scriptLibrary.name = (String)resultItem.get(LIBRARY_NAME_PROPERTY);
            LibraryModel.LibraryType libraryType = (LibraryModel.LibraryType)resultItem.get(LIBRARY_TYPE_PROPERTY);
            scriptLibrary.isLocalLibrary = LibraryModel.LibraryType.LOCAL.equals((Object)libraryType);
            scriptLibraries.add(scriptLibrary);
        }
        return scriptLibraries;
    }

    @Override
    public List<ScriptLibraryItem> getScriptLibraryItems(String libraryUri) {
        ResultSet resultSet = this._queryService.select(new String[]{LIBRARY_ITEM_ID_PROPERTY, LIBRARY_ITEM_NAME_PROPERTY, LIBRARY_ITEM_DESCRIPTION_PROPERTY, LIBRARY_ITEM_SYNC_TIME_PROPERTY, LIBRARY_ITEM_MODIFIED_TIME_PROPERTY, LIBRARY_ITEM_LIBRARY_NAME_PROPERTY, LIBRARY_ITEM_SIZE_PROPERTY, LIBRARY_ITEM_VERSION_PROPERTY}).from(new String[]{LIBRARY_ITEM_MODEL}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(LIBRARY_ITEM_TYPE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)SCRIPT_LIBRARY_ITEM_TYPE), new PropertyPredicate(LIBRARY_ITEM_LIBRARY_ID_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)PowerActionsUtil.getVapiUriObjectId(libraryUri))}).fetch();
        ArrayList<ScriptLibraryItem> scriptItems = new ArrayList<ScriptLibraryItem>(resultSet.getItems().size());
        for (ResourceItem resultItem : resultSet.getItems()) {
            ScriptLibraryItem scriptLibraryItem = new ScriptLibraryItem();
            scriptLibraryItem.name = (String)resultItem.get(LIBRARY_ITEM_NAME_PROPERTY);
            URI libraryItem = (URI)resultItem.get(LIBRARY_ITEM_ID_PROPERTY);
            scriptLibraryItem.id = libraryItem.toString();
            scriptLibraryItem.description = (String)resultItem.get(LIBRARY_ITEM_DESCRIPTION_PROPERTY);
            scriptLibraryItem.lastModifiedDate = (String)resultItem.get(LIBRARY_ITEM_MODIFIED_TIME_PROPERTY);
            scriptLibraryItem.lastSyncDate = (String)resultItem.get(LIBRARY_ITEM_SYNC_TIME_PROPERTY);
            scriptLibraryItem.size = (String)resultItem.get(LIBRARY_ITEM_SIZE_PROPERTY);
            scriptLibraryItem.libraryName = (String)resultItem.get(LIBRARY_ITEM_LIBRARY_NAME_PROPERTY);
            scriptLibraryItem.version = PowerActionsUtil.getLibraryItemContentVersion(resultItem.get(LIBRARY_ITEM_VERSION_PROPERTY).toString());
            scriptLibraryItem.scriptType = this.getScriptFileExtension(libraryItem);
            scriptItems.add(scriptLibraryItem);
        }
        return scriptItems;
    }

    @Override
    public ScriptContent getScriptLibraryItemContent(String libraryItemUri) throws Exception {
        ScriptContent scriptContent = new ScriptContent();
        String libraryItemNodeUuid = PowerActionsUtil.getVapiUriNodeId(libraryItemUri);
        String libraryItemId = PowerActionsUtil.getVapiUriObjectId(libraryItemUri);
        DownloadSessionModel downloadSpec = new DownloadSessionModel();
        downloadSpec.setLibraryItemId(libraryItemId);
        String newClientToken = VapiUtil.newClientToken();
        InvocationConfig downloadSessionInvConfig = VapiUtil.newInvocationConfig((String)libraryItemNodeUuid, (String)newClientToken);
        String downloadSessionId = this._downloadSession.create(newClientToken, downloadSpec, downloadSessionInvConfig);
        InvocationConfig invocationConfig = VapiUtil.newInvocationConfig((String)libraryItemNodeUuid);
        List filesToDownload = this._downloadSessionFile.list(downloadSessionId, invocationConfig);
        if (!filesToDownload.isEmpty()) {
            String content;
            String fileName = ((FileTypes.Info)filesToDownload.get(0)).getName();
            FileTypes.Info downloadFileInfo = this._downloadSessionFile.prepare(downloadSessionId, fileName, null, invocationConfig);
            for (int counter = 0; counter <= 10 && !FileTypes.PrepareStatus.PREPARED.equals((Object)(downloadFileInfo = this._downloadSessionFile.get(downloadSessionId, fileName, invocationConfig)).getStatus()); ++counter) {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            if (downloadFileInfo == null || downloadFileInfo.getDownloadEndpoint() == null) {
                return scriptContent;
            }
            URI downloadUri = downloadFileInfo.getDownloadEndpoint().getUri();
            VcService vcService = VimSessionUtil.getService((String)libraryItemNodeUuid);
            scriptContent.body = content = this.downloadLibraryItemFromURI(downloadUri, vcService.getThumbprint());
            scriptContent.params = ScriptParser.extractScriptParams(content);
            this._downloadSession.delete(downloadSessionId, downloadSessionInvConfig);
        }
        return scriptContent;
    }

    private String getScriptFileExtension(URI libraryItem) {
        String libraryItemNodeUuid;
        InvocationConfig invConfig;
        if (libraryItem == null || this._fileService == null) {
            return null;
        }
        String libraryItemId = VapiUriSchemeUtil.getId((URI)libraryItem);
        List files = this._fileService.list(libraryItemId, invConfig = VapiUtil.newInvocationConfig((String)(libraryItemNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)libraryItem))));
        if (files.isEmpty()) {
            return null;
        }
        return FilenameUtils.getExtension((String)((FileTypes.Info)files.get(0)).getName());
    }

    private String downloadLibraryItemFromURI(URI downloadUri, String thumbprint) {
        String content = "";
        try {
            SSLContext sslContext;
            SSLBuilder builder = new SSLBuilder();
            if (thumbprint != null) {
                builder = builder.thumbprint(thumbprint);
                SSLBuilder.SSLContextAndHostnameVerifier ctxAndVerifier = builder.buildSSLContext();
                sslContext = ctxAndVerifier.getSslContext();
            } else {
                sslContext = builder.buildAllowAllSSLContext();
            }
            CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContext).build();
            HttpGet httpGet = new HttpGet(downloadUri);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            content = response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity()) : "";
        }
        catch (Exception ex) {
            _logger.error((Object)"System Error: Unable to download the script file content.", (Throwable)ex);
        }
        return content;
    }
}

