/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.poweractions.utils;

import com.vmware.ses.model.ArgumentScriptParameter;
import com.vmware.ses.model.ScriptParameterBoolean;
import com.vmware.ses.model.ScriptParameterString;
import com.vmware.ses.model.ScriptParameterStringArray;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.poweractions.specs.ParamSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptParser {
    private static final Log _logger = LogFactory.getLog(ScriptParser.class);
    private static final String START_PARAM_SECTION = "param(";
    private static final String START_PARAM_TAG = "[parameter(";
    private static final String END_PARAM_TAG = ")]";
    private static final String IS_MANDATORY_TAG = "mandatory=$true";
    private static final String COMMA_SEPARATOR = ",";
    private static final String VAPI_PREFIX = "urn:vapi:";
    public static final Set<String> numberPowerCliTypes = new HashSet<String>(Arrays.asList("double", "system.double", "float", "single", "system.single", "decimal", "system.decimal"));
    public static final Set<String> integerPowerCliTypes = new HashSet<String>(Arrays.asList("int", "system.int32", "long", "system.int64"));
    public static final Set<String> booleanPowerCliTypes = new HashSet<String>(Arrays.asList("bool", "system.boolean", "switch", "?"));
    public static final Set<String> stringPowerCliTypes = new HashSet<String>(Arrays.asList("string", "system.string", "char", "system.char"));
    public static final Set<String> datePowerCliTypes = new HashSet<String>(Arrays.asList("datetime", "system.datetime"));

    public static List<ParamSpec> extractScriptParams(String scriptContent) {
        ArrayList<ParamSpec> params = new ArrayList<ParamSpec>();
        try {
            if (StringUtils.isEmpty((CharSequence)scriptContent)) {
                return params;
            }
            String trimmedScriptContent = scriptContent.replaceAll("[\\n\\t\\r]", "").replaceAll("\\s+", "");
            String paramSection = ScriptParser.extractParamSection(trimmedScriptContent);
            if (StringUtils.isEmpty((CharSequence)paramSection)) {
                return params;
            }
            List<String> parameterTags = ScriptParser.findAllParameterTags(paramSection);
            for (String paramTag : parameterTags) {
                paramSection = paramSection.replace(paramTag, paramTag.replaceAll(COMMA_SEPARATOR, " "));
            }
            String[] rowParams = paramSection.split(COMMA_SEPARATOR);
            Integer id = 1;
            for (String rowParam : rowParams) {
                Integer n = id;
                Integer n2 = id = Integer.valueOf(id + 1);
                ParamSpec paramSpec = ScriptParser.createParamSpec(rowParam, n);
                if (paramSpec == null) continue;
                params.add(paramSpec);
            }
        }
        catch (Exception exp) {
            _logger.error((Object)"Error while parsing the script parameters.", (Throwable)exp);
        }
        return params;
    }

    private static String extractParamSection(String script) {
        int startParamSectionIndex = script.toLowerCase().indexOf(START_PARAM_SECTION);
        if (startParamSectionIndex == -1) {
            return "";
        }
        int endParamSectionIndex = ScriptParser.findEndParamSectionIndex(script = script.substring(startParamSectionIndex + START_PARAM_SECTION.length()));
        if (endParamSectionIndex == -1) {
            return "";
        }
        String paramSection = script.substring(0, endParamSectionIndex);
        if (paramSection == null) {
            return "";
        }
        return paramSection.trim();
    }

    public static ParamSpec createParamSpec(String rowParam, Integer id) {
        String paramName;
        if (StringUtils.isEmpty((CharSequence)rowParam)) {
            return null;
        }
        ParamSpec param = new ParamSpec();
        param.id = id.toString();
        List<String> paramsDefinitions = ScriptParser.findAllParameterTags(rowParam);
        int numberParamsDefinitions = paramsDefinitions.size();
        if (numberParamsDefinitions > 0) {
            String firstParamDefinition = paramsDefinitions.get(0);
            param.isMandatory = firstParamDefinition.toLowerCase().contains(IS_MANDATORY_TAG);
        }
        for (String paramItem : paramsDefinitions) {
            rowParam = rowParam.replace(paramItem, "");
        }
        boolean hasType = rowParam.contains("[") && rowParam.contains("]$");
        param.type = "";
        if (hasType) {
            String[] splitRow = rowParam.split("\\$");
            String paramTypeDefinition = splitRow[0].trim();
            String paramType = ScriptParser.findParamType(paramTypeDefinition);
            param.isArray = paramType.contains("[]");
            param.type = paramType = paramType.replace("[]", "");
        }
        String paramDefaultValue = null;
        String[] paramSplit = rowParam.split("=");
        if (paramSplit.length > 1) {
            paramDefaultValue = paramSplit[1].trim();
        }
        String[] nameValueSplit = paramSplit[0].split("\\$");
        param.name = paramName = nameValueSplit[1].trim();
        if (!StringUtils.isEmpty((CharSequence)paramDefaultValue)) {
            if (booleanPowerCliTypes.contains(param.type.toLowerCase())) {
                if (param.isArray) {
                    param.scriptTransformation = paramDefaultValue;
                } else {
                    paramDefaultValue = paramDefaultValue.toLowerCase().replaceAll("\\$", "").replaceAll("1", "true").replaceAll("0", "false").replaceAll("null", "false");
                    param.value = new String[]{paramDefaultValue};
                }
            } else {
                param.value = new String[]{paramDefaultValue.replaceAll("\"", "").replaceAll("'", "")};
            }
        }
        return param;
    }

    public static List<Structure> buildScriptParameters(List<ParamSpec> params) {
        ArrayList<Structure> parameters = new ArrayList<Structure>();
        if (params == null) {
            return parameters;
        }
        for (ParamSpec paramSpec : params) {
            if (ScriptParser.isParamInvalid(paramSpec)) continue;
            String paramType = paramSpec.type.toLowerCase();
            if (booleanPowerCliTypes.contains(paramType)) {
                parameters.add((Structure)(paramSpec.isArray ? ScriptParser.buildStringParameter(paramSpec) : ScriptParser.buildBooleanParameter(paramSpec)));
                continue;
            }
            parameters.add((Structure)(paramSpec.isArray ? ScriptParser.buildStringArrayParameter(paramSpec) : ScriptParser.buildStringParameter(paramSpec)));
        }
        return parameters;
    }

    private static boolean isParamInvalid(ParamSpec paramSpec) {
        return paramSpec == null || StringUtils.isEmpty((CharSequence)paramSpec.type) || StringUtils.isEmpty((CharSequence)paramSpec.name) || !ScriptParser.hasParamValueSet(paramSpec.value) && StringUtils.isEmpty((CharSequence)paramSpec.scriptTransformation);
    }

    public static Map<String, Set<String>> buildServerGuidToObjectIdsMap(String[] objectIds) {
        HashMap<String, Set<String>> objectIdsByServerGuid = new HashMap<String, Set<String>>();
        if (ArrayUtils.isEmpty((Object[])objectIds)) {
            return objectIdsByServerGuid;
        }
        for (String objectId : objectIds) {
            String serverGuidPart;
            String idPart;
            String[] objectParts;
            if (objectId == null || (objectParts = objectId.split(":")).length != 5) continue;
            if (objectId.contains(VAPI_PREFIX)) {
                idPart = objectParts[3];
                serverGuidPart = objectParts[4];
            } else {
                ManagedObjectReference moRef = ManagedObjectUtil.stringToMoref((String)objectId);
                if (moRef == null) continue;
                idPart = moRef.getType() + "-" + moRef.getValue();
                serverGuidPart = moRef.getServerGuid();
            }
            HashSet<String> ids = (HashSet<String>)objectIdsByServerGuid.get(serverGuidPart);
            if (ids == null) {
                ids = new HashSet<String>();
                ids.add(idPart);
                objectIdsByServerGuid.put(serverGuidPart, ids);
                continue;
            }
            ids.add(idPart);
        }
        return objectIdsByServerGuid;
    }

    public static boolean isSimpleTypeParameter(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        return numberPowerCliTypes.contains(type = type.toLowerCase()) || integerPowerCliTypes.contains(type) || booleanPowerCliTypes.contains(type) || stringPowerCliTypes.contains(type);
    }

    public static boolean isDateParameter(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        type = type.toLowerCase();
        return datePowerCliTypes.contains(type);
    }

    public static ArgumentScriptParameter buildArgumentScriptParameter(String name, List<String> values) {
        ArgumentScriptParameter serverArgumentParameter = new ArgumentScriptParameter();
        serverArgumentParameter.setName(name);
        serverArgumentParameter.setValue(values);
        return serverArgumentParameter;
    }

    public static String[] splitParamValues(String paramValue) {
        if (StringUtils.isEmpty((CharSequence)paramValue)) {
            return new String[0];
        }
        paramValue = paramValue.replaceAll("[\\n\\t\\r]", COMMA_SEPARATOR);
        String[] values = paramValue.split(COMMA_SEPARATOR);
        ArrayList<String> validParamValues = new ArrayList<String>();
        for (String value : values) {
            if (StringUtils.isEmpty((CharSequence)value.trim())) continue;
            validParamValues.add(value.trim());
        }
        return validParamValues.toArray(new String[validParamValues.size()]);
    }

    public static boolean hasParamValueSet(String[] paramValues) {
        if (ArrayUtils.isEmpty((Object[])paramValues)) {
            return false;
        }
        for (String paramValue : paramValues) {
            if (paramValue == null || StringUtils.isEmpty((CharSequence)paramValue.trim())) continue;
            return true;
        }
        return false;
    }

    private static ScriptParameterBoolean buildBooleanParameter(ParamSpec paramSpec) {
        ScriptParameterBoolean scriptParameterBoolean = new ScriptParameterBoolean();
        scriptParameterBoolean.setName(paramSpec.name);
        if (!StringUtils.isEmpty((CharSequence)paramSpec.scriptTransformation)) {
            scriptParameterBoolean.setScript(paramSpec.scriptTransformation);
        } else {
            scriptParameterBoolean.setValue(Boolean.valueOf(paramSpec.value[0]));
        }
        return scriptParameterBoolean;
    }

    private static ScriptParameterString buildStringParameter(ParamSpec paramSpec) {
        ScriptParameterString scriptParameterString = new ScriptParameterString();
        scriptParameterString.setName(paramSpec.name);
        if (!StringUtils.isEmpty((CharSequence)paramSpec.scriptTransformation)) {
            scriptParameterString.setScript(paramSpec.scriptTransformation);
        } else {
            scriptParameterString.setValue(paramSpec.value[0]);
        }
        return scriptParameterString;
    }

    private static ScriptParameterStringArray buildStringArrayParameter(ParamSpec paramSpec) {
        ScriptParameterStringArray scriptParameterStringArray = new ScriptParameterStringArray();
        scriptParameterStringArray.setName(paramSpec.name);
        if (!StringUtils.isEmpty((CharSequence)paramSpec.scriptTransformation)) {
            scriptParameterStringArray.setScript(paramSpec.scriptTransformation);
        } else {
            String[] values = ScriptParser.splitParamValues(paramSpec.value[0]);
            scriptParameterStringArray.setValue(Arrays.asList(values));
        }
        return scriptParameterStringArray;
    }

    private static int indexOf(Pattern pattern, String s) {
        Matcher matcher = pattern.matcher(s);
        return matcher.find() ? matcher.start() : -1;
    }

    private static int findEndParamSectionIndex(String trimmedScriptContent) {
        return ScriptParser.indexOf(Pattern.compile("(\\))([^\\]]|$)"), trimmedScriptContent);
    }

    private static String findParamType(String param) {
        Pattern pattern = Pattern.compile("(\\[)([^\\(])*([^\\)])*(\\])");
        Matcher matcher = pattern.matcher(param);
        if (matcher.find()) {
            String paramType = param.substring(matcher.start() + 1, matcher.end() - 1);
            return paramType.trim();
        }
        return "";
    }

    private static List<String> findAllParameterTags(String text) {
        ArrayList<String> tags = new ArrayList<String>();
        while (!StringUtils.isEmpty((CharSequence)text) && text.toLowerCase().contains(START_PARAM_TAG) && text.toLowerCase().contains(END_PARAM_TAG)) {
            int startParamTagIndex = text.toLowerCase().indexOf(START_PARAM_TAG);
            text = text.substring(startParamTagIndex);
            int endParamTagIndex = text.toLowerCase().indexOf(END_PARAM_TAG) + END_PARAM_TAG.length();
            tags.add(text.substring(0, endParamTagIndex));
            text = text.substring(endParamTagIndex);
        }
        return tags;
    }
}

