/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.google.common.base.Optional;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinition;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinitionCreator;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDetailsCreator;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorType;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorTypeInfoCreator;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardSpec;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmWizardInfoCreator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VcServiceUtil;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyFacade {
    private final AlarmDefinitionCreator _alarmDefinitionCreator;
    private final AlarmDetailsCreator _alarmDetailsCreator;
    private final AlarmMonitorTypeInfoCreator _alarmMonitorTypeInfoCreator;
    private final AlarmWizardInfoCreator _alarmWizardInfoCreator;
    private static final Log _logger = LogFactory.getLog(PropertyFacade.class);

    public PropertyFacade(AlarmDefinitionCreator alarmDefCreator, AlarmDetailsCreator alarmDetailsCreator, AlarmMonitorTypeInfoCreator alarmMonitorTypeInfoCreator, AlarmWizardInfoCreator alarmWizardInfoCreator) {
        Validate.notNull((Object)alarmDefCreator);
        Validate.notNull((Object)alarmDetailsCreator);
        Validate.notNull((Object)alarmMonitorTypeInfoCreator);
        Validate.notNull((Object)alarmWizardInfoCreator);
        this._alarmDefinitionCreator = alarmDefCreator;
        this._alarmDetailsCreator = alarmDetailsCreator;
        this._alarmMonitorTypeInfoCreator = alarmMonitorTypeInfoCreator;
        this._alarmWizardInfoCreator = alarmWizardInfoCreator;
    }

    public List<AlarmDefinition> createAlarmDefinitions(Object obj) {
        Validate.notNull((Object)obj);
        try {
            String vcName = VcServiceUtil.getServiceName((String)((ManagedObjectReference)obj).getServerGuid());
            return this._alarmDefinitionCreator.createAlarmDefinitions(obj, vcName);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Optional<AlarmDetails> createAlarmDetails(Object obj) {
        Validate.notNull((Object)obj);
        try {
            return Optional.of((Object)this._alarmDetailsCreator.createAlarmDetails(obj));
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            return Optional.absent();
        }
    }

    public List<AlarmMonitorType> createAlarmMonitorTypeInfo(Object obj) {
        Validate.notNull((Object)obj);
        try {
            return this._alarmMonitorTypeInfoCreator.getMonitorTypes((ManagedObjectReference)obj);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public AlarmDefWizardInfo createAlarmWizardInfo(Object obj, AlarmDefWizardSpec wizardSpec) {
        Validate.notNull((Object)obj);
        Validate.notNull((Object)wizardSpec);
        Validate.notNull((Object)wizardSpec.monitorType);
        try {
            return this._alarmWizardInfoCreator.createAlarmWizardinfo((ManagedObjectReference)obj, wizardSpec);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            return new AlarmDefWizardInfo();
        }
    }
}

