/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.vim.binding.vim.action.RunScriptAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class RunScriptActionWrapper
extends ActionWrapper {
    public static final String SCRIPT = "script";

    public RunScriptActionWrapper(AlarmTriggeringAction action) {
        super(action, "Alarm.AlarmHelper.RunACommand");
    }

    @Override
    public String getConfigString() {
        String configString = ((RunScriptAction)this._action.action).script;
        return configString == null ? "" : configString;
    }

    @Override
    public void setConfigString(String config) {
        Validate.notNull((Object)config);
        ((RunScriptAction)this._action.action).script = config;
    }

    @Override
    public List<ActionConfigDescription> getConfiguration() {
        ArrayList<ActionConfigDescription> configs = new ArrayList<ActionConfigDescription>();
        String scriptString = ((RunScriptAction)this._action.action).script;
        ActionConfigDescription script = new ActionConfigDescription(SCRIPT, Localization.getString("actions.script.script"), scriptString, scriptString);
        configs.add(script);
        return configs;
    }

    @Override
    public void setConfiguration(List<ActionConfigDescription> conf) {
        Validate.notNull(conf);
        RunScriptAction runScriptAction = (RunScriptAction)this._action.action;
        for (ActionConfigDescription descr : conf) {
            String propName = descr.getName();
            if (!SCRIPT.equals(propName)) continue;
            runScriptAction.script = descr.getValue().toString();
        }
    }

    @Override
    public String validateConfigString(String config) {
        if (StringUtils.isEmpty((CharSequence)config)) {
            String s = "runScriptActionWrapper.error.configure.runScript";
            return Localization.getString(s);
        }
        return "";
    }

    @Override
    public boolean supportsConfiguration() {
        return true;
    }

    @Override
    protected String validateConfigurationInternal() {
        RunScriptAction action = (RunScriptAction)this._action.action;
        return this.validateConfigString(action.script);
    }
}

