/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.triggers;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.expressions.MetricExpressionWrapper;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class MetricConditionBuilder {
    private static final String RES_PREFIX = "Alarm.Metadata.";
    private static final String TRIGGERS_METRIC = "triggers.metric";
    private static final String TRIGGERS_METRIC_NO_DURATION = "triggers.metric.no.duration";

    public List<TriggerConditionGroup> build(MetricAlarmExpression expression, AlarmDefinitionInfo info) {
        Validate.notNull((Object)expression);
        Validate.notNull((Object)info);
        MetricExpressionWrapper wrapper = new MetricExpressionWrapper(expression, info);
        ArrayList<TriggerConditionGroup> result = new ArrayList<TriggerConditionGroup>();
        if (expression.yellow != null) {
            result.add(this.buildWarningConditionGroup(wrapper));
        }
        if (expression.red != null) {
            result.add(this.buildCriticalConditionGroup(wrapper));
        }
        return result;
    }

    private TriggerConditionGroup buildCriticalConditionGroup(MetricExpressionWrapper wrapper) {
        String message;
        if (wrapper.getTrigger().supportDuration) {
            String[] args = new String[]{wrapper.getName(), wrapper.getCondition(), wrapper.getCriticalValue(), wrapper.getValueUnit(), wrapper.getCriticalInterval(), wrapper.getCriticalIntervalUnit()};
            message = Localization.getFormattedString(TRIGGERS_METRIC, args);
        } else {
            String[] args = new String[]{wrapper.getName(), wrapper.getCondition(), wrapper.getCriticalValue(), wrapper.getValueUnit()};
            message = Localization.getFormattedString(TRIGGERS_METRIC_NO_DURATION, args);
        }
        return new TriggerConditionGroup(message, ManagedEntity.Status.red);
    }

    private TriggerConditionGroup buildWarningConditionGroup(MetricExpressionWrapper wrapper) {
        String message;
        if (wrapper.getTrigger().supportDuration) {
            String[] args = new String[]{wrapper.getName(), wrapper.getCondition(), wrapper.getWarningValue(), wrapper.getValueUnit(), wrapper.getWarningInterval(), wrapper.getWarningIntervalUnit()};
            message = Localization.getFormattedString(TRIGGERS_METRIC, args);
        } else {
            String[] args = new String[]{wrapper.getName(), wrapper.getCondition(), wrapper.getWarningValue(), wrapper.getValueUnit()};
            message = Localization.getFormattedString(TRIGGERS_METRIC_NO_DURATION, args);
        }
        return new TriggerConditionGroup(message, ManagedEntity.Status.yellow);
    }
}

