/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.triggers;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.expressions.StateExpressionWrapper;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class StateConditionBuilder {
    public List<TriggerConditionGroup> build(StateAlarmExpression expression, AlarmDefinitionInfo info) {
        Validate.notNull((Object)expression);
        Validate.notNull((Object)info);
        StateExpressionWrapper wrapper = new StateExpressionWrapper(expression, info);
        ArrayList<TriggerConditionGroup> result = new ArrayList<TriggerConditionGroup>();
        if (expression.yellow != null) {
            result.add(this.buildWarningConditionGroup(wrapper));
        }
        if (expression.red != null) {
            result.add(this.buildCriticalConditionGroup(wrapper));
        }
        return result;
    }

    private TriggerConditionGroup buildWarningConditionGroup(StateExpressionWrapper wrapper) {
        String value = wrapper.warningValue();
        return this.buildConditionGroup(wrapper, value, ManagedEntity.Status.yellow);
    }

    private TriggerConditionGroup buildCriticalConditionGroup(StateExpressionWrapper wrapper) {
        String value = wrapper.criticalValue();
        return this.buildConditionGroup(wrapper, value, ManagedEntity.Status.red);
    }

    private TriggerConditionGroup buildConditionGroup(StateExpressionWrapper wrapper, String value, ManagedEntity.Status status) {
        String message = Localization.getFormattedString("triggers.state", new String[]{wrapper.getName(), wrapper.getCondition(), value});
        return new TriggerConditionGroup(message, status);
    }
}

