/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.triggers;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.EventConditionBuilder;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.MetricConditionBuilder;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.StateConditionBuilder;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.expressions.AlarmExpressionWrapper;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class TriggerConditionFactory {
    private final StateConditionBuilder _stateBuilder = new StateConditionBuilder();
    private final EventConditionBuilder _eventBuilder = new EventConditionBuilder();
    private final MetricConditionBuilder _metricBuilder = new MetricConditionBuilder();

    public List<TriggerConditionGroup> build(AlarmExpressionWrapper wrapper, AlarmDefinitionInfo info) {
        Validate.notNull((Object)wrapper);
        Validate.notNull((Object)info);
        ArrayList<TriggerConditionGroup> result = new ArrayList<TriggerConditionGroup>();
        List<Object> groups = new ArrayList();
        for (StateAlarmExpression stateExp : wrapper.getStateExpressions()) {
            groups = this._stateBuilder.build(stateExp, info);
            result.addAll(groups);
        }
        for (MetricAlarmExpression metricExp : wrapper.getMetricExpressions()) {
            groups = this._metricBuilder.build(metricExp, info);
            result.addAll(groups);
        }
        for (EventAlarmExpression eventExp : wrapper.getEventExpressions()) {
            result.add(this._eventBuilder.build(eventExp, info));
        }
        return result;
    }
}

