/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.details;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionGroup;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmRuleJoiner;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmRuleSummary;
import com.vmware.vim.binding.vim.ManagedEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AlarmRulesSummaryBuilder {
    private static final String NEW_LINE = "<br>";
    private List<TriggerConditionGroup> triggerConditionGroups;
    private AlarmRuleJoiner joiner;
    private List<ActionGroup> actionGroups;
    private String repeatText;
    private static final String DEFAULT_FREQUENCY_IN_MINS = "0";

    public AlarmRulesSummaryBuilder(List<TriggerConditionGroup> triggerConditionGroups, AlarmRuleJoiner joiner, List<ActionGroup> actionGroups, int actionRepeatFrequency) {
        this.triggerConditionGroups = triggerConditionGroups;
        this.joiner = joiner;
        this.actionGroups = actionGroups;
        String actionFrequency = actionRepeatFrequency <= 0 ? DEFAULT_FREQUENCY_IN_MINS : Integer.toString(actionRepeatFrequency);
        this.repeatText = Localization.getFormattedString("alarm.action.repeat.template", new String[]{actionFrequency});
    }

    public List<AlarmRuleSummary> build() {
        ArrayList<AlarmRuleSummary> ruleSummaryList = new ArrayList<AlarmRuleSummary>();
        AlarmRulesSummaryBuilder.addToListIfNotNull(ruleSummaryList, this.buildSummaryForState(ManagedEntity.Status.red));
        AlarmRulesSummaryBuilder.addToListIfNotNull(ruleSummaryList, this.buildSummaryForState(ManagedEntity.Status.yellow));
        AlarmRulesSummaryBuilder.addToListIfNotNull(ruleSummaryList, this.buildSummaryForState(ManagedEntity.Status.gray));
        AlarmRulesSummaryBuilder.addToListIfNotNull(ruleSummaryList, this.buildSummaryForState(ManagedEntity.Status.green));
        return ruleSummaryList;
    }

    private static <T> void addToListIfNotNull(List<T> list, T item) {
        if (item != null) {
            list.add(item);
        }
    }

    private AlarmRuleSummary buildSummaryForState(ManagedEntity.Status state) {
        String triggerSummary = this.createAlarmConditionsText(state);
        ManagedEntity.Status previousState = this.getPreviousState(state);
        if (StringUtils.isEmpty((CharSequence)triggerSummary)) {
            return null;
        }
        AlarmRuleSummary ruleSummary = new AlarmRuleSummary();
        ruleSummary.triggerSummary = triggerSummary;
        if (previousState != null) {
            ruleSummary.actions = this.getActionGroupsForStateTransition(previousState, state);
        }
        return ruleSummary;
    }

    private String createAlarmConditionsText(ManagedEntity.Status status) {
        if (this.triggerConditionGroups == null || this.triggerConditionGroups.isEmpty()) {
            return null;
        }
        ArrayList<String> conditions = new ArrayList<String>();
        for (TriggerConditionGroup triggerConditionGroup : this.triggerConditionGroups) {
            if (triggerConditionGroup.getStatus() != status) continue;
            conditions.add(triggerConditionGroup.getLabelText());
        }
        if (conditions.isEmpty()) {
            return "";
        }
        String conditionText = this.joinConditions(conditions, this.joiner);
        if (StringUtils.isNotEmpty((CharSequence)conditionText)) {
            return Localization.getFormattedString("triggers.condition.IFTHENTemplate", new String[]{conditionText, NEW_LINE, this.getStatusArgument(status)});
        }
        return "";
    }

    private String getJoinerLocStringId(AlarmRuleJoiner joiner) {
        if (joiner == AlarmRuleJoiner.AND) {
            return "triggers.condition.ANDJoinerTemplate";
        }
        return "triggers.condition.ORJoinerTemplate";
    }

    private String getStatusArgument(ManagedEntity.Status status) {
        return "{" + status + "}";
    }

    private List<ActionGroup> getActionGroupsForStateTransition(ManagedEntity.Status fromState, ManagedEntity.Status toState) {
        if (this.actionGroups == null) {
            return new ArrayList<ActionGroup>();
        }
        String transitionText = this.getStateTransitionText(fromState, toState);
        ArrayList<ActionGroup> filteredActions = new ArrayList<ActionGroup>();
        for (ActionGroup actionGroup : this.actionGroups) {
            if (!transitionText.equals(actionGroup.getStateTransition())) continue;
            filteredActions.add(actionGroup);
            if (!actionGroup.repeats()) continue;
            if (StringUtils.isEmpty((CharSequence)actionGroup.getBodyText())) {
                actionGroup.setBodyText(this.repeatText);
                continue;
            }
            actionGroup.setBodyText(actionGroup.getBodyText() + NEW_LINE + this.repeatText);
        }
        return filteredActions;
    }

    private String getStateTransitionText(ManagedEntity.Status fromState, ManagedEntity.Status toState) {
        return fromState + "2" + toState;
    }

    private String joinConditions(List<String> conditions, AlarmRuleJoiner joiner) {
        String locStringId = this.getJoinerLocStringId(joiner);
        return this.joinLabels(conditions, 0, conditions.size() - 1, locStringId, NEW_LINE);
    }

    private String joinLabels(List<String> labels, int startIndex, int endIndex, String locStringId, String divider) {
        if (labels == null || startIndex > endIndex || startIndex < 0 || startIndex >= labels.size() || endIndex < 0 || endIndex >= labels.size()) {
            return "";
        }
        if (startIndex == endIndex) {
            return labels.get(startIndex);
        }
        int midIndex = (startIndex + endIndex) / 2;
        String leftText = this.joinLabels(labels, startIndex, midIndex, locStringId, divider);
        String rightText = this.joinLabels(labels, midIndex + 1, endIndex, locStringId, divider);
        if (StringUtils.isEmpty((CharSequence)divider)) {
            return Localization.getFormattedString(locStringId, new String[]{leftText, divider, rightText});
        }
        return Localization.getFormattedString(locStringId, new String[]{leftText, divider, rightText});
    }

    private ManagedEntity.Status getPreviousState(ManagedEntity.Status state) {
        switch (state) {
            case red: {
                return ManagedEntity.Status.yellow;
            }
            case yellow: {
                return ManagedEntity.Status.green;
            }
            case green: {
                return ManagedEntity.Status.yellow;
            }
        }
        return null;
    }
}

