/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.expressions;

import com.vmware.vim.binding.vim.alarm.AlarmExpression;
import com.vmware.vim.binding.vim.alarm.AndAlarmExpression;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vim.binding.vim.alarm.OrAlarmExpression;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import java.util.ArrayList;
import java.util.List;

public class AlarmExpressionWrapper {
    private List<EventAlarmExpression> _eventExpressions = new ArrayList<EventAlarmExpression>();
    private List<MetricAlarmExpression> _metricExpressions = new ArrayList<MetricAlarmExpression>();
    private List<StateAlarmExpression> _stateExpressions = new ArrayList<StateAlarmExpression>();
    private boolean _isEventBased;
    private boolean _isAndExpression;
    private boolean _isOrExpression;

    public AlarmExpressionWrapper(AlarmExpression expression) {
        this.processExpressions(expression);
    }

    private void processExpressions(AlarmExpression expression) {
        this.computeExpressionLists(expression);
        this._isEventBased = this.computeIsEventBased();
    }

    private boolean computeIsEventBased() {
        return !this._eventExpressions.isEmpty() && this._metricExpressions.isEmpty() && this._stateExpressions.isEmpty();
    }

    private void computeExpressionLists(AlarmExpression exp) {
        if (exp == null) {
            return;
        }
        if (exp instanceof AndAlarmExpression) {
            this._isAndExpression = true;
            AndAlarmExpression e = (AndAlarmExpression)exp;
            for (AlarmExpression alarmExp : e.expression) {
                this.computeExpressionLists(alarmExp);
            }
        } else if (exp instanceof OrAlarmExpression) {
            this._isOrExpression = true;
            OrAlarmExpression e = (OrAlarmExpression)exp;
            for (AlarmExpression alarmExp : e.expression) {
                this.computeExpressionLists(alarmExp);
            }
        } else if (exp instanceof StateAlarmExpression) {
            this._stateExpressions.add((StateAlarmExpression)exp);
        } else if (exp instanceof MetricAlarmExpression) {
            this._metricExpressions.add((MetricAlarmExpression)exp);
        } else if (exp instanceof EventAlarmExpression) {
            this._eventExpressions.add((EventAlarmExpression)exp);
        }
    }

    public List<EventAlarmExpression> getEventExpressions() {
        return this._eventExpressions;
    }

    public List<MetricAlarmExpression> getMetricExpressions() {
        return this._metricExpressions;
    }

    public List<StateAlarmExpression> getStateExpressions() {
        return this._stateExpressions;
    }

    public boolean getIsEventBased() {
        return this._isEventBased;
    }

    public boolean getIsAndExpression() {
        return this._isAndExpression;
    }

    public boolean getIsOrExpression() {
        return this._isOrExpression;
    }
}

