/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.monitortype;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.util.QueryQualifier;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorType;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.MonitorTypeInfoConfigUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AlarmMonitorTypeInfoCreator {
    private final QueryService _queryService;

    public AlarmMonitorTypeInfoCreator(QueryServiceFactory factory) {
        this._queryService = factory.getQueryService();
    }

    public final List<AlarmMonitorType> getMonitorTypes(ManagedObjectReference mobRef) {
        List<AlarmMonitorType> monitorTypeInfos = MonitorTypeInfoConfigUtil.getMonitorTypeInfoConfig(mobRef);
        ArrayList<String> requiredProperties = new ArrayList<String>();
        for (AlarmMonitorType monitorTypeInfo : monitorTypeInfos) {
            String localizedType = Localization.getVpxString(monitorTypeInfo.getI18Key());
            monitorTypeInfo.setLocalizedType(localizedType);
            if (!StringUtils.isNotEmpty((CharSequence)monitorTypeInfo.getDataQueryProperty())) continue;
            if (monitorTypeInfo.isRelatedProperty()) {
                requiredProperties.add(monitorTypeInfo.getDataQueryProperty());
                continue;
            }
            requiredProperties.add(0, monitorTypeInfo.getDataQueryProperty());
        }
        if (!requiredProperties.isEmpty()) {
            Collection resourceModels = QueryQualifier.getFromClause(requiredProperties, null, null);
            PropertyPredicate predicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)mobRef);
            ResultSet resultSet = this._queryService.select(requiredProperties).from(resourceModels).where(new PropertyPredicate[]{predicate}).build().fetch();
            List resourceItems = resultSet.getItems();
            if (CollectionUtils.isNotEmpty((Collection)resourceItems)) {
                ResourceItem resourceItem = (ResourceItem)resourceItems.get(0);
                for (AlarmMonitorType monitorTypeInfo : monitorTypeInfos) {
                    String key = monitorTypeInfo.getDataQueryProperty();
                    if (!StringUtils.isNotEmpty((CharSequence)key)) continue;
                    Integer count = (Integer)resourceItem.get(key);
                    monitorTypeInfo.setCount(count);
                }
            }
        }
        return monitorTypeInfos;
    }
}

