/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network;

import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VlanUtil {
    private static Log _logger = LogFactory.getLog(VlanUtil.class);
    public static final int VLAN_NONE_ID = 0;
    public static final String VLAN_NONE = "none";
    public static final String VLAN_VLAN = "vlan";
    public static final String VLAN_TRUNK = "trunk";
    public static final String VLAN_PRIVATE = "private";
    public static final int VLAN_NUM_NONE = 0;
    public static final int VLAN_NUM_ALL = 4095;
    public static final int VLAN_MIN = 1;
    public static final int VLAN_MAX = 4094;
    private static final String OUT_RANGE_DELIMITER = ", ";
    private static final String OUT_RANGE_DIVIDER = "-";

    public static int[] getAvailableVlanIds(PortGroup[] portGroups) {
        HashSet<Integer> vlanIds = new HashSet<Integer>();
        vlanIds.add(0);
        vlanIds.add(4095);
        if (portGroups != null) {
            for (PortGroup portGroup : portGroups) {
                if (portGroup == null || portGroup.spec == null) continue;
                vlanIds.add(portGroup.spec.vlanId);
            }
        }
        int[] vlanIdArr = new int[vlanIds.size()];
        int index = 0;
        for (Integer vlandId : vlanIds) {
            vlanIdArr[index] = vlandId;
            ++index;
        }
        Arrays.sort(vlanIdArr);
        return vlanIdArr;
    }

    public static String getVlanType(VmwareDistributedVirtualSwitch.VlanSpec vlanSpec) {
        if (vlanSpec == null) {
            return VLAN_NONE;
        }
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            if (((VmwareDistributedVirtualSwitch.VlanIdSpec)vlanSpec).vlanId == 0) {
                return VLAN_NONE;
            }
            return VLAN_VLAN;
        }
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            return VLAN_TRUNK;
        }
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            return VLAN_PRIVATE;
        }
        return null;
    }

    public static String getPvlanTypeText(String pvlanType) {
        String pvlanTypeText = "";
        if (VmwareDistributedVirtualSwitch.PvlanPortType.promiscuous.toString().equals(pvlanType)) {
            pvlanTypeText = ModulesApiUtil.getString("dvpg.policy.vlan.private.type.promiscuous");
        } else if (VmwareDistributedVirtualSwitch.PvlanPortType.isolated.toString().equals(pvlanType)) {
            pvlanTypeText = ModulesApiUtil.getString("dvpg.policy.vlan.private.type.isolated");
        } else if (VmwareDistributedVirtualSwitch.PvlanPortType.community.toString().equals(pvlanType)) {
            pvlanTypeText = ModulesApiUtil.getString("dvpg.policy.vlan.private.type.community");
        } else {
            _logger.warn((Object)("Unsupported private VLAN type: " + pvlanType));
        }
        return pvlanTypeText;
    }

    public static String getNumericRangeAsString(NumericRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String outRangeDelimiter = "";
        for (NumericRange range : ranges) {
            result.append(outRangeDelimiter);
            if (range.getStart() == range.getEnd()) {
                result.append(Integer.toString(range.getStart()));
            } else {
                result.append(Integer.toString(range.getStart()));
                result.append(OUT_RANGE_DIVIDER);
                result.append(Integer.toString(range.getEnd()));
            }
            outRangeDelimiter = OUT_RANGE_DELIMITER;
        }
        return result.toString();
    }
}

