/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.adapters;

import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vsphere.client.h5.storage.data.adapters.StorageAdapterData;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;

public class IscsiStorageAdapterData
extends StorageAdapterData {
    private static final String COMMA_SEPARATOR = ", ";
    public Boolean isSoftwareBased;
    public Boolean canBeDisabled;
    public String iScsiName;
    public String iScsiAlias;
    public String formattedDiscoveryProperties;
    public String macAddress;
    public Integer maxSpeedInMbit;
    public Integer currentSpeedInMbit;
    public InternetScsiHba.AuthenticationProperties authenticationProperties;
    public String localizedAuthenticationMethod;

    public static void populateIscsiStorageAdapterData(IscsiStorageAdapterData iscsiStorageAdapterData, InternetScsiHba iscsiHba) {
        iscsiStorageAdapterData.isSoftwareBased = iscsiHba.isSoftwareBased;
        iscsiStorageAdapterData.canBeDisabled = iscsiHba.canBeDisabled;
        iscsiStorageAdapterData.iScsiName = iscsiHba.iScsiName;
        iscsiStorageAdapterData.iScsiAlias = iscsiHba.iScsiAlias;
        iscsiStorageAdapterData.formattedDiscoveryProperties = IscsiStorageAdapterData.formatIscsiDiscoveryProperties(iscsiHba);
        if (iscsiHba.ipProperties != null) {
            iscsiStorageAdapterData.macAddress = iscsiHba.ipProperties.mac;
        }
        iscsiStorageAdapterData.currentSpeedInMbit = iscsiHba.currentSpeedMb;
        iscsiStorageAdapterData.maxSpeedInMbit = iscsiHba.maxSpeedMb;
        iscsiStorageAdapterData.localizedAuthenticationMethod = IscsiStorageAdapterData.formatAuthenticationMethod(iscsiHba.authenticationProperties);
        iscsiStorageAdapterData.authenticationProperties = iscsiHba.authenticationProperties;
    }

    private static String formatAuthenticationMethod(InternetScsiHba.AuthenticationProperties authenticationProperties) {
        return ModulesApiUtil.getString(String.format("storage.adapters.iscsi.authenticationMethod.%s.%s", authenticationProperties.chapAuthenticationType, authenticationProperties.mutualChapAuthenticationType));
    }

    private static String formatIscsiDiscoveryProperties(InternetScsiHba iscsiHba) {
        InternetScsiHba.DiscoveryProperties discProps = iscsiHba.discoveryProperties;
        String result = "";
        if (discProps == null) {
            return ModulesApiUtil.getString("storage.adapters.iscsiTargets.discovery.none");
        }
        if (discProps.iSnsDiscoveryEnabled) {
            result = result + ModulesApiUtil.getString("storage.adapters.iscsiTargets.discovery.isns") + COMMA_SEPARATOR;
        }
        if (discProps.sendTargetsDiscoveryEnabled) {
            result = result + ModulesApiUtil.getString("storage.adapters.iscsiTargets.discovery.sendTargets") + COMMA_SEPARATOR;
        }
        if (discProps.slpDiscoveryEnabled) {
            result = result + ModulesApiUtil.getString("storage.adapters.iscsiTargets.discovery.slp") + COMMA_SEPARATOR;
        }
        if (discProps.staticTargetDiscoveryEnabled) {
            result = result + ModulesApiUtil.getString("storage.adapters.iscsiTargets.discovery.staticTargets") + COMMA_SEPARATOR;
        }
        if (result.length() == 0) {
            return ModulesApiUtil.getString("storage.adapters.iscsiTargets.discovery.none");
        }
        if (result.lastIndexOf(COMMA_SEPARATOR) == result.length() - COMMA_SEPARATOR.length()) {
            result = result.substring(0, result.length() - COMMA_SEPARATOR.length());
        }
        return result;
    }
}

