/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.datastore;

import com.vmware.vim.binding.sms.provider.ProviderInfo;
import com.vmware.vim.binding.sms.storage.StorageArray;
import com.vmware.vim.binding.sms.storage.StorageContainer;
import com.vmware.vise.core.model.annotation.Dto;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;
import com.vmware.vsphere.client.sms.StorageContainerInfo;
import java.util.HashSet;
import org.apache.commons.lang3.ArrayUtils;

@Dto
public class StorageContainerInfoItem {
    private static final long VVOL_MAX_DISK_SIZE_TB = 62L;
    public String name;
    public String identifier;
    public String capacity;
    public String existingDatastoreName;
    public boolean datastoreExists;
    public String storageProviders;
    public String storageArrays;
    public StorageContainerInfo info;

    public static StorageContainerInfoItem getInstance(StorageContainerInfo info) {
        StorageContainerInfoItem formatted = new StorageContainerInfoItem();
        StorageContainer container = info.storageContainer;
        formatted.name = container.name;
        formatted.identifier = container.uuid;
        formatted.capacity = container.maxVvolSizeInMB == 0L ? FormatUtil.getStorageFormatted((Long)62L, (long)0x10000000000L, (long)0x10000000000L) : FormatUtil.getStorageFormatted((Long)container.maxVvolSizeInMB, (long)0x100000L, (long)-1L);
        formatted.datastoreExists = info.datastoreInfo != null;
        formatted.existingDatastoreName = formatted.datastoreExists ? info.datastoreInfo.name : ModulesApiUtil.getString("na");
        formatted.storageProviders = StorageContainerInfoItem.toCsvString(info.providerInfo, new Extractor(){

            @Override
            public String extract(Object item) {
                return ((ProviderInfo)item).name;
            }
        });
        formatted.storageArrays = StorageContainerInfoItem.toCsvString(info.storageArray, new Extractor(){

            @Override
            public String extract(Object item) {
                return ((StorageArray)item).name;
            }
        });
        formatted.info = info;
        return formatted;
    }

    private static String toCsvString(Object[] items, Extractor extractor) {
        if (ArrayUtils.isEmpty((Object[])items)) {
            return "";
        }
        HashSet<String> appended = new HashSet<String>();
        StringBuilder result = new StringBuilder(extractor.extract(items[0]));
        appended.add(result.toString());
        for (Object item : items) {
            String formattedItem = extractor.extract(item);
            if (appended.contains(formattedItem)) continue;
            result.append(", ").append(formattedItem);
            appended.add(formattedItem);
        }
        return result.toString();
    }

    private static interface Extractor {
        public String extract(Object var1);
    }
}

