/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.datastore;

import com.google.common.base.Strings;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsDatastoreExtentItem;
import com.vmware.vsphere.client.h5.storage.data.devices.HostStorageDevicePartitionItem;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.storage.VmfsExtentInfo;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QueryBinding(value="Datastore")
public class VmfsDatastoreExtentData {
    private static transient Log _logger = LogFactory.getLog(VmfsDatastoreExtentData.class);
    @Property(value="Datastore/vmfsDatastoreExtents")
    public transient VmfsExtentInfo[] extentInfos;
    private static final transient String PARTITION_TYPE_EXTENDED = "datastore.partitionType.extended";

    public VmfsDatastoreExtentItem[] getDatastoreExtentItems() {
        VmfsDatastoreExtentItem[] extentItems = new VmfsDatastoreExtentItem[this.extentInfos.length];
        for (int i = 0; i < this.extentInfos.length; ++i) {
            VmfsExtentInfo currentExtentInfo = this.extentInfos[i];
            extentItems[i] = new VmfsDatastoreExtentItem();
            extentItems[i].isSsd = currentExtentInfo.isSsd;
            extentItems[i].formattedName = this.getName(currentExtentInfo);
            extentItems[i].deviceName = this.getDeviceName(currentExtentInfo);
            extentItems[i].sectorFormat = H5StorageUtil.getSectorFormatByScsiDiskType(this.extentInfos[i].scsiDiskType);
            if (currentExtentInfo.partitionInfo == null) continue;
            extentItems[i].capacityInB = this.getCapacity(currentExtentInfo);
            extentItems[i].formattedCapacity = FormatUtil.getStorageFormatted((Long)extentItems[i].capacityInB, (long)1L, (long)-1L);
            extentItems[i].formattedDeviceCapacity = this.getDeviceCapacity(currentExtentInfo);
            extentItems[i].devicePartitionFormat = currentExtentInfo.partitionInfo.spec.partitionFormat;
            extentItems[i].partitions = this.getPartitions(currentExtentInfo);
        }
        return extentItems;
    }

    private HostStorageDevicePartitionItem[] getPartitions(VmfsExtentInfo currentExtentInfo) {
        long extendedCapacity = 0L;
        ArrayList<HostStorageDevicePartitionItem> partitionsList = new ArrayList<HostStorageDevicePartitionItem>();
        if (currentExtentInfo.partitionInfo.spec.partition == null) {
            return new HostStorageDevicePartitionItem[0];
        }
        block0: for (DiskPartitionInfo.Partition partition : currentExtentInfo.partitionInfo.spec.partition) {
            for (DiskPartitionInfo.BlockRange blockRange : currentExtentInfo.partitionInfo.layout.partition) {
                if (blockRange.partition == null || !blockRange.partition.equals(partition.partition)) continue;
                HostStorageDevicePartitionItem item = new HostStorageDevicePartitionItem();
                item.name = blockRange.type;
                item.partitionCapacity = StorageUtil.getSizeOfBlockRange(blockRange);
                item.isLogical = partition.logical;
                if (item.isLogical) {
                    extendedCapacity += item.partitionCapacity;
                }
                partitionsList.add(item);
                continue block0;
            }
        }
        if (extendedCapacity > 0L) {
            HostStorageDevicePartitionItem item = new HostStorageDevicePartitionItem();
            item.name = PARTITION_TYPE_EXTENDED;
            item.partitionCapacity = extendedCapacity;
            item.isLogical = false;
            partitionsList.add(item);
        }
        return partitionsList.toArray(new HostStorageDevicePartitionItem[partitionsList.size()]);
    }

    private String getName(VmfsExtentInfo extentInfo) {
        return String.format("%s : %d", this.getDeviceName(extentInfo), extentInfo.extentPartition.partition);
    }

    private String getDeviceName(VmfsExtentInfo extentInfo) {
        if (!Strings.isNullOrEmpty((String)extentInfo.deviceDisplayName)) {
            return extentInfo.deviceDisplayName;
        }
        return extentInfo.extentPartition.diskName;
    }

    private String getDeviceCapacity(VmfsExtentInfo extentInfo) {
        Long capacity = H5StorageUtil.lbaToBytes(extentInfo.partitionInfo.layout.total);
        return capacity == null ? null : FormatUtil.getStorageFormatted((Long)capacity, (long)1L, (long)-1L);
    }

    private long getCapacity(VmfsExtentInfo extentInfo) {
        long unknownCapacity = 0L;
        for (DiskPartitionInfo.BlockRange blockRange : extentInfo.partitionInfo.layout.partition) {
            if (blockRange.partition == null || !blockRange.partition.equals(extentInfo.extentPartition.partition)) continue;
            return StorageUtil.getSizeOfBlockRange(blockRange);
        }
        return unknownCapacity;
    }
}

