/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data;

import com.vmware.vim.binding.vim.fault.AnswerFileUpdateFailed;
import com.vmware.vim.binding.vim.profile.ProfilePropertyPath;
import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.LocalizableMessage;

public class DeferredSettingsValidationResult {
    public String status;
    public ValidationError[] errors;

    public DeferredSettingsValidationResult(ExecuteResult executeResult) {
        assert (executeResult != null);
        this.status = executeResult.status;
        if (executeResult.error != null) {
            this.errors = new ValidationError[executeResult.error.length];
            for (int idx = 0; idx < executeResult.error.length; ++idx) {
                ValidationError validationError;
                ExecuteResult.ExecuteError executeError = executeResult.error[idx];
                this.errors[idx] = validationError = new ValidationError(executeError);
            }
        }
    }

    public DeferredSettingsValidationResult(ProfileManager.AnswerFileValidationResult ansferFileResult) {
        assert (ansferFileResult != null);
        this.status = ansferFileResult.status;
        if (ansferFileResult.error != null) {
            this.errors = new ValidationError[ansferFileResult.error.length];
            for (int idx = 0; idx < ansferFileResult.error.length; ++idx) {
                ValidationError validationError;
                AnswerFileUpdateFailed.UpdateFailure executeError = ansferFileResult.error[idx];
                this.errors[idx] = validationError = new ValidationError(executeError);
            }
        }
    }

    public static class ValidationError {
        public ProfilePropertyPath path;
        public LocalizableMessage message;

        public ValidationError(ExecuteResult.ExecuteError error) {
            this.path = error.path;
            this.message = error.message;
        }

        public ValidationError(AnswerFileUpdateFailed.UpdateFailure failure) {
            this.path = failure.userInputPath;
            this.message = failure.errMsg;
        }
    }
}

