/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.util;

import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.ExtendedElementDescription;
import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ApplyProfileElement;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.PolicyOptionMetadata;
import com.vmware.vim.binding.vim.profile.host.VirtualSwitchProfile;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vsphere.client.hostprofile.util.ProcessUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PreProcessUtil {
    private static final Log _logger = LogFactory.getLog(PreProcessUtil.class);

    private PreProcessUtil() {
    }

    public static KeyAnyValueImpl[] convertToPrimitiveParameters(KeyAnyValue complexParam) {
        if (complexParam == null || complexParam.getValue() == null) {
            return new KeyAnyValueImpl[0];
        }
        ArrayList<KeyAnyValueImpl> aList = new ArrayList<KeyAnyValueImpl>();
        Object paramValue = complexParam.getValue();
        Class<?> clazz = paramValue.getClass();
        for (Field field : clazz.getFields()) {
            int mod = field.getModifiers();
            if (!Modifier.isPublic(mod)) continue;
            KeyAnyValueImpl primitiveParam = new KeyAnyValueImpl();
            primitiveParam.setKey(field.getName());
            try {
                primitiveParam.setValue(field.get(paramValue));
            }
            catch (Exception e) {
                _logger.error((Object)"Setting primitive param value failed", (Throwable)e);
                continue;
            }
            aList.add(primitiveParam);
        }
        KeyAnyValueImpl[] result = new KeyAnyValueImpl[aList.size()];
        return aList.toArray(result);
    }

    public static PolicyMetadata processPolicyMeta(PolicyMetadata meta) {
        if (!ProcessUtil.hasValidPossibleOption(meta)) {
            return meta;
        }
        for (PolicyOptionMetadata pom : meta.possibleOption) {
            if (pom == null || pom.parameter == null) continue;
            PreProcessUtil.processPolicyOptionMeta(pom);
        }
        return meta;
    }

    public static void processPolicyOptionMeta(PolicyOptionMetadata pom) {
        for (ParameterMetadata pm : pom.parameter) {
            if (!ProcessUtil.isComplexTypeParamMeta(pm)) continue;
            pom.parameter = PreProcessUtil.convertComplexMetaToPrimitive(pm);
            break;
        }
    }

    public static ParameterMetadata[] convertComplexMetaToPrimitive(ParameterMetadata parameter) {
        ParameterMetadata[] emptyResult = new ParameterMetadata[]{};
        if (parameter == null || parameter.type == null) {
            return emptyResult;
        }
        ArrayList<ParameterMetadata> aList = new ArrayList<ParameterMetadata>();
        Class<?> clazz = ProcessUtil.getParamMetaClass(parameter);
        if (clazz == null) {
            _logger.error((Object)"Cannot get class info from parameter meta-data");
            return emptyResult;
        }
        for (Field field : clazz.getDeclaredFields()) {
            int mod = field.getModifiers();
            if (!Modifier.isPublic(mod)) continue;
            ParameterMetadata newParamMeta = new ParameterMetadata();
            String simpleTypeName = ProcessUtil.convertToSimpleTypeName(field.getType());
            newParamMeta.type = new TypeNameImpl(simpleTypeName);
            newParamMeta.defaultValue = null;
            newParamMeta.optional = true;
            newParamMeta.id = new ExtendedElementDescription(field.getName(), field.getName(), field.getName(), field.getName(), new KeyAnyValue[0]);
            aList.add(newParamMeta);
        }
        ParameterMetadata[] result = new ParameterMetadata[aList.size()];
        return aList.toArray(result);
    }

    public static String getApplyProfileElementKey(Object obj) {
        if (obj instanceof ApplyProfileElement) {
            return ((ApplyProfileElement)obj).key;
        }
        if (obj instanceof VirtualSwitchProfile) {
            return ((VirtualSwitchProfile)obj).key;
        }
        if (obj instanceof ApplyProfile) {
            return ((ApplyProfile)obj).profileTypeName;
        }
        return null;
    }

    public static String getStringPropertyValue(Object obj, String fieldName) {
        String emptyKey = "";
        if (obj == null) {
            return "";
        }
        Class<?> clazz = obj.getClass();
        Field found = null;
        for (Field f : clazz.getFields()) {
            if (!f.getName().equalsIgnoreCase(fieldName)) continue;
            found = f;
            break;
        }
        if (found == null) {
            return "";
        }
        int modifiers = found.getModifiers();
        if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            return "";
        }
        Object value = null;
        try {
            value = found.get(obj);
        }
        catch (Exception e) {
            _logger.error((Object)"Value cannot be retrieved", (Throwable)e);
            return "";
        }
        if (!(value instanceof String)) {
            return "";
        }
        return (String)value;
    }

    public static Policy convertComplexParamToPrimitive(Policy policy, KeyAnyValue complexParam) {
        if (!ProcessUtil.hasValidOptionParam(policy)) {
            return policy;
        }
        if (!ProcessUtil.isComplexTypeKeyValue(complexParam)) {
            return policy;
        }
        policy.policyOption.parameter = PreProcessUtil.convertToPrimitiveParameters(complexParam);
        return policy;
    }

    public static KeyAnyValue getComplexTypeParam(Policy policy) {
        if (!ProcessUtil.hasValidOptionParam(policy)) {
            return null;
        }
        for (KeyAnyValue kavParam : policy.policyOption.parameter) {
            if (kavParam == null || kavParam.getValue() == null || !ProcessUtil.isComplexTypeKeyValue(kavParam)) continue;
            return kavParam;
        }
        return null;
    }

    public static String getComponentTypeName(Field field) {
        if (field == null) {
            return "";
        }
        if (!field.getType().isArray()) {
            return "";
        }
        return field.getType().getComponentType().getName();
    }
}

