/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.adapters;

import com.vmware.vim.binding.vim.host.BlockAdapterTargetTransport;
import com.vmware.vim.binding.vim.host.FibreChannelOverEthernetTargetTransport;
import com.vmware.vim.binding.vim.host.FibreChannelTargetTransport;
import com.vmware.vim.binding.vim.host.InternetScsiTargetTransport;
import com.vmware.vim.binding.vim.host.ParallelScsiTargetTransport;
import com.vmware.vim.binding.vim.host.PcieTargetTransport;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.RdmaTargetTransport;
import com.vmware.vim.binding.vim.host.SerialAttachedTargetTransport;
import com.vmware.vim.binding.vim.host.TcpTargetTransport;

public enum StorageDeviceTransport {
    FCOETRANSPORT,
    FCTRANSPORT,
    ISCSITRANSPORT,
    PARALLELTRANSPORT,
    BLOCKTRANSPORT,
    SASTRANSPORT,
    PCIETRANSPORT,
    RDMATRANSPORT,
    TCPTRANSPORT;


    public static StorageDeviceTransport getTransport(PlugStoreTopology.Target target) {
        if (target == null || target.transport == null) {
            return null;
        }
        if (target.transport instanceof FibreChannelOverEthernetTargetTransport) {
            return FCOETRANSPORT;
        }
        if (target.transport instanceof FibreChannelTargetTransport) {
            return FCTRANSPORT;
        }
        if (target.transport instanceof InternetScsiTargetTransport) {
            return ISCSITRANSPORT;
        }
        if (target.transport instanceof ParallelScsiTargetTransport) {
            return PARALLELTRANSPORT;
        }
        if (target.transport instanceof BlockAdapterTargetTransport) {
            return BLOCKTRANSPORT;
        }
        if (target.transport instanceof SerialAttachedTargetTransport) {
            return SASTRANSPORT;
        }
        if (target.transport instanceof PcieTargetTransport) {
            return PCIETRANSPORT;
        }
        if (target.transport instanceof RdmaTargetTransport) {
            return RDMATRANSPORT;
        }
        if (target.transport instanceof TcpTargetTransport) {
            return TCPTRANSPORT;
        }
        return null;
    }
}

