/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.highcharts;

import com.google.common.base.Preconditions;
import com.vmware.opsmgmt.client.advperfcharts.ChartSeriesOptions;
import com.vmware.opsmgmt.client.advperfcharts.ChartSeriesOptionsAdapter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricStatValue;
import com.vmware.opsmgmt.client.advperfcharts.highcharts.LineChartSeriesOptions;
import com.vmware.opsmgmt.client.advperfcharts.highcharts.VerboseLineChartSeriesOptions;
import com.vmware.opsmgmt.client.advperfcharts.legend.LegendItem;
import com.vmware.vcenter.stats.topn.Datum;
import com.vmware.vcenter.stats.topn.TopRow;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class LineChartSeriesOptionsAdapter
implements ChartSeriesOptionsAdapter {
    @Override
    public ChartSeriesOptions createSeriesOptions(String unit, TopRow row) {
        LegendItem legendItem = new LegendItem();
        legendItem.relatedDeviceName = row.getObjectName();
        legendItem.units = unit;
        VerboseLineChartSeriesOptions seriesOptions = LineChartSeriesOptionsAdapter.createVerboseLineChartSeriesOptions(row, legendItem);
        return seriesOptions;
    }

    @Override
    public ChartSeriesOptions createSeriesOptions(PerformanceCounterStats stats) {
        return LineChartSeriesOptionsAdapter.createIndividualSeries(stats);
    }

    public static LineChartSeriesOptions createIndividualSeries(PerformanceCounterStats stats) {
        Preconditions.checkNotNull((Object)stats);
        Preconditions.checkNotNull((Object)stats.performanceCounter);
        Preconditions.checkNotNull((Object)stats.statistics);
        LineChartSeriesOptions seriesOptions = new LineChartSeriesOptions();
        seriesOptions.name = stats.performanceCounter.description;
        seriesOptions.entityId = stats.entity.getValue();
        seriesOptions.groupName = stats.performanceCounter.groupName;
        seriesOptions.groupId = stats.performanceCounter.groupId;
        seriesOptions.yAxis = stats.performanceCounter.statsUnitKey;
        seriesOptions.pointStart = LineChartSeriesOptionsAdapter.getPointStart(stats.statistics);
        seriesOptions.pointEnd = LineChartSeriesOptionsAdapter.getPointEnd(stats.statistics);
        seriesOptions.pointInterval = stats.interval;
        seriesOptions.data = LineChartSeriesOptionsAdapter.extractData(stats.statistics);
        seriesOptions.legendItem = LineChartSeriesOptionsAdapter.createLegendItem(stats.performanceCounter, seriesOptions.data);
        return seriesOptions;
    }

    private static LegendItem createLegendItem(PerformanceCounter performanceCounter, Float[] seriesOptionsData) {
        LegendItem legendItem = new LegendItem();
        legendItem.id = performanceCounter.id;
        legendItem.measurement = performanceCounter.name;
        legendItem.rollupType = performanceCounter.rollupType;
        legendItem.units = performanceCounter.statsUnitName;
        legendItem.relatedDeviceName = performanceCounter.relatedDeviceName;
        legendItem.nameKey = performanceCounter.nameKey;
        legendItem.relatedDeviceId = performanceCounter.relatedDeviceId;
        LineChartSeriesOptionsAdapter.populateStatistics(legendItem, seriesOptionsData);
        return legendItem;
    }

    private static VerboseLineChartSeriesOptions createVerboseLineChartSeriesOptions(TopRow row, LegendItem legendItem) {
        VerboseLineChartSeriesOptions verboseLineChartSeriesOptions = new VerboseLineChartSeriesOptions();
        verboseLineChartSeriesOptions.legendItem = legendItem;
        verboseLineChartSeriesOptions.name = row.getObjectName();
        verboseLineChartSeriesOptions.entityId = CisIdConverter.fromGlobalCisId((String)row.getObjectId(), (String)row.getObjectType()).getValue();
        verboseLineChartSeriesOptions.data = LineChartSeriesOptionsAdapter.toDataPointsArray(row.getDatumValues());
        return verboseLineChartSeriesOptions;
    }

    private static Number[][] toDataPointsArray(List<Datum> datumValues) {
        if (CollectionUtils.isEmpty(datumValues)) {
            return new Double[0][0];
        }
        int listSize = datumValues.size();
        Number[][] dataPointsArray = new Number[listSize][2];
        for (int index = 0; index < listSize; ++index) {
            Datum datum = datumValues.get(index);
            dataPointsArray[index][0] = datum.getTimestamp().getTimeInMillis();
            dataPointsArray[index][1] = datum.getValue();
        }
        return dataPointsArray;
    }

    private static void populateStatistics(LegendItem outLegendItem, Float[] seriesOptionsData) {
        float sum = 0.0f;
        float min = Float.MAX_VALUE;
        float max = Float.NEGATIVE_INFINITY;
        int nonNullValuesCount = 0;
        Float latestNonNullValue = null;
        for (Float value : seriesOptionsData) {
            if (value == null) continue;
            latestNonNullValue = value;
            ++nonNullValuesCount;
            sum += value.floatValue();
            max = Math.max(value.floatValue(), max);
            min = Math.min(value.floatValue(), min);
        }
        outLegendItem.average = sum / (float)nonNullValuesCount;
        outLegendItem.min = min;
        outLegendItem.max = max;
        outLegendItem.latest = latestNonNullValue;
    }

    private static Float[] extractData(PerformanceMetricStatValue[] statistics) {
        Float[] data = new Float[statistics.length];
        int statIndex = 0;
        for (PerformanceMetricStatValue stat : statistics) {
            data[statIndex++] = stat.value != -1.0f ? Float.valueOf(stat.value) : null;
        }
        return data;
    }

    private static Long getPointStart(PerformanceMetricStatValue[] statistics) {
        Long pointStart = null;
        if (statistics != null && statistics.length > 0 && statistics[0].timestamp != null) {
            pointStart = statistics[0].timestamp.getTime();
        }
        return pointStart;
    }

    private static Long getPointEnd(PerformanceMetricStatValue[] statistics) {
        Long pointEnd = null;
        if (statistics != null && statistics.length > 0 && statistics[statistics.length - 1].timestamp != null) {
            pointEnd = statistics[statistics.length - 1].timestamp.getTime();
        }
        return pointEnd;
    }
}

