/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn;

import com.google.common.collect.ImmutableMap;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricStatValue;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.data.QueryStatsError;
import com.vmware.opsmgmt.client.advperfcharts.topn.CounterId;
import com.vmware.opsmgmt.client.advperfcharts.topn.CounterStatsSummation;
import com.vmware.opsmgmt.client.advperfcharts.topn.CounterStatsSummationComparator;
import com.vmware.opsmgmt.client.advperfcharts.topn.GlobalPerformanceCounterProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.ReportDescriptor;
import com.vmware.opsmgmt.client.advperfcharts.topn.TopNProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.TopNQuery;
import com.vmware.opsmgmt.client.advperfcharts.topn.TopNResult;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.AnyStorageVmsMetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.DatastoreSiocMetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.StoragePodSiocMetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.VmFtMetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterProvider;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterUtil;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceManagerUtil;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceStatsProxy;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.fault.RestrictedByAdministrator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceManagerTopNProvider
implements TopNProvider {
    private static final Log _logger = LogFactory.getLog(PerformanceManagerTopNProvider.class);
    private static final String PERCENT_UNIT_KEY = "percent";
    private static final Map<PerformanceMetricTimeIntervals, Integer> _intervalIndices = ImmutableMap.of((Object)((Object)PerformanceMetricTimeIntervals.LAST_DAY), (Object)0, (Object)((Object)PerformanceMetricTimeIntervals.LAST_WEEK), (Object)1, (Object)((Object)PerformanceMetricTimeIntervals.LAST_MONTH), (Object)2, (Object)((Object)PerformanceMetricTimeIntervals.LAST_YEAR), (Object)3);
    private final MetricIdProvider _storagePodVmsMetricIdProvider;
    private final MetricIdProvider _datastoreVmsMetricIdProvider;
    private final MetricIdProvider _datastoreHostsMetricIdProvider;
    private final MetricIdProvider _datacenterClustersMetricIdProvider;
    private final MetricIdProvider _allDevicesMetricIdProvider;
    private final MetricIdProvider _storagePodSiocMetricIdProvider;
    private final MetricIdProvider _datastoreSiocMetricIdProvider;
    private final MetricIdProvider _vmFtMetricIdProvider;
    private final PerformanceManagerUtil _performanceManagerUtil;
    private final PerformanceStatsProxy _performanceStats;
    private final Map<String, ReportDescriptor> _reportDescriptors;

    PerformanceManagerTopNProvider(MetricIdProvider storagePodVmsMetricIdProvider, MetricIdProvider datastoreVmsMetricIdProvider, MetricIdProvider datastoreHostsMetricIdProvider, MetricIdProvider datacenterClustersMetricIdProvider, MetricIdProvider allDevicesMetricIdProvider, MetricIdProvider storagePodSiocMetricIdProvider, MetricIdProvider datastoreSiocMetricIdProvider, MetricIdProvider vmFtMetricIdProvider, PerformanceManagerUtil performanceManagerUtil, PerformanceStatsProxy performanceStats, Map<String, ReportDescriptor> reportDescriptors) {
        this._storagePodVmsMetricIdProvider = storagePodVmsMetricIdProvider;
        this._datastoreVmsMetricIdProvider = datastoreVmsMetricIdProvider;
        this._datastoreHostsMetricIdProvider = datastoreHostsMetricIdProvider;
        this._datacenterClustersMetricIdProvider = datacenterClustersMetricIdProvider;
        this._allDevicesMetricIdProvider = allDevicesMetricIdProvider;
        this._storagePodSiocMetricIdProvider = storagePodSiocMetricIdProvider;
        this._datastoreSiocMetricIdProvider = datastoreSiocMetricIdProvider;
        this._vmFtMetricIdProvider = vmFtMetricIdProvider;
        this._performanceManagerUtil = performanceManagerUtil;
        this._performanceStats = performanceStats;
        this._reportDescriptors = reportDescriptors;
    }

    @Override
    public List<TopNResult> queryReports(ManagedObjectReference object, TopNQuery query) throws Exception {
        PerformanceManager performanceManager = this._performanceManagerUtil.getPerformanceManager(object.getServerGuid());
        PerformanceManager.CounterInfo[] counterInfos = performanceManager.getPerfCounter();
        List<PerformanceCounter> availableCounters = PerformanceCounterUtil.createCounters(counterInfos);
        Map<String, List<PerformanceCounter>> countersByReport = this.getRequiredCounters(query.reportIds, availableCounters);
        ArrayList<PerformanceCounter> queriedCounters = new ArrayList<PerformanceCounter>();
        for (List<PerformanceCounter> counters : countersByReport.values()) {
            queriedCounters.addAll(counters);
        }
        MetricIdProvider metricIdProvider = this.getMetricIdProvider(object, query);
        List<TopNResult> result = new ArrayList<TopNResult>(query.reportIds.size());
        if (metricIdProvider != null) {
            MetricIdData metricIdData = metricIdProvider.getMetricIdData(object, queriedCounters);
            GlobalPerformanceCounterProvider counterProvider = new GlobalPerformanceCounterProvider(availableCounters, metricIdData);
            result = this.getTopNReports(countersByReport, new ArrayList<ManagedObjectReference>(metricIdData.queriedMetricIds.keySet()), counterProvider, performanceManager, query);
        }
        return result;
    }

    private MetricIdProvider getMetricIdProvider(ManagedObjectReference object, TopNQuery query) {
        if (Datacenter.class.getSimpleName().equals(object.getType())) {
            return this._datacenterClustersMetricIdProvider;
        }
        if (StoragePod.class.getSimpleName().equals(object.getType())) {
            if (StoragePodSiocMetricIdProvider.STORAGEPOD_SIOC_REPORTS.contains(query.reportIds.get(0))) {
                return this._storagePodSiocMetricIdProvider;
            }
            return this._storagePodVmsMetricIdProvider;
        }
        if (Datastore.class.getSimpleName().equals(object.getType())) {
            if (AnyStorageVmsMetricIdProvider.ANY_STORAGE_VMS_REPORTS.contains(query.reportIds.get(0))) {
                return this._datastoreVmsMetricIdProvider;
            }
            if (DatastoreSiocMetricIdProvider.DATASTORE_SIOC_REPORTS.contains(query.reportIds.get(0))) {
                return this._datastoreSiocMetricIdProvider;
            }
            return this._datastoreHostsMetricIdProvider;
        }
        if (VirtualMachine.class.getSimpleName().equals(object.getType())) {
            if (VmFtMetricIdProvider.VM_FT_REPORTS.contains(query.reportIds.get(0))) {
                return this._vmFtMetricIdProvider;
            }
            return this._allDevicesMetricIdProvider;
        }
        if (HostSystem.class.getSimpleName().equals(object.getType())) {
            return this._allDevicesMetricIdProvider;
        }
        _logger.error((Object)("TopN charts not implemented for a " + object.getType()));
        return null;
    }

    private List<TopNResult> getTopNReports(Map<String, List<PerformanceCounter>> countersByReport, List<ManagedObjectReference> subEntities, PerformanceCounterProvider counterProvider, PerformanceManager performanceManager, TopNQuery query) throws Exception {
        if (subEntities.isEmpty()) {
            return Collections.emptyList();
        }
        PerformanceInfoQuerySpec querySpec = PerformanceManagerTopNProvider.createInfoQuerySpec(query);
        HistoricalInterval[] historicalIntervals = null;
        Integer currentLevel = null;
        Integer intervalIndex = _intervalIndices.get((Object)query.timeRange.interval);
        if (intervalIndex != null) {
            historicalIntervals = performanceManager.getHistoricalInterval();
            currentLevel = historicalIntervals[intervalIndex.intValue()].level;
        }
        ArrayList<TopNResult> result = new ArrayList<TopNResult>(query.reportIds.size());
        ArrayList<PerformanceCounterStats> stats = new ArrayList();
        boolean isRestrictedByAdministrator = false;
        try {
            stats = this._performanceStats.getStats(subEntities, querySpec, performanceManager, historicalIntervals, counterProvider);
        }
        catch (RestrictedByAdministrator ex) {
            isRestrictedByAdministrator = true;
        }
        if (isRestrictedByAdministrator) {
            for (String reportId : query.reportIds) {
                TopNResult topNResult = new TopNResult();
                topNResult.reportId = reportId;
                topNResult.errorCode = QueryStatsError.RESTRICTED_BY_ADMINISTRATOR;
                result.add(topNResult);
            }
            return result;
        }
        Map<String, List<PerformanceCounterStats>> statsByReport = PerformanceManagerTopNProvider.indexStatsByReport(query, countersByReport, stats);
        for (String reportId : query.reportIds) {
            TopNResult topNResult = new TopNResult();
            topNResult.reportId = reportId;
            List<PerformanceCounterStats> relevantStats = statsByReport.get(reportId);
            if (relevantStats == null) {
                relevantStats = Collections.emptyList();
            }
            if (relevantStats.isEmpty() && currentLevel != null) {
                Integer minimumLevel = null;
                for (PerformanceCounter counter : countersByReport.get(reportId)) {
                    if (counter.level == null || minimumLevel != null && counter.level <= minimumLevel) continue;
                    minimumLevel = counter.level;
                }
                if (minimumLevel != null && minimumLevel > currentLevel) {
                    topNResult.requiredLevel = minimumLevel;
                }
            }
            ReportDescriptor reportDescriptor = this._reportDescriptors.get(reportId);
            topNResult.stats = this.getTop(relevantStats, reportDescriptor);
            this.convertUnits(topNResult.stats, reportDescriptor);
            result.add(topNResult);
        }
        return result;
    }

    private static PerformanceInfoQuerySpec createInfoQuerySpec(TopNQuery query) {
        PerformanceInfoQuerySpec querySpec = new PerformanceInfoQuerySpec();
        querySpec.interval = query.timeRange.interval;
        querySpec.startDate = query.timeRange.startDate;
        querySpec.endDate = query.timeRange.endDate;
        querySpec.customPeriodUnits = query.timeRange.customPeriodUnits;
        querySpec.customPeriodUnitsCount = query.timeRange.customPeriodUnitsCount;
        querySpec.format = PerformanceManager.Format.csv;
        return querySpec;
    }

    private static Map<String, List<PerformanceCounterStats>> indexStatsByReport(TopNQuery query, Map<String, List<PerformanceCounter>> countersByReport, List<PerformanceCounterStats> stats) {
        HashMap<String, List<PerformanceCounterStats>> statsByReport = new HashMap<String, List<PerformanceCounterStats>>(query.reportIds.size());
        for (Map.Entry<String, List<PerformanceCounter>> reportCounters : countersByReport.entrySet()) {
            List<PerformanceCounter> counters = reportCounters.getValue();
            ArrayList<PerformanceCounterStats> relevantStats = new ArrayList<PerformanceCounterStats>();
            for (PerformanceCounter counter : counters) {
                for (PerformanceCounterStats stat : stats) {
                    if (stat.performanceCounter.id != counter.id) continue;
                    relevantStats.add(stat);
                }
            }
            statsByReport.put(reportCounters.getKey(), relevantStats);
        }
        return statsByReport;
    }

    private Map<String, List<PerformanceCounter>> getRequiredCounters(List<String> reportIds, List<PerformanceCounter> availableCounters) {
        HashMap<String, List<PerformanceCounter>> result = new HashMap<String, List<PerformanceCounter>>(reportIds.size());
        for (String reportId : reportIds) {
            ReportDescriptor reportDescriptor = this._reportDescriptors.get(reportId);
            if (reportDescriptor == null) {
                _logger.error((Object)("Unknown report: " + reportId));
                continue;
            }
            List<CounterId> counterIds = reportDescriptor.getCounterIds();
            List<PerformanceCounter> counters = this.getCounters(availableCounters, counterIds);
            if (counters != null) {
                result.put(reportId, counters);
                continue;
            }
            _logger.error((Object)("Could not find counters identified by " + counterIds));
        }
        return result;
    }

    private List<PerformanceCounter> getCounters(List<PerformanceCounter> availableCounters, List<CounterId> counterIds) {
        ArrayList<PerformanceCounter> result = new ArrayList<PerformanceCounter>(counterIds.size());
        for (PerformanceCounter counter : availableCounters) {
            for (CounterId counterId : counterIds) {
                if (!counter.groupId.equals(counterId.getGroupKey()) || !counter.nameKey.equals(counterId.getNameKey()) || !counter.rollupType.equals(counterId.getRollupType())) continue;
                result.add(counter);
            }
        }
        return result;
    }

    private List<PerformanceCounterStats> getTop(List<PerformanceCounterStats> stats, ReportDescriptor reportDescriptor) {
        List<CounterStatsSummation> summations = new ArrayList(stats.size());
        for (PerformanceCounterStats stat : stats) {
            float sum = 0.0f;
            for (PerformanceMetricStatValue statValue : stat.statistics) {
                float value = 0.0f;
                if (statValue.value > -1.0f) {
                    value = statValue.value;
                }
                sum += value;
            }
            CounterStatsSummation summation = new CounterStatsSummation();
            summation.stat = stat;
            summation.sum = sum * (float)stat.interval.longValue();
            summations.add(summation);
        }
        Collections.sort(summations, new CounterStatsSummationComparator());
        int topN = reportDescriptor.getTopN();
        if (topN != 0 && summations.size() > topN) {
            summations = summations.subList(summations.size() - topN, summations.size());
        }
        ArrayList<PerformanceCounterStats> result = new ArrayList<PerformanceCounterStats>(summations.size());
        for (CounterStatsSummation summation : summations) {
            result.add(summation.stat);
        }
        return result;
    }

    private void convertUnits(List<PerformanceCounterStats> stats, ReportDescriptor reportDescriptor) {
        if (reportDescriptor.getConvertToPercent()) {
            String percentUnitName = ResourceUtil.getString((String)"AdvPerfCharts", (String)"unit.percent", (ClassLoader)PerformanceManagerTopNProvider.class.getClassLoader());
            for (PerformanceCounterStats stat : stats) {
                stat.performanceCounter.statsUnitKey = PERCENT_UNIT_KEY;
                stat.performanceCounter.statsUnitName = percentUnitName;
                for (PerformanceMetricStatValue statValue : stat.statistics) {
                    if (!(statValue.value > -1.0f)) continue;
                    statValue.value = statValue.value * 100.0f / (float)stat.interval.longValue();
                }
            }
        }
    }
}

