/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.clusterui.util.Util;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;

@type(value="Issue,AutonomousClusterConfigIssue")
public class AutonomousClusterConfigIssueAdapter
extends IssueAdapterBase {
    private static final String AUTONOMOUS_ISSUE_TYPE = "AutonomousClusterConfigIssue";
    static final String IS_AUTONOMOUS_PROPERTY = "isAutonomous";
    static final String HOST_COUNT_PROPERTY = "summary/numHosts";
    private final QueryService queryService;

    public AutonomousClusterConfigIssueAdapter(QueryServiceFactory queryServiceFactory) {
        super(AUTONOMOUS_ISSUE_TYPE);
        this.queryService = queryServiceFactory.getQueryService();
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)entity), (String)ClusterComputeResource.class.getSimpleName())) {
            return new IssueAdapterBase.IssueData[0];
        }
        ResultSet resultSet = this.queryService.select(new String[]{IS_AUTONOMOUS_PROPERTY, HOST_COUNT_PROPERTY}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, entity).fetch();
        if (resultSet.getItems().isEmpty()) {
            return new IssueAdapterBase.IssueData[0];
        }
        Boolean isAutonomous = (Boolean)((ResourceItem)resultSet.getItems().get(0)).get(IS_AUTONOMOUS_PROPERTY);
        Integer hostCount = (Integer)((ResourceItem)resultSet.getItems().get(0)).get(HOST_COUNT_PROPERTY);
        if (!Boolean.TRUE.equals(isAutonomous) || hostCount >= 3) {
            return new IssueAdapterBase.IssueData[0];
        }
        IssueInfo issueInfo = new IssueInfo();
        issueInfo.description = Util.getLocalizedString("autonomousCluster.config.issue.description", new String[0]);
        issueInfo.typeDisplayName = Util.getLocalizedString("autonomousCluster.config.issue.displayName", new String[0]);
        issueInfo.entity = entity;
        issueInfo.status = IssueStatus.WARNING;
        IssueAdapterBase.IssueData issueData = new IssueAdapterBase.IssueData();
        issueData.key = entity.toString();
        issueData.issueInfo = issueInfo;
        return new IssueAdapterBase.IssueData[]{issueData};
    }
}

