/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ClusterMoveToPropertyProvider {
    private static final String DC_PROPERTY = "dc";
    private final QueryService _queryService;

    public ClusterMoveToPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="ClusterComputeResource/isMoveToAvailable")
    public List<Boolean> getIsMoveToAvailable(Collection<ManagedObjectReference> clusterRefs) {
        if (clusterRefs.size() == 1) {
            return Collections.singletonList(true);
        }
        List<PropertyPredicate> filter = Collections.singletonList(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, clusterRefs));
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", DC_PROPERTY}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(LogicalOperator.AND, filter).fetch();
        boolean areClustersMoveable = this.areClustersMoveable(resultSet.getItems());
        return new ArrayList<Boolean>(Collections.nCopies(clusterRefs.size(), areClustersMoveable));
    }

    private boolean areClustersMoveable(List<ResourceItem> resourceItems) {
        if (CollectionUtils.isNotEmpty(resourceItems)) {
            ManagedObjectReference firstElementOwner = (ManagedObjectReference)resourceItems.get(0).get(DC_PROPERTY);
            if (firstElementOwner == null) {
                return false;
            }
            for (int i = 1; i < resourceItems.size(); ++i) {
                ResourceItem current = resourceItems.get(i);
                if (firstElementOwner.equals(current.get(DC_PROPERTY))) continue;
                return false;
            }
        }
        return true;
    }
}

