/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.cluster.DasVmConfigInfo;
import com.vmware.vim.binding.vim.cluster.DrsVmConfigInfo;
import com.vmware.vim.binding.vim.cluster.VmOrchestrationInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.model.configuration.VmOverrideListItemData;
import com.vmware.vsphere.client.clusterui.model.configuration.VmOverrideTargetData;
import com.vmware.vsphere.client.clusterui.model.monitor.ClusterOverrideData;
import com.vmware.vsphere.client.clusterui.model.services.VmVmcpSupportData;
import com.vmware.vsphere.client.clusterui.util.VmOverridesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class VmOverridePropertyProvider {
    private final QueryBindingService _queryBindingService;

    public VmOverridePropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @PropertyProvider(value="ClusterComputeResource/vmOverrides")
    public Collection<VmOverrideListItemData[]> getVmOverrides(Collection<ManagedObjectReference> objects) {
        if (objects == null || objects.size() != 1) {
            throw new IllegalArgumentException("getVmOverrides accepts only a single ClusterComputeResource parameter.");
        }
        Collection clusterData = this._queryBindingService.prepare(ClusterOverrideData.class).fetch(objects);
        Collection<VmOverrideListItemData> result = this.getVmOverrideListData((ClusterOverrideData)((Object)clusterData.iterator().next()));
        return Collections.singleton(result.toArray(new VmOverrideListItemData[0]));
    }

    @PropertyProvider(value="VirtualMachine/isVmcpSupportedForVm")
    public Collection<Boolean> getIsVmcpSupportedForVm(Collection<ManagedObjectReference> objects) {
        Collection vmcpSupportData = this._queryBindingService.prepare(VmVmcpSupportData.class).fetch(objects);
        HashMap<Object, Boolean> vmcpDataByVm = new HashMap<Object, Boolean>(vmcpSupportData != null ? vmcpSupportData.size() : 0);
        if (vmcpSupportData != null) {
            for (VmVmcpSupportData data : vmcpSupportData) {
                vmcpDataByVm.put(data.provider, data.isVmcpSupportedForVm());
            }
        }
        ArrayList<Boolean> resultItems = new ArrayList<Boolean>(objects.size());
        for (ManagedObjectReference vm : objects) {
            resultItems.add((Boolean)vmcpDataByVm.get(vm));
        }
        return resultItems;
    }

    private Collection<VmOverrideListItemData> getVmOverrideListData(ClusterOverrideData clusterData) {
        HashSet<ManagedObjectReference> vmRefs = new HashSet<ManagedObjectReference>();
        DrsVmConfigInfo[] drsVmConfigInfos = clusterData.drsVmConfigInfos;
        DasVmConfigInfo[] dasVmConfigInfos = clusterData.dasVmConfigInfos;
        VmOrchestrationInfo[] vmOrchestrationInfos = clusterData.resOrchVmConfig;
        if (drsVmConfigInfos == null && dasVmConfigInfos == null && vmOrchestrationInfos == null) {
            return Collections.emptyList();
        }
        if (drsVmConfigInfos != null) {
            for (DrsVmConfigInfo drsVmConfigInfo : drsVmConfigInfos) {
                vmRefs.add(drsVmConfigInfo.getKey());
            }
        }
        if (dasVmConfigInfos != null) {
            for (DrsVmConfigInfo drsVmConfigInfo : dasVmConfigInfos) {
                vmRefs.add(drsVmConfigInfo.getKey());
            }
        }
        if (vmOrchestrationInfos != null) {
            for (DrsVmConfigInfo drsVmConfigInfo : vmOrchestrationInfos) {
                vmRefs.add(drsVmConfigInfo.getVm());
            }
        }
        Map<ManagedObjectReference, VmOverrideTargetData> vmData = this.getTargetDataForVms(vmRefs);
        return VmOverridesUtil.buildVmOverrides(clusterData, vmData);
    }

    private Map<ManagedObjectReference, VmOverrideTargetData> getTargetDataForVms(Set<ManagedObjectReference> vms) {
        assert (!vms.isEmpty());
        HashMap<ManagedObjectReference, VmOverrideTargetData> result = new HashMap<ManagedObjectReference, VmOverrideTargetData>();
        Collection objectModels = this._queryBindingService.prepare(VmOverrideTargetData.class).fetch(vms);
        for (VmOverrideTargetData model : objectModels) {
            result.put((ManagedObjectReference)model.getProvider(), model);
        }
        return result;
    }
}

