/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.utilization.MemoryBaseUtilizationData;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="VirtualMachine")
public class VmMemoryUtilizationData
extends MemoryBaseUtilizationData {
    @Property(value="VirtualMachine/summary/quickStats/hostMemoryUsage")
    protected Integer consummation;
    @Property(value="VirtualMachine/summary/quickStats/consumedOverheadMemory")
    protected Integer overheadMemory;
    @Property(value="VirtualMachine/resourceConfig/memoryAllocation/reservation")
    protected Long reservation;
    @Property(value="VirtualMachine/resourceConfig/memoryAllocation/limit")
    protected Long limit;
    @Property(value="VirtualMachine/summary/config/memorySizeMB")
    protected Integer resourceSize;
    @Property(value="VirtualMachine/resourceConfig/memoryAllocation/shares")
    protected SharesInfo sharesInfo;
    @Property(value="VirtualMachine/summary/quickStats/staticMemoryEntitlement")
    protected Integer staticEntitlement;
    @Property(value="VirtualMachine/config/hardware/memoryMB")
    protected int numMemory;
    @Property(value="VirtualMachine/resourceConfig/memoryAllocation/overheadLimit")
    protected Long overheadLimit;
    @Property(value="VirtualMachine/memoryOverheadReservation")
    protected Long overheadAllocation;
    @Relationship(value={"VirtualMachine/cluster"})
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    public boolean clusterDrsEnabled;

    public String getOverheadLimit() {
        return Util.getMbMemoryFormatted(this.overheadLimit);
    }

    public String getOverheadAllocation() {
        return FormatUtil.getStorageFormatted((Long)this.getOverheadAllocationNum(), (long)1024L, (long)-1L);
    }

    public String getUsedReservation() {
        return FormatUtil.getStorageFormatted((Long)this.getUsedReservationNum(), (long)1024L, (long)-1L);
    }

    public String getNumMemory() {
        return Util.getMbMemoryFormatted(Long.valueOf(this.numMemory));
    }

    public String getResourceSize() {
        return Util.getMbMemoryFormatted(Util.getLongValue(this.resourceSize));
    }

    @Override
    protected Long getLimitValue() {
        return this.limit;
    }

    @Override
    protected Long getReservationValue() {
        return this.reservation;
    }

    @Override
    protected Integer getStaticEntitlementValue() {
        return this.staticEntitlement;
    }

    @Override
    protected Long getResourceSizeValue() {
        return Util.getLongValue(this.resourceSize);
    }

    @Override
    protected Long getConsummationValue() {
        return Util.getLongValue(this.consummation);
    }

    @Override
    protected Long getOverallDemand() {
        return Util.getLongValue(this.overheadMemory);
    }

    @Override
    protected SharesInfo getSharesInfoValue() {
        return this.sharesInfo;
    }

    @Override
    protected Integer getNumMemoryValue() {
        return this.numMemory;
    }

    private Long getOverheadAllocationNum() {
        if (this.overheadAllocation == null || this.overheadAllocation < 0L) {
            return 0L;
        }
        return this.overheadAllocation;
    }

    private Long getUsedReservationNum() {
        return this.getOverheadAllocationNum() + this.reservation * 1024L;
    }
}

