/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.util;

import com.vmware.vim.binding.vim.cluster.DrsFaults;
import com.vmware.vim.binding.vim.fault.DrsDisabledOnVm;
import com.vmware.vim.binding.vim.fault.DrsVmotionIncompatibleFault;
import com.vmware.vim.binding.vim.fault.InsufficientHostCapacityFault;
import com.vmware.vim.binding.vim.fault.InsufficientResourcesFault;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.fault.NoActiveHostInCluster;
import com.vmware.vim.binding.vim.fault.NoCompatibleHardAffinityHost;
import com.vmware.vim.binding.vim.fault.NoCompatibleHost;
import com.vmware.vim.binding.vim.fault.NoCompatibleSoftAffinityHost;
import com.vmware.vim.binding.vim.fault.NotEnoughLogicalCpus;
import com.vmware.vim.binding.vim.fault.RuleViolation;
import com.vmware.vim.binding.vim.fault.SoftRuleVioCorrectionDisallowed;
import com.vmware.vim.binding.vim.fault.SoftRuleVioCorrectionImpact;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.FaultVmTargetData;
import com.vmware.vsphere.client.drs.model.DrsFaultDetailItem;
import com.vmware.vsphere.client.drs.model.DrsFaultListItem;
import com.vmware.vsphere.client.drs.model.PreventedRecommendation;
import com.vmware.vsphere.client.drs.model.TargetNameData;
import com.vmware.vsphere.client.drs.util.FaultsLocalizationUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DrsFaultsUtil {
    private static final Log _logger = LogFactory.getLog(DrsFaultsUtil.class);
    private static final String DRSFAULT_POWERONVM = "powerOnVm";
    private static final String DRSFAULT_INCREASECAP = "increaseCapacity";
    private static final String DRSFAULT_ENTERSTANDBY = "enterStandby";
    private static final String DRSFAULT_INSUFFICIENT_RESOURCES = "unreservedCapacity";
    private static final String HOST_POWER_ON_ICON_CLASS = "vx-icon-hostPowerOn";
    private static final String CLUSTER_EDIT_ICON_CLASS = "vx-icon-cluster-edit";
    private static final String HOST_ENTER_STANDBY_MODE_ICON_CLASS = "vx-icon-hostShutDown";

    private DrsFaultsUtil() {
    }

    public static Set<ManagedObjectReference> getVmReferences(DrsFaults[] drsFaultsArray) {
        HashSet<ManagedObjectReference> vmRefs = new HashSet<ManagedObjectReference>();
        for (DrsFaults drsFault : drsFaultsArray) {
            if (drsFault == null) continue;
            for (DrsFaults.FaultsByVm vmFault : drsFault.getFaultsByVm()) {
                ManagedObjectReference vmRef = vmFault.getVm();
                if (vmRef == null) continue;
                vmRefs.add(vmRef);
            }
        }
        return vmRefs;
    }

    public static void collectDrsFaultHosts(DrsFaults[] drsFaultsArray, Set<ManagedObjectReference> hostRefs) {
        for (DrsFaults fault : drsFaultsArray) {
            if (fault == null) continue;
            for (DrsFaults.FaultsByVm vmFault : fault.faultsByVm) {
                if (vmFault == null || vmFault.vm == null) continue;
                for (Exception exception : vmFault.fault) {
                    ManagedObjectReference hostRef = DrsFaultsUtil.getHostProperty(exception);
                    if (hostRef == null) continue;
                    hostRefs.add(hostRef);
                }
            }
        }
    }

    public static List<DrsFaultListItem> makeGridData(DrsFaults[] drsFaults, Map<String, ManagedObjectReference> hostsByVmRef, Map<String, ? extends TargetNameData> hostNamesByRef, ObjectReferenceService objectReferenceService, Map<String, FaultVmTargetData> vmData) {
        assert (drsFaults != null);
        ArrayList<DrsFaultListItem> drsFaultItems = new ArrayList<DrsFaultListItem>(drsFaults.length);
        for (DrsFaults fault : drsFaults) {
            String hostId;
            String vmId;
            ManagedObjectReference hostObject;
            DrsFaults.FaultsByVm firstFault;
            if (fault == null) continue;
            DrsFaultListItem faultListItem = new DrsFaultListItem();
            List<DrsFaultDetailItem> drsFaultDetailItems = DrsFaultsUtil.buildFaultDetailsList(fault, hostNamesByRef, objectReferenceService, vmData);
            faultListItem.setReason(fault.getReason());
            faultListItem.setDetails(drsFaultDetailItems);
            if (fault.faultsByVm != null && fault.faultsByVm.length > 0 && (firstFault = fault.faultsByVm[0]) != null && firstFault.vm != null && (hostObject = hostsByVmRef.get(vmId = objectReferenceService.getUid((Object)firstFault.vm))) != null && hostNamesByRef.containsKey(hostId = objectReferenceService.getUid((Object)hostObject))) {
                TargetNameData host = hostNamesByRef.get(hostId);
                faultListItem.setTarget(host);
            }
            drsFaultItems.add(faultListItem);
        }
        return drsFaultItems;
    }

    private static <T extends TargetNameData> TargetNameData getTargetData(ManagedObjectReference mor, Map<String, T> list, ObjectReferenceService objectReferenceService) {
        String id = objectReferenceService.getUid((Object)mor);
        TargetNameData target = null;
        if (list.containsKey(id)) {
            target = (TargetNameData)list.get(id);
        }
        return target;
    }

    private static List<DrsFaultDetailItem> buildFaultDetailsList(DrsFaults fault, Map<String, ? extends TargetNameData> hostNamesByRef, ObjectReferenceService objectReferenceService, Map<String, FaultVmTargetData> vmData) {
        ArrayList<DrsFaultDetailItem> faultDetailItems = new ArrayList<DrsFaultDetailItem>();
        for (DrsFaults.FaultsByVm vmFault : fault.faultsByVm) {
            String faultDetailMessage;
            if (ArrayUtils.isEmpty((Object[])vmFault.fault)) continue;
            DrsFaultDetailItem faultDetailItem = new DrsFaultDetailItem();
            MethodFault firstFault = (MethodFault)((Object)vmFault.getFault()[0]);
            faultDetailItem.setHelpId(DrsFaultsUtil.getDrsFaultHelpExtensionId((Exception)((Object)firstFault)));
            String faultMessage = FaultsLocalizationUtil.getDrsFaultMessage((Exception)((Object)firstFault));
            LocalizableMessage[] localizableMessages = firstFault.getFaultMessage();
            if (localizableMessages != null) {
                StringJoiner sj = new StringJoiner(" ");
                sj.add(faultMessage);
                for (LocalizableMessage localizableMessage : localizableMessages) {
                    String key = localizableMessage.getKey();
                    KeyAnyValue[] args = localizableMessage.getArg();
                    String message = LocalizationUtil.getLocalizedMessage((String)key, (KeyAnyValue[])args);
                    sj.add(message);
                }
                faultDetailMessage = sj.toString();
            } else {
                faultDetailMessage = faultMessage;
            }
            faultDetailItem.setFaultDetailMessage(faultDetailMessage);
            boolean includeVmTarget = false;
            PreventedRecommendation preventedRecommendation = new PreventedRecommendation();
            if (fault.getReason().equals(DRSFAULT_POWERONVM)) {
                includeVmTarget = true;
                preventedRecommendation = DrsFaultsUtil.buildPreventedRecommendationWithTargetHost((Exception)((Object)firstFault), hostNamesByRef, objectReferenceService);
            } else if (fault.getReason().equals(DRSFAULT_INCREASECAP)) {
                preventedRecommendation = DrsFaultsUtil.buildPreventedRecommendation((Exception)((Object)firstFault), hostNamesByRef, objectReferenceService);
                faultDetailItem.setPreventedRecommendationIcon(HOST_POWER_ON_ICON_CLASS);
            } else if (fault.getReason().equals(DRSFAULT_ENTERSTANDBY)) {
                preventedRecommendation = DrsFaultsUtil.buildPreventedRecommendationWithTargetHost((Exception)((Object)firstFault), hostNamesByRef, objectReferenceService);
                faultDetailItem.setPreventedRecommendationIcon(HOST_ENTER_STANDBY_MODE_ICON_CLASS);
            } else if (fault.getReason().equals(DRSFAULT_INSUFFICIENT_RESOURCES)) {
                faultDetailItem.setPreventedRecommendationIcon(CLUSTER_EDIT_ICON_CLASS);
            } else {
                includeVmTarget = true;
                preventedRecommendation = DrsFaultsUtil.buildPreventedRecommendation((Exception)((Object)firstFault), hostNamesByRef, objectReferenceService);
            }
            if (preventedRecommendation != null) {
                String vmId;
                if (includeVmTarget && (vmId = objectReferenceService.getUid((Object)vmFault.getVm())) != null) {
                    faultDetailItem.setPreventedRecommendationIcon(vmData.get((Object)vmId).primaryIconId);
                    TargetNameData target = DrsFaultsUtil.getTargetData(vmFault.getVm(), vmData, objectReferenceService);
                    if (target != null) {
                        preventedRecommendation.setTargetVm(target);
                    }
                }
                faultDetailItem.setPreventedRecommendation(preventedRecommendation);
            }
            faultDetailItems.add(faultDetailItem);
        }
        return faultDetailItems;
    }

    private static String getDrsFaultHelpExtensionId(Exception fault) {
        if (fault instanceof NoActiveHostInCluster) {
            return "IDH_TSFAULT_NOACTIVEHOST";
        }
        if (fault instanceof InvalidState) {
            return "IDH_TSFAULT_INCORRECTSTATE";
        }
        if (fault instanceof NotEnoughLogicalCpus) {
            return "IDH_TSFAULT_CPU";
        }
        if (fault instanceof RuleViolation) {
            return "IDH_TSVM_AFFINITY";
        }
        if (fault instanceof DrsDisabledOnVm) {
            return "IDH_TSHOST_VMOTION";
        }
        if (fault instanceof NoCompatibleHost || fault instanceof DrsVmotionIncompatibleFault) {
            return "IDH_TSFAULT_HOSTINCOMPATIBLE";
        }
        if (fault instanceof InsufficientHostCapacityFault) {
            return "IDH_TSFAULT_CAPACITY";
        }
        if (fault instanceof InsufficientResourcesFault) {
            return "IDH_TSFAULT_INSUFFICIENTRESOURCES";
        }
        if (fault instanceof NoCompatibleHardAffinityHost) {
            return "IDH_TSFAULT_NOCOMPAT_HARD_AFFINITY_HOST";
        }
        if (fault instanceof NoCompatibleSoftAffinityHost) {
            return "IDH_TSFAULT_NOCOMPAT_SOFT_AFFINITY_HOST";
        }
        if (fault instanceof SoftRuleVioCorrectionDisallowed) {
            return "IDH_TSFAULT_SOFT_RULE_VIOLATION_CORR_DISALLOWED";
        }
        if (fault instanceof SoftRuleVioCorrectionImpact) {
            return "IDH_TSFAULT_SOFT_RULE_VIOLATION_CORR_IMPACT";
        }
        return "IDH_TSFAULT";
    }

    private static PreventedRecommendation buildPreventedRecommendation(Exception vmFault, Map<String, ? extends TargetNameData> hostNamesByRef, ObjectReferenceService objectReferenceService) {
        TargetNameData target;
        PreventedRecommendation preventedRecommendation = new PreventedRecommendation();
        ManagedObjectReference hostRef = DrsFaultsUtil.getHostProperty(vmFault);
        if (hostRef != null && (target = DrsFaultsUtil.getTargetData(hostRef, hostNamesByRef, objectReferenceService)) != null) {
            preventedRecommendation.setTargetHost(target);
        }
        return preventedRecommendation;
    }

    private static PreventedRecommendation buildPreventedRecommendationWithTargetHost(Exception vmFault, Map<String, ? extends TargetNameData> hostNamesByRef, ObjectReferenceService objectReferenceService) {
        TargetNameData target;
        PreventedRecommendation preventedRecommendation = new PreventedRecommendation();
        ManagedObjectReference hostRef = DrsFaultsUtil.getHostProperty(vmFault);
        if (hostRef != null && (target = DrsFaultsUtil.getTargetData(hostRef, hostNamesByRef, objectReferenceService)) != null) {
            preventedRecommendation.setTargetHost(target);
        }
        return preventedRecommendation;
    }

    private static ManagedObjectReference getHostProperty(Exception methodFault) {
        ManagedObjectReference hostRef = null;
        try {
            Class<?> exceptionClass = methodFault.getClass();
            Field hostField = exceptionClass.getField("host");
            if (hostField.get(exceptionClass) instanceof ManagedObjectReference) {
                hostRef = (ManagedObjectReference)hostField.get(exceptionClass);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException noSuchFieldEx) {
            _logger.debug((Object)noSuchFieldEx);
            try {
                Class<?> faultClass = methodFault.getClass();
                Method faultMethod = faultClass.getMethod("getHost", new Class[0]);
                hostRef = (ManagedObjectReference)faultMethod.invoke((Object)methodFault, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException noSuchMethodEx) {
                _logger.debug((Object)noSuchMethodEx);
            }
        }
        return hostRef;
    }
}

