/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.util;

import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.cluster.DasConfigInfo;
import com.vmware.vim.binding.vim.cluster.DasVmConfigInfo;
import com.vmware.vim.binding.vim.cluster.DasVmSettings;
import com.vmware.vim.binding.vim.cluster.DrsConfigInfo;
import com.vmware.vim.binding.vim.cluster.DrsVmConfigInfo;
import com.vmware.vim.binding.vim.cluster.VmComponentProtectionSettings;
import com.vmware.vim.binding.vim.cluster.VmOrchestrationInfo;
import com.vmware.vim.binding.vim.cluster.VmReadiness;
import com.vmware.vim.binding.vim.cluster.VmToolsMonitoringSettings;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.cluster.util.Util;
import com.vmware.vsphere.client.clusterui.model.configuration.VmOverrideListItemData;
import com.vmware.vsphere.client.clusterui.model.configuration.VmOverrideTargetData;
import com.vmware.vsphere.client.clusterui.model.monitor.ClusterOverrideData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class VmOverridesUtil {
    static final String VM_OVERRIDES_OPTION_NA_S = "VmOverrideNA_S";
    static final String VM_OVERRIDES_OPTION_DISABLED = "disabled";
    static final int NO_FAILURE_WINDOW_VALUE = -1;
    static final int RESTART_PRIORITY_TIMEOUT_CLUSTER_DEFAULT = -1;
    private static final String RESET_VM_KEY = "reset";
    static final String DO_NOT_RESET_VM_KEY = "none";
    static final String CLUSTER_DEFAULT = "clusterDefault";
    static final int HOUR_SECONDS = 3600;
    private static final String ISOLATION_RESPONSE_ENSURE_FT = "EnsureFT";
    private static final int HA_INTERVAL_BEFORE_VMCP_REACTION_CLUSTER_DEFAULTS = -1;
    private static final String ISOLATION_RESPONSE_KEY = "ha.config.vm.hostIsolationResponse.";
    private static final String RESTART_PRIORITY_KEY = "ha.config.vm.vmRestartPriority.";
    private static final String PDL_PROTECTION_LEVEL_KEY = "ha.config.vmResponse.storageProtectionForPdl.";
    private static final String APD_PROTECTION_LEVEL_KEY = "ha.config.vmResponse.storageProtectionForApd.";
    private static final String MINUTES_FORMATTER_KEY = "vmOverrides.intervalBeforeVmcpReaction.format";
    private static final String VM_MONITORING_KEY = "ha.config.vmmonitoring.";
    private static final String VM_FAILURE_INTERVAL = "vmFailureInterval";
    private static final String VM_MIN_UP_TIME = "vmMinUpTime";
    private static final String VM_MAX_FAILURES = "vmMaxFailures";
    private static final String VM_MAX_FAILURE_WINDOW = "vmMaxFailureWindow";
    private static final String NO_FAILURE_WINDOW_KEY = "ha.config.vmResponse.vmMonitoringSensitivity.noWindow";

    public static Collection<VmOverrideListItemData> buildVmOverrides(ClusterOverrideData clusterData, Map<ManagedObjectReference, VmOverrideTargetData> vmData) {
        VmOverrideTargetData vmTargetData;
        DasVmConfigInfo[] dasVmConfigInfos = clusterData.dasVmConfigInfos;
        DrsVmConfigInfo[] drsVmConfigInfos = clusterData.drsVmConfigInfos;
        VmOrchestrationInfo[] vmOrchestrationInfo = clusterData.resOrchVmConfig;
        HashMap<ManagedObjectReference, VmOverrideListItemData> vmOverrides = new HashMap<ManagedObjectReference, VmOverrideListItemData>();
        if (clusterData.haEnabled.booleanValue()) {
            if (dasVmConfigInfos != null) {
                for (DasVmConfigInfo dasVmConfigInfo : dasVmConfigInfos) {
                    VmOverrideListItemData vmOverrideItem;
                    vmTargetData = vmData.get(dasVmConfigInfo.getKey());
                    if (vmTargetData == null || vmTargetData.isSecondaryVm() || (vmOverrideItem = VmOverridesUtil.getVmOverrideItem(dasVmConfigInfo, null, vmTargetData, clusterData)) == null) continue;
                    vmOverrides.put(dasVmConfigInfo.key, vmOverrideItem);
                }
            }
            if (vmOrchestrationInfo != null) {
                for (DasVmConfigInfo dasVmConfigInfo : clusterData.resOrchVmConfig) {
                    if (dasVmConfigInfo == null || (vmTargetData = vmData.get(dasVmConfigInfo.getVm())) == null || vmTargetData.isSecondaryVm()) continue;
                    VmOverrideListItemData vmListItemExisting = (VmOverrideListItemData)vmOverrides.get(dasVmConfigInfo.vm);
                    VmOverrideListItemData vmListItem = vmListItemExisting != null ? VmOverridesUtil.mergeVmOverrideDataForRestartOrchestration(vmListItemExisting, (VmOrchestrationInfo)dasVmConfigInfo, clusterData) : VmOverridesUtil.getVmOverrideItemForRestartOrchestration((VmOrchestrationInfo)dasVmConfigInfo, vmTargetData, clusterData);
                    vmOverrides.put(dasVmConfigInfo.getVm(), vmListItem);
                }
            }
        }
        if (clusterData.drsEnabled.booleanValue() && drsVmConfigInfos != null) {
            for (DasVmConfigInfo dasVmConfigInfo : drsVmConfigInfos) {
                VmOverrideListItemData drsVmOverride;
                vmTargetData = vmData.get(dasVmConfigInfo.getKey());
                if (vmTargetData == null || vmTargetData.isSecondaryVm() || (drsVmOverride = VmOverridesUtil.getVmOverrideItem(null, (DrsVmConfigInfo)dasVmConfigInfo, vmTargetData, clusterData)) == null) continue;
                ManagedObjectReference vmId = dasVmConfigInfo.key;
                VmOverrideListItemData vmOverrideItem = (VmOverrideListItemData)vmOverrides.get(vmId);
                if (vmOverrideItem == null) {
                    vmOverrides.put(vmId, drsVmOverride);
                    continue;
                }
                vmOverrideItem.drsOverrides = drsVmOverride.drsOverrides;
            }
        }
        return vmOverrides.values();
    }

    public static boolean getFtDrsWithoutEvcSupported(ManagedObjectReference mor) {
        VcService vcService = VimSessionUtil.getService((String)mor.getServerGuid());
        if (vcService == null) {
            return false;
        }
        ServiceInstance serviceInstance = vcService.getServiceInstance();
        if (serviceInstance == null) {
            return false;
        }
        Capability capability = serviceInstance.getCapability();
        if (capability == null) {
            return false;
        }
        if (capability.ftDrsWithoutEvcSupported == null) {
            return false;
        }
        return capability.ftDrsWithoutEvcSupported;
    }

    private static VmOverrideListItemData mergeVmOverrideDataForRestartOrchestration(VmOverrideListItemData vmListItem, VmOrchestrationInfo resOrchConfigInfo, ClusterOverrideData vmOvConfigData) {
        String haRestartConditions = VmOverridesUtil.getHaRestartConditionValue(vmOvConfigData.haEnabled, resOrchConfigInfo);
        vmListItem.haOverrides.haRestartConditionsText = VmOverridesUtil.getVmRestartConditionText(haRestartConditions, vmOvConfigData.clusterVmReadyCondition);
        vmListItem.haOverrides.overridesResOrchOptions = true;
        return vmListItem;
    }

    private static VmOverrideListItemData getVmOverrideItemForRestartOrchestration(VmOrchestrationInfo resOrchConfigInfo, VmOverrideTargetData vmData, ClusterOverrideData vmOvConfigData) {
        VmOverrideListItemData vmListItem = VmOverridesUtil.instantiateVmOverridesListItem(null, null, vmData, vmOvConfigData, resOrchConfigInfo);
        return vmListItem;
    }

    private static String getHaRestartConditionValue(boolean isHaEnabled, VmOrchestrationInfo vmOrchConfigInfoItem) {
        if (!isHaEnabled) {
            return VM_OVERRIDES_OPTION_NA_S;
        }
        if (vmOrchConfigInfoItem == null) {
            return VmReadiness.ReadyCondition.useClusterDefault.toString();
        }
        return vmOrchConfigInfoItem.vmReadiness.readyCondition;
    }

    private static String getVmRestartConditionText(String vmRestartCondition, String clusterRestartCondition) {
        if (VM_OVERRIDES_OPTION_NA_S.equals(vmRestartCondition)) {
            return VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
        }
        if (VmReadiness.ReadyCondition.none.name().equals(vmRestartCondition)) {
            return VmOverrideBehavior.RESTART_CONDITION_NONE.getLocalizedString(new String[0]);
        }
        if (VmReadiness.ReadyCondition.poweredOn.name().equals(vmRestartCondition)) {
            return VmOverrideBehavior.RESTART_CONDITION_POWER_ON.getLocalizedString(new String[0]);
        }
        if (VmReadiness.ReadyCondition.guestHbStatusGreen.name().equals(vmRestartCondition)) {
            return VmOverrideBehavior.RESTART_CONDITION_GUEST_HB_DETECTED.getLocalizedString(new String[0]);
        }
        if (VmReadiness.ReadyCondition.appHbStatusGreen.name().equals(vmRestartCondition)) {
            return VmOverrideBehavior.RESTART_CONDITION_APP_HB_DETECTED.getLocalizedString(new String[0]);
        }
        if (VmReadiness.ReadyCondition.useClusterDefault.name().equals(vmRestartCondition)) {
            String value = VmOverridesUtil.getVmRestartConditionText(clusterRestartCondition, null);
            return VmOverrideBehavior.RESTART_CONDITION_DEFAULT.getLocalizedString(value);
        }
        return null;
    }

    private static VmOverrideListItemData getVmOverrideItem(DasVmConfigInfo dasVmConfigInfo, DrsVmConfigInfo drsVmConfigInfo, VmOverrideTargetData vmTargetData, ClusterOverrideData clusterData) {
        VmOverrideListItemData vmListItem = null;
        VmOrchestrationInfo vmOrchestrationInfo = VmOverridesUtil.getVmOrchestrationInfo(vmTargetData.getProvider(), clusterData.resOrchVmConfig);
        if (dasVmConfigInfo != null) {
            VmComponentProtectionSettings dasVmcpSettings = dasVmConfigInfo.dasSettings.vmComponentProtectionSettings;
            Boolean isDefaultClusterRestartPriority = VmOverridesUtil.getDefaultClusterRestartPriority(dasVmConfigInfo);
            Boolean isDefaultClusterIsolationResponse = VmOverridesUtil.getDefaultClusterIsolationResponse(dasVmConfigInfo);
            Boolean isDefaultVmcpSettings = dasVmcpSettings == null;
            if (isDefaultClusterRestartPriority.booleanValue() && isDefaultClusterIsolationResponse.booleanValue() && isDefaultVmcpSettings.booleanValue()) {
                return null;
            }
            vmListItem = VmOverridesUtil.instantiateVmOverridesListItem(dasVmConfigInfo, null, vmTargetData, clusterData, vmOrchestrationInfo);
        } else if (drsVmConfigInfo != null) {
            vmListItem = VmOverridesUtil.instantiateVmOverridesListItem(null, drsVmConfigInfo, vmTargetData, clusterData, vmOrchestrationInfo);
        }
        return vmListItem;
    }

    private static VmOrchestrationInfo getVmOrchestrationInfo(Object vm, VmOrchestrationInfo[] vmOrchestrationInfos) {
        VmOrchestrationInfo result = null;
        if (!ArrayUtils.isEmpty((Object[])vmOrchestrationInfos)) {
            for (VmOrchestrationInfo vmOrchestrationInfo : vmOrchestrationInfos) {
                if (!vmOrchestrationInfo.getVm().equals(vm)) continue;
                result = vmOrchestrationInfo;
                break;
            }
        }
        return result;
    }

    private static Boolean getDefaultClusterRestartPriority(DasVmConfigInfo dasVmConfigInfo) {
        Boolean isClusterRestartPriority = DasVmSettings.RestartPriority.clusterRestartPriority.name().equals(dasVmConfigInfo.dasSettings.restartPriority);
        Boolean isVmRestartPriorityUnset = dasVmConfigInfo.dasSettings.restartPriority == null;
        return isVmRestartPriorityUnset != false || isClusterRestartPriority != false;
    }

    private static Boolean getDefaultClusterIsolationResponse(DasVmConfigInfo dasVmConfigInfo) {
        Boolean isClusterIsolationResponse = DasVmSettings.IsolationResponse.clusterIsolationResponse.name().equals(dasVmConfigInfo.dasSettings.isolationResponse);
        Boolean isVmIsolationResponseUnset = dasVmConfigInfo.dasSettings.isolationResponse == null;
        return isClusterIsolationResponse != false || isVmIsolationResponseUnset != false;
    }

    private static VmOverrideListItemData instantiateVmOverridesListItem(DasVmConfigInfo dasVmConfigInfo, DrsVmConfigInfo drsVmConfigInfo, VmOverrideTargetData vmTargetData, ClusterOverrideData clusterData, VmOrchestrationInfo resOrchConfigInfo) {
        ManagedObjectReference clusterRef;
        VmOverrideListItemData vmListItem = new VmOverrideListItemData(vmTargetData);
        if (drsVmConfigInfo != null) {
            vmListItem.drsOverrides.enabled = drsVmConfigInfo.getEnabled();
            vmListItem.drsOverrides.overridesDrsOptions = true;
        }
        boolean ftDrsWithoutEvcSupported = VmOverridesUtil.getFtDrsWithoutEvcSupported(clusterRef = (ManagedObjectReference)clusterData.provider) || clusterData.isEvcEnabled() != false;
        vmListItem.drsOverrides.drsAutomationLevelEditable = VmOverridesUtil.isDrsAutomationLevelEditable(clusterData.drsEnabled, clusterData.clusterPerVmAutomationEnabled, vmTargetData.isPrimaryVm(), ftDrsWithoutEvcSupported);
        vmListItem.drsOverrides.drsAutomationLevel = VmOverridesUtil.getDrsAutomationLevelValue(clusterData.drsEnabled, vmTargetData.isPrimaryVm(), ftDrsWithoutEvcSupported, clusterData.clusterPerVmAutomationEnabled, drsVmConfigInfo);
        vmListItem.drsOverrides.drsAutomationLevelText = VmOverridesUtil.getVmDrsAutLevelText(vmListItem.drsOverrides.drsAutomationLevel, clusterData.clusterDrsAutomationLevel);
        if (dasVmConfigInfo != null) {
            vmListItem.haOverrides.overridesHaOptions = true;
        }
        if (resOrchConfigInfo != null) {
            vmListItem.haOverrides.overridesResOrchOptions = true;
        }
        String haRestartConditions = VmOverridesUtil.getHaRestartConditionValue(clusterData.haEnabled, resOrchConfigInfo);
        vmListItem.haOverrides.haRestartConditionsText = VmOverridesUtil.getVmRestartConditionText(haRestartConditions, clusterData.clusterVmReadyCondition);
        vmListItem.haOverrides.haRestartPriority = VmOverridesUtil.getHaRestartPriorityValue(clusterData.haEnabled, dasVmConfigInfo);
        vmListItem.haOverrides.haRestartPriorityText = VmOverridesUtil.getVmRestartPriorityText(clusterData, vmListItem.haOverrides.haRestartPriority);
        vmListItem.haOverrides.haRestartPriorityTimeout = VmOverridesUtil.getVmRestartPriorityTimeout(clusterData, dasVmConfigInfo);
        vmListItem.haOverrides.haRestartPriorityTimeoutText = VmOverridesUtil.getVmRestartPriorityTimeoutText(clusterData, vmListItem.haOverrides.haRestartPriorityTimeout);
        vmListItem.haOverrides.haRestartConditionDelay = VmOverridesUtil.getVmRestartConditionDelay(clusterData, resOrchConfigInfo);
        vmListItem.haOverrides.vmFailureInterval = VmOverridesUtil.getVmMonitoringFailureTextValues(clusterData, dasVmConfigInfo).get(VM_FAILURE_INTERVAL);
        vmListItem.haOverrides.vmMaxFailures = VmOverridesUtil.getVmMonitoringFailureTextValues(clusterData, dasVmConfigInfo).get(VM_MAX_FAILURES);
        vmListItem.haOverrides.vmMaxFailureWindow = VmOverridesUtil.getVmMonitoringFailureTextValues(clusterData, dasVmConfigInfo).get(VM_MAX_FAILURE_WINDOW);
        vmListItem.haOverrides.vmMinUptime = VmOverridesUtil.getVmMonitoringFailureTextValues(clusterData, dasVmConfigInfo).get(VM_MIN_UP_TIME);
        VmOverridesUtil.setVmMonitoringFailuresValues(clusterData, dasVmConfigInfo, vmListItem);
        vmListItem.haOverrides.haIsolationResponse = VmOverridesUtil.getHaIsolationResponseValue(clusterData.haEnabled, vmTargetData.isPrimaryVm(), dasVmConfigInfo);
        vmListItem.haOverrides.haIsolationResponseText = VmOverridesUtil.getVmHostIsolationResponseText(vmListItem.haOverrides.haIsolationResponse, clusterData.clusterHostIsolationResponse);
        vmListItem.haOverrides.vmMonitoring = VmOverridesUtil.getVmMonitoringValue(clusterData, dasVmConfigInfo);
        vmListItem.haOverrides.vmMonitoringText = VmOverridesUtil.getVmMonitoringText(clusterData, vmListItem.haOverrides.vmMonitoring);
        vmListItem.haOverrides.vmMonitoringSensitivity = VmOverridesUtil.getVmMonitoringSensitivityValue(clusterData, dasVmConfigInfo, vmListItem.haOverrides.vmMonitoring);
        vmListItem.haOverrides.vmMonitoringSensitivityText = VmOverridesUtil.getVmMonitoringSensitivityText(clusterData, vmListItem.haOverrides.vmMonitoringSensitivity);
        vmListItem.haOverrides.vmMonitoringWarningText = VmOverridesUtil.getVmMonitoringWarningText(clusterData.vmMonitoring, vmListItem.haOverrides.vmMonitoring);
        VmOverridesUtil.populateVmcpSettings(vmListItem, clusterData, dasVmConfigInfo);
        return vmListItem;
    }

    private static String getVmRestartPriorityText(ClusterOverrideData clusterData, String vmRestartPrio) {
        String clusterRestartPrio = clusterData.clusterVmRestartPriority;
        if (VM_OVERRIDES_OPTION_NA_S.equals(vmRestartPrio)) {
            return VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
        }
        if (DasVmSettings.RestartPriority.disabled.name().equals(vmRestartPrio)) {
            return VmOverrideBehavior.DISABLED_RESTART_PRIORITY.getLocalizedString(new String[0]);
        }
        if (DasVmSettings.RestartPriority.lowest.name().equals(vmRestartPrio)) {
            return VmOverrideBehavior.LOWEST_RESTART_PRIORITY.getLocalizedString(new String[0]);
        }
        if (DasVmSettings.RestartPriority.low.name().equals(vmRestartPrio)) {
            return VmOverrideBehavior.LOW_RESTART_PRIORITY.getLocalizedString(new String[0]);
        }
        if (DasVmSettings.RestartPriority.medium.name().equals(vmRestartPrio)) {
            return VmOverrideBehavior.MEDIUM_RESTART_PRIORITY.getLocalizedString(new String[0]);
        }
        if (DasVmSettings.RestartPriority.high.name().equals(vmRestartPrio)) {
            return VmOverrideBehavior.HIGH_RESTART_PRIORITY.getLocalizedString(new String[0]);
        }
        if (DasVmSettings.RestartPriority.highest.name().equals(vmRestartPrio)) {
            return VmOverrideBehavior.HIGHEST_RESTART_PRIORITY.getLocalizedString(new String[0]);
        }
        if (DasVmSettings.RestartPriority.clusterRestartPriority.name().equals(vmRestartPrio)) {
            return VmOverridesUtil.getDefaultClusterRestartPriorityText(clusterRestartPrio);
        }
        return null;
    }

    private static String getVmRestartPriorityTimeoutText(ClusterOverrideData clusterData, int restartPriorityTimeout) {
        if (!clusterData.haEnabled.booleanValue()) {
            return VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
        }
        if (restartPriorityTimeout == -1) {
            return VmOverrideBehavior.RESTART_PRIORITY_TIMEOUT.getLocalizedString(Integer.toString(clusterData.clusterVmRestartPriorityTimeout));
        }
        return VmOverrideBehavior.RESTART_PRIORITY_TIMEOUT.getLocalizedString(Integer.toString(restartPriorityTimeout));
    }

    private static int getVmRestartPriorityTimeout(ClusterOverrideData clusterData, DasVmConfigInfo dasVmConfigInfo) {
        if (dasVmConfigInfo == null || dasVmConfigInfo.dasSettings == null) {
            return -1;
        }
        Integer vmRestartTimeout = dasVmConfigInfo.dasSettings.restartPriorityTimeout;
        if (vmRestartTimeout == null || vmRestartTimeout == -1) {
            return -1;
        }
        return vmRestartTimeout;
    }

    private static Map<String, String> getVmMonitoringFailureTextValues(ClusterOverrideData clusterData, DasVmConfigInfo dasVmConfigInfo) {
        HashMap<String, String> vmMonitoringFailureValues = new HashMap<String, String>();
        String vmNaFailures = VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
        if (!clusterData.haEnabled.booleanValue()) {
            vmMonitoringFailureValues.put(VM_FAILURE_INTERVAL, vmNaFailures);
            vmMonitoringFailureValues.put(VM_MIN_UP_TIME, vmNaFailures);
            vmMonitoringFailureValues.put(VM_MAX_FAILURES, vmNaFailures);
            vmMonitoringFailureValues.put(VM_MAX_FAILURE_WINDOW, vmNaFailures);
        } else if (dasVmConfigInfo == null || dasVmConfigInfo.dasSettings == null || dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings == null || dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.clusterSettings != null && dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.clusterSettings.booleanValue()) {
            VmOverridesUtil.setClusterDefaultVmFailureInterval(clusterData, vmMonitoringFailureValues);
            VmOverridesUtil.setClusterDefaultVmMinUpTime(clusterData, vmMonitoringFailureValues);
            VmOverridesUtil.setClusterDefaultVmMaxFailures(clusterData, vmMonitoringFailureValues);
            VmOverridesUtil.setClusterDefaultMaxFailuresWindow(clusterData, vmMonitoringFailureValues);
        } else {
            if (dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.failureInterval != null) {
                vmMonitoringFailureValues.put(VM_FAILURE_INTERVAL, VmOverridesUtil.getSecondsText(dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.failureInterval));
            } else {
                VmOverridesUtil.setClusterDefaultVmFailureInterval(clusterData, vmMonitoringFailureValues);
            }
            if (dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.minUpTime != null) {
                vmMonitoringFailureValues.put(VM_MIN_UP_TIME, VmOverridesUtil.getSecondsText(dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.minUpTime));
            } else {
                VmOverridesUtil.setClusterDefaultVmMinUpTime(clusterData, vmMonitoringFailureValues);
            }
            if (dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.maxFailures != null) {
                vmMonitoringFailureValues.put(VM_MAX_FAILURES, Integer.toString(dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.maxFailures));
            } else {
                VmOverridesUtil.setClusterDefaultVmMaxFailures(clusterData, vmMonitoringFailureValues);
            }
            if (dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.maxFailureWindow != null) {
                vmMonitoringFailureValues.put(VM_MAX_FAILURE_WINDOW, VmOverridesUtil.getMaxFailuresWindowText(dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.maxFailureWindow));
            } else {
                VmOverridesUtil.setClusterDefaultMaxFailuresWindow(clusterData, vmMonitoringFailureValues);
            }
        }
        return vmMonitoringFailureValues;
    }

    private static String getMaxFailuresWindowText(Integer maxFailureWindow) {
        if (maxFailureWindow == -1) {
            return Util.getLocalizedString(NO_FAILURE_WINDOW_KEY);
        }
        return Util.getLocalizedString("ha.config.vmResponse.vmMonitoringSensitivity.hours", Integer.toString(maxFailureWindow / 3600));
    }

    private static String getSecondsText(Integer value) {
        return Util.getLocalizedString("ha.config.vmResponse.vmMonitoringSensitivity.seconds", Integer.toString(value));
    }

    private static void setClusterDefaultMaxFailuresWindow(ClusterOverrideData clusterData, Map<String, String> vmMonitoringFailureValues) {
        String clusterMaxFailureWindowValue = VmOverridesUtil.getMaxFailuresWindowText(clusterData.vmToolsMonitorMaxFailureWindow);
        vmMonitoringFailureValues.put(VM_MAX_FAILURE_WINDOW, VmOverrideBehavior.VM_MONITORING_DEFAULT.getLocalizedString(clusterMaxFailureWindowValue));
    }

    private static void setClusterDefaultVmMaxFailures(ClusterOverrideData clusterData, Map<String, String> vmMonitoringFailureValues) {
        String clusterVmMaxFailuresValue = Integer.toString(clusterData.vmToolsMonitorMaxFailures);
        vmMonitoringFailureValues.put(VM_MAX_FAILURES, VmOverrideBehavior.VM_MONITORING_DEFAULT.getLocalizedString(clusterVmMaxFailuresValue));
    }

    private static void setClusterDefaultVmMinUpTime(ClusterOverrideData clusterData, Map<String, String> vmMonitoringFailureValues) {
        String clusterVmMinUpTimeValue = VmOverridesUtil.getSecondsText(clusterData.vmToolsMonitorMinUpTime);
        vmMonitoringFailureValues.put(VM_MIN_UP_TIME, VmOverrideBehavior.VM_MONITORING_DEFAULT.getLocalizedString(clusterVmMinUpTimeValue));
    }

    private static void setClusterDefaultVmFailureInterval(ClusterOverrideData clusterData, Map<String, String> vmMonitoringFailureValues) {
        String clusterVmFailureIntervalValue = VmOverridesUtil.getSecondsText(clusterData.vmToolsMonitorFailureInt);
        vmMonitoringFailureValues.put(VM_FAILURE_INTERVAL, VmOverrideBehavior.VM_MONITORING_DEFAULT.getLocalizedString(clusterVmFailureIntervalValue));
    }

    private static void setVmMonitoringFailuresValues(ClusterOverrideData clusterData, DasVmConfigInfo dasVmConfigInfo, VmOverrideListItemData vmListItem) {
        if (clusterData.haEnabled.booleanValue()) {
            if (!(dasVmConfigInfo == null || dasVmConfigInfo.dasSettings == null || dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings == null || dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.clusterSettings != null && dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.clusterSettings.booleanValue())) {
                if (dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.failureInterval != null) {
                    vmListItem.haOverrides.vmFailureIntervalValue = dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.failureInterval;
                }
                if (dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.minUpTime != null) {
                    vmListItem.haOverrides.vmMinUptimeValue = dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.minUpTime;
                }
                if (dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.maxFailures != null) {
                    vmListItem.haOverrides.vmMaxFailuresValue = dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.maxFailures;
                }
                if (dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.maxFailureWindow != null) {
                    vmListItem.haOverrides.vmMaxFailureWindowValue = dasVmConfigInfo.dasSettings.vmToolsMonitoringSettings.maxFailureWindow;
                }
            } else {
                vmListItem.haOverrides.vmFailureIntervalValue = clusterData.vmToolsMonitorFailureInt;
                vmListItem.haOverrides.vmMinUptimeValue = clusterData.vmToolsMonitorMinUpTime;
                vmListItem.haOverrides.vmMaxFailuresValue = clusterData.vmToolsMonitorMaxFailures;
                vmListItem.haOverrides.vmMaxFailureWindowValue = clusterData.vmToolsMonitorMaxFailureWindow;
            }
        }
    }

    private static String getVmRestartConditionDelay(ClusterOverrideData clusterData, VmOrchestrationInfo vmOrchestrationInfo) {
        if (!clusterData.haEnabled.booleanValue()) {
            return VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
        }
        if (vmOrchestrationInfo == null || vmOrchestrationInfo.vmReadiness == null) {
            return VmOverrideBehavior.RESTART_PRIORITY_TIMEOUT.getLocalizedString(Integer.toString(clusterData.clusterVmRestartConditionDelay));
        }
        Integer vmRestartConditionDelay = vmOrchestrationInfo.vmReadiness.postReadyDelay;
        if (vmRestartConditionDelay == null || vmRestartConditionDelay == -1) {
            return VmOverrideBehavior.RESTART_PRIORITY_TIMEOUT.getLocalizedString(Integer.toString(clusterData.clusterVmRestartConditionDelay));
        }
        return VmOverrideBehavior.RESTART_PRIORITY_TIMEOUT.getLocalizedString(Integer.toString(vmRestartConditionDelay));
    }

    private static String getDefaultClusterRestartPriorityText(String clusterRestartPrio) {
        String haRestartPriorityText = Util.getLocalizedString(RESTART_PRIORITY_KEY + clusterRestartPrio);
        String label = VmOverrideBehavior.RESTART_PRIORITY_DEFAULT.getLocalizedString(haRestartPriorityText);
        return label;
    }

    private static String getVmHostIsolationResponseText(String vmHostIsolationResponse, String clusterHostIsolationResponse) {
        if (StringUtils.isEmpty((CharSequence)vmHostIsolationResponse)) {
            return null;
        }
        if (vmHostIsolationResponse.equals(VM_OVERRIDES_OPTION_NA_S)) {
            return VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
        }
        if (vmHostIsolationResponse.equals(ISOLATION_RESPONSE_ENSURE_FT)) {
            return VmOverrideBehavior.ENSURE_FT_ISOLATION_RESPONSE.getLocalizedString(new String[0]);
        }
        if (vmHostIsolationResponse.equals(DasVmSettings.IsolationResponse.none.name())) {
            return VmOverrideBehavior.NONE_ISOLATION_RESPONSE.getLocalizedString(new String[0]);
        }
        if (vmHostIsolationResponse.equals(DasVmSettings.IsolationResponse.powerOff.name())) {
            return VmOverrideBehavior.POWER_OFF_ISOLATION_RESPONSE.getLocalizedString(new String[0]);
        }
        if (vmHostIsolationResponse.equals(DasVmSettings.IsolationResponse.shutdown.name())) {
            return VmOverrideBehavior.SHUTDOWN_ISOLATION_RESPONSE.getLocalizedString(new String[0]);
        }
        if (vmHostIsolationResponse.equals(DasVmSettings.IsolationResponse.clusterIsolationResponse.name())) {
            return VmOverridesUtil.getClusterDefaultHaRestartPriorityText(clusterHostIsolationResponse);
        }
        return null;
    }

    private static String getVmMonitoringValue(ClusterOverrideData clusterData, DasVmConfigInfo dasVmConfigInfo) {
        if (!clusterData.haEnabled.booleanValue()) {
            return VM_OVERRIDES_OPTION_NA_S;
        }
        if (dasVmConfigInfo == null) {
            return VmMonitoring.clusterDefault.name();
        }
        Boolean clusterSettings = dasVmConfigInfo.getDasSettings().getVmToolsMonitoringSettings().getClusterSettings();
        if (clusterSettings == null || clusterSettings.booleanValue()) {
            return VmMonitoring.clusterDefault.name();
        }
        String vmMonitoringValue = dasVmConfigInfo.getDasSettings().getVmToolsMonitoringSettings().getVmMonitoring();
        if (vmMonitoringValue == null) {
            return VmMonitoring.clusterDefault.name();
        }
        return vmMonitoringValue;
    }

    private static String getVmMonitoringText(ClusterOverrideData clusterData, String vmMonitoringValue) {
        if (StringUtils.isEmpty((CharSequence)vmMonitoringValue)) {
            return null;
        }
        if (vmMonitoringValue.equals(VM_OVERRIDES_OPTION_NA_S)) {
            return VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
        }
        if (vmMonitoringValue.equals(VmMonitoring.vmMonitoringDisabled.name())) {
            return VmOverrideBehavior.VM_MONITORING_DISABLED.getLocalizedString(new String[0]);
        }
        if (vmMonitoringValue.equals(VmMonitoring.vmMonitoringOnly.name())) {
            return VmOverrideBehavior.VM_MONITORING_ONLY.getLocalizedString(new String[0]);
        }
        if (vmMonitoringValue.equals(VmMonitoring.vmAndAppMonitoring.name())) {
            return VmOverrideBehavior.VM_AND_APP_MONITORING.getLocalizedString(new String[0]);
        }
        if (vmMonitoringValue.equals(VmMonitoring.clusterDefault.name())) {
            return VmOverridesUtil.getClusterDefaultVmMonitoringText(clusterData.vmMonitoring);
        }
        return null;
    }

    private static String getClusterDefaultVmMonitoringText(String clusterVmMonitoring) {
        String clusterVmMonitoringText = Util.getLocalizedString(VM_MONITORING_KEY + clusterVmMonitoring);
        String label = VmOverrideBehavior.VM_MONITORING_DEFAULT.getLocalizedString(clusterVmMonitoringText);
        return label;
    }

    private static String getVmMonitoringWarningText(String clusterVmMonitoring, String vmMonitoringValue) {
        if (vmMonitoringValue != null && VmOverridesUtil.isVmMonitoringDegraded(clusterVmMonitoring, vmMonitoringValue)) {
            String clusterVmMonitoringText = VmOverridesUtil.wrapInQuotes(Util.getLocalizedString(VM_MONITORING_KEY + clusterVmMonitoring));
            String vmAndAppMonitoringText = VmOverridesUtil.wrapInQuotes(Util.getLocalizedString("ha.config.vmmonitoring.vmAndAppMonitoring"));
            if (clusterVmMonitoring.equals(DasConfigInfo.VmMonitoringState.vmMonitoringDisabled.name())) {
                String vmMonitoringText = VmOverridesUtil.wrapInQuotes(Util.getLocalizedString("ha.config.vmmonitoring.vmMonitoringOnly"));
                String degradedModesText = Util.getLocalizedString("vm.overrides.HA.monitoring.warning.mode.format", vmMonitoringText, vmAndAppMonitoringText);
                return Util.getLocalizedString("vm.overrides.HA.monitoring.warning.text", clusterVmMonitoringText, degradedModesText);
            }
            if (clusterVmMonitoring.equals(DasConfigInfo.VmMonitoringState.vmMonitoringOnly.name())) {
                return Util.getLocalizedString("vm.overrides.HA.monitoring.warning.text", clusterVmMonitoringText, vmAndAppMonitoringText);
            }
        }
        return null;
    }

    private static String wrapInQuotes(String text) {
        return Util.getLocalizedString("quotedText", text);
    }

    private static boolean isVmMonitoringDegraded(String clusterVmMonitoring, String vmMonitoring) {
        if (clusterVmMonitoring == null || DasConfigInfo.VmMonitoringState.vmAndAppMonitoring.name().equals(clusterVmMonitoring)) {
            return false;
        }
        if (DasConfigInfo.VmMonitoringState.vmMonitoringDisabled.name().equals(clusterVmMonitoring) && DasConfigInfo.VmMonitoringState.vmMonitoringOnly.name().equals(vmMonitoring)) {
            return true;
        }
        return DasConfigInfo.VmMonitoringState.vmAndAppMonitoring.name().equals(vmMonitoring);
    }

    private static String getVmMonitoringSensitivityValue(ClusterOverrideData clusterData, DasVmConfigInfo dasVmConfigInfo, String vmMonitoring) {
        if (!clusterData.haEnabled.booleanValue()) {
            return VM_OVERRIDES_OPTION_NA_S;
        }
        if (dasVmConfigInfo == null || vmMonitoring.equals(VmMonitoring.clusterDefault.name())) {
            return VmMonitoring.clusterDefault.name();
        }
        VmToolsMonitoringSettings vmMonitoringSettings = dasVmConfigInfo.getDasSettings().getVmToolsMonitoringSettings();
        if (vmMonitoringSettings.getFailureInterval() == null && vmMonitoringSettings.getMaxFailureWindow() == null && vmMonitoringSettings.getMaxFailures() == null && vmMonitoringSettings.getMinUpTime() == null) {
            return VmMonitoring.clusterDefault.name();
        }
        return VmOverridesUtil.getVmMonitoringSensitivityLevel(vmMonitoringSettings.getFailureInterval(), vmMonitoringSettings.getMaxFailureWindow(), vmMonitoringSettings.getMaxFailures(), vmMonitoringSettings.getMinUpTime());
    }

    private static String getClusterDefaultVmMonitoringSensitivityText(ClusterOverrideData clusterData) {
        String clusterVmMonitoringSensitivityLevel = VmOverridesUtil.getVmMonitoringSensitivityLevel(clusterData.vmToolsMonitorFailureInt, clusterData.vmToolsMonitorMaxFailureWindow, clusterData.vmToolsMonitorMaxFailures, clusterData.vmToolsMonitorMinUpTime);
        String clusterVmMonitoringSensitivityText = Util.getLocalizedString(VmOverridesUtil.getVmMonitoringSensitivityLevelText(clusterVmMonitoringSensitivityLevel));
        return VmOverrideBehavior.VM_MONITORING_DEFAULT.getLocalizedString(clusterVmMonitoringSensitivityText);
    }

    private static String getVmMonitoringSensitivityText(ClusterOverrideData clusterData, String vmMonitoringValue) {
        String vmMonitoringSensitivityLevelText = VmOverridesUtil.getVmMonitoringSensitivityLevelText(vmMonitoringValue);
        if (vmMonitoringSensitivityLevelText != null) {
            return vmMonitoringSensitivityLevelText;
        }
        if (vmMonitoringValue.equals(VM_OVERRIDES_OPTION_NA_S)) {
            return VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
        }
        if (vmMonitoringValue.equals(VmMonitoring.clusterDefault.name())) {
            return VmOverridesUtil.getClusterDefaultVmMonitoringSensitivityText(clusterData);
        }
        return null;
    }

    private static String getVmMonitoringSensitivityLevelText(String vmMonitoringValue) {
        switch (vmMonitoringValue) {
            case "0": {
                return VmOverrideBehavior.VM_MONITORING_SENSITIVITY_LOW.getLocalizedString(new String[0]);
            }
            case "1": {
                return VmOverrideBehavior.VM_MONITORING_SENSITIVITY_MEDIUM.getLocalizedString(new String[0]);
            }
            case "2": {
                return VmOverrideBehavior.VM_MONITORING_SENSITIVITY_HIGH.getLocalizedString(new String[0]);
            }
            case "3": {
                return VmOverrideBehavior.VM_MONITORING_SENSITIVITY_CUSTOM.getLocalizedString(new String[0]);
            }
        }
        return null;
    }

    private static String getVmMonitoringSensitivityLevel(int failInterval, int maxFailuresWindow, int maxFailures, int minUptime) {
        if (30 == failInterval && 3600 == maxFailuresWindow && 3 == maxFailures && 120 == minUptime) {
            return "2";
        }
        if (60 == failInterval && 86400 == maxFailuresWindow && 3 == maxFailures && 240 == minUptime) {
            return "1";
        }
        if (120 == failInterval && 604800 == maxFailuresWindow && 3 == maxFailures && 480 == minUptime) {
            return "0";
        }
        return "3";
    }

    private static String getClusterDefaultHaRestartPriorityText(String clusterHostIsolationResponse) {
        String haIsolationResponseText = Util.getLocalizedString(ISOLATION_RESPONSE_KEY + clusterHostIsolationResponse);
        String label = VmOverrideBehavior.ISOLATION_RESPONSE_DEFAULT.getLocalizedString(haIsolationResponseText);
        return label;
    }

    private static void populateVmcpSettings(VmOverrideListItemData vmListItem, ClusterOverrideData clusterData, DasVmConfigInfo dasVmConfigInfo) {
        VmComponentProtectionSettings vmcpSettings = null;
        if (dasVmConfigInfo != null) {
            vmcpSettings = dasVmConfigInfo.dasSettings.vmComponentProtectionSettings;
        }
        if (!clusterData.haEnabled.booleanValue()) {
            vmListItem.haOverrides.pdlProtectionLevelText = VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
            vmListItem.haOverrides.apdProtectionLevelText = VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
            vmListItem.haOverrides.vmRemediationOnApdRecoverText = VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
            vmListItem.haOverrides.intervalBeforeVmcpReactionText = VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]);
            vmListItem.haOverrides.pdlProtectionLevel = VM_OVERRIDES_OPTION_NA_S;
            vmListItem.haOverrides.apdProtectionLevel = VM_OVERRIDES_OPTION_NA_S;
            vmListItem.haOverrides.vmRemediationOnApdRecover = VM_OVERRIDES_OPTION_NA_S;
            vmListItem.haOverrides.usesDefaultIntervalBeforeVmcpReaction = true;
        } else {
            int delayForApd;
            String pdlProtectionLevel = vmcpSettings != null && vmcpSettings.vmStorageProtectionForPDL != null ? vmcpSettings.vmStorageProtectionForPDL : VmComponentProtectionSettings.StorageVmReaction.clusterDefault.name();
            vmListItem.haOverrides.pdlProtectionLevel = pdlProtectionLevel;
            vmListItem.haOverrides.pdlProtectionLevelText = VmOverridesUtil.getPdlProtectionLevelText(pdlProtectionLevel, clusterData.vmStorageProtectionForPDL);
            String apdProtectionLevel = vmcpSettings != null && vmcpSettings.vmStorageProtectionForAPD != null ? vmcpSettings.vmStorageProtectionForAPD : VmComponentProtectionSettings.StorageVmReaction.clusterDefault.name();
            vmListItem.haOverrides.apdProtectionLevel = apdProtectionLevel;
            vmListItem.haOverrides.apdProtectionLevelText = VmOverridesUtil.getApdProtectionLevelText(apdProtectionLevel, clusterData.vmStorageProtectionForAPD);
            boolean usesDefaultIntervalBeforeVmcpReaction = true;
            if (vmcpSettings != null && vmcpSettings.vmTerminateDelayForAPDSec != null) {
                delayForApd = vmcpSettings.vmTerminateDelayForAPDSec;
                if (delayForApd == -1) {
                    delayForApd = clusterData.vmTerminateDelayForAPDSec;
                } else {
                    usesDefaultIntervalBeforeVmcpReaction = false;
                }
            } else {
                delayForApd = clusterData.vmTerminateDelayForAPDSec;
            }
            int intervalBeforeVmcpReaction = VmOverridesUtil.secondsToMinutes(delayForApd);
            vmListItem.haOverrides.intervalBeforeVmcpReaction = intervalBeforeVmcpReaction;
            vmListItem.haOverrides.usesDefaultIntervalBeforeVmcpReaction = usesDefaultIntervalBeforeVmcpReaction;
            vmListItem.haOverrides.intervalBeforeVmcpReactionText = VmOverridesUtil.getIntervalBeforeVmcpReactionText(intervalBeforeVmcpReaction, usesDefaultIntervalBeforeVmcpReaction);
            String vmRemediationOnApdRecover = vmcpSettings != null && vmcpSettings.vmReactionOnAPDCleared != null ? VmOverridesUtil.getVmRemediationOnApdRecover(vmcpSettings.vmReactionOnAPDCleared) : VmComponentProtectionSettings.VmReactionOnAPDCleared.useClusterDefault.name();
            vmListItem.haOverrides.vmRemediationOnApdRecover = vmRemediationOnApdRecover;
            vmListItem.haOverrides.vmRemediationOnApdRecoverText = VmOverridesUtil.getVmRemediationOnApdRecoverText(vmRemediationOnApdRecover, VmOverridesUtil.getVmRemediationOnApdRecover(clusterData.vmReactionOnAPDCleared));
        }
    }

    private static String getPdlProtectionLevelText(String pdlProtectionLevel, String clusterPdlProtectionLevel) {
        String label;
        if (pdlProtectionLevel.equals(VmComponentProtectionSettings.StorageVmReaction.clusterDefault.name()) && StringUtils.isNotEmpty((CharSequence)clusterPdlProtectionLevel)) {
            String protectionLevelText = Util.getLocalizedString(PDL_PROTECTION_LEVEL_KEY + clusterPdlProtectionLevel);
            label = VmOverrideBehavior.PDL_PROTECTION_LEVEL_DEFAULT.getLocalizedString(protectionLevelText);
        } else {
            label = Util.getLocalizedString(PDL_PROTECTION_LEVEL_KEY + pdlProtectionLevel);
        }
        return label;
    }

    private static String getApdProtectionLevelText(String apdProtectionLevel, String clusterApdProtectionLevel) {
        String label;
        if (apdProtectionLevel.equals(VmComponentProtectionSettings.StorageVmReaction.clusterDefault.name()) && StringUtils.isNotEmpty((CharSequence)clusterApdProtectionLevel)) {
            String protectionLevelText = Util.getLocalizedString(APD_PROTECTION_LEVEL_KEY + clusterApdProtectionLevel);
            label = VmOverrideBehavior.APD_PROTECTION_LEVEL_DEFAULT.getLocalizedString(protectionLevelText);
        } else {
            label = Util.getLocalizedString(APD_PROTECTION_LEVEL_KEY + apdProtectionLevel);
        }
        return label;
    }

    private static String getIntervalBeforeVmcpReactionText(Integer intervalBeforeVmcpReaction, Boolean isDefault) {
        String label = Util.getLocalizedString(MINUTES_FORMATTER_KEY, intervalBeforeVmcpReaction.toString());
        if (isDefault.booleanValue()) {
            label = VmOverrideBehavior.DELAY_FOR_APD_DEFAULT.getLocalizedString(label);
        }
        return label;
    }

    private static String getHaIsolationResponseValue(Boolean isHaEnabled, Boolean isPrimaryVm, DasVmConfigInfo dasVmConfigInfoItem) {
        if (!isHaEnabled.booleanValue()) {
            return VM_OVERRIDES_OPTION_NA_S;
        }
        if (isPrimaryVm.booleanValue()) {
            return ISOLATION_RESPONSE_ENSURE_FT;
        }
        if (dasVmConfigInfoItem == null) {
            return DasVmSettings.IsolationResponse.clusterIsolationResponse.name();
        }
        return dasVmConfigInfoItem.dasSettings.isolationResponse;
    }

    private static String getVmRemediationOnApdRecover(String vmReactionOnAPDCleared) {
        String vmRemediationLevel = "";
        if (VmComponentProtectionSettings.VmReactionOnAPDCleared.reset.name().equals(vmReactionOnAPDCleared)) {
            vmRemediationLevel = RESET_VM_KEY;
        } else if (VmComponentProtectionSettings.VmReactionOnAPDCleared.none.name().equals(vmReactionOnAPDCleared)) {
            vmRemediationLevel = DO_NOT_RESET_VM_KEY;
        } else if (VmComponentProtectionSettings.VmReactionOnAPDCleared.useClusterDefault.name().equals(vmReactionOnAPDCleared)) {
            vmRemediationLevel = VmComponentProtectionSettings.VmReactionOnAPDCleared.useClusterDefault.name();
        }
        return vmRemediationLevel;
    }

    private static String getVmRemediationOnApdRecoverText(String vmRemediationOnApdRecover, String clusterVmRemediationOnApdRecover) {
        String label;
        if (vmRemediationOnApdRecover.equals(VmComponentProtectionSettings.VmReactionOnAPDCleared.useClusterDefault.name()) && StringUtils.isNotEmpty((CharSequence)clusterVmRemediationOnApdRecover)) {
            String clusterVmRemediationKey = clusterVmRemediationOnApdRecover.equals(RESET_VM_KEY) ? VmOverrideBehavior.RESET_VM.getLocalizedString(new String[0]) : VmOverrideBehavior.DO_NOT_RESET_VM.getLocalizedString(new String[0]);
            String clusterVmRemediationText = Util.getLocalizedString(clusterVmRemediationKey);
            label = VmOverrideBehavior.APD_RECOVERY_DEFAULT.getLocalizedString(clusterVmRemediationText);
        } else {
            label = vmRemediationOnApdRecover.equals(RESET_VM_KEY) ? VmOverrideBehavior.RESET_VM.getLocalizedString(new String[0]) : VmOverrideBehavior.DO_NOT_RESET_VM.getLocalizedString(new String[0]);
        }
        return label;
    }

    private static String getHaRestartPriorityValue(Boolean isHaEnabled, DasVmConfigInfo dasVmConfigInfoItem) {
        if (!isHaEnabled.booleanValue()) {
            return VM_OVERRIDES_OPTION_NA_S;
        }
        if (dasVmConfigInfoItem == null) {
            return DasVmSettings.RestartPriority.clusterRestartPriority.name();
        }
        return dasVmConfigInfoItem.dasSettings.restartPriority;
    }

    static String getDrsAutomationLevelValue(Boolean isDrsEnabled, Boolean isPrimaryVm, Boolean isEvcEnabled, Boolean isPerVmAutomationEnabled, DrsVmConfigInfo drsVmConfigInfo) {
        String vmOverrideBehavior;
        if (!isDrsEnabled.booleanValue()) {
            vmOverrideBehavior = VM_OVERRIDES_OPTION_NA_S;
        } else if (isPrimaryVm.booleanValue() && !isEvcEnabled.booleanValue()) {
            vmOverrideBehavior = VM_OVERRIDES_OPTION_DISABLED;
        } else if (!isPrimaryVm.booleanValue() && !isPerVmAutomationEnabled.booleanValue() || drsVmConfigInfo == null) {
            vmOverrideBehavior = CLUSTER_DEFAULT;
        } else {
            if (drsVmConfigInfo.getEnabled().booleanValue()) {
                return drsVmConfigInfo.getBehavior().toString();
            }
            vmOverrideBehavior = VM_OVERRIDES_OPTION_DISABLED;
        }
        return vmOverrideBehavior;
    }

    private static String getVmDrsAutLevelText(String vmDrsAutomationLevel, DrsConfigInfo.DrsBehavior clusterDrsAutomationLevel) {
        VmOverrideBehavior clusterBehavior = VmOverrideBehavior.getConfiguredBehavior(clusterDrsAutomationLevel);
        String localizedAutomationLevel = vmDrsAutomationLevel.equals(DrsConfigInfo.DrsBehavior.fullyAutomated.toString()) ? VmOverrideBehavior.FULLY_AUTOMATED.getLocalizedString(new String[0]) : (vmDrsAutomationLevel.equals(DrsConfigInfo.DrsBehavior.partiallyAutomated.toString()) ? VmOverrideBehavior.PARTIALLY_AUTOMATED.getLocalizedString(new String[0]) : (vmDrsAutomationLevel.equals(DrsConfigInfo.DrsBehavior.manual.toString()) ? VmOverrideBehavior.MANUAL.getLocalizedString(new String[0]) : (VM_OVERRIDES_OPTION_NA_S.equals(vmDrsAutomationLevel) ? VmOverrideBehavior.VM_OVERRIDES_OPTION_NA_S.getLocalizedString(new String[0]) : (CLUSTER_DEFAULT.equals(vmDrsAutomationLevel) ? VmOverrideBehavior.DRS_VM_SETTINGS_BEHAVIOR_CLUSTER_DEFAULT.getLocalizedString(clusterBehavior.getLocalizedString(new String[0])) : (VM_OVERRIDES_OPTION_DISABLED.equals(vmDrsAutomationLevel) ? VmOverrideBehavior.DRS_VM_SETTINGS_BEHAVIOR_DISABLED.getLocalizedString(new String[0]) : null)))));
        return localizedAutomationLevel;
    }

    private static int secondsToMinutes(int seconds) {
        return seconds / 60;
    }

    private static boolean isDrsAutomationLevelEditable(boolean isDrsEnabled, boolean isPerVmAutomationEnabled, boolean isPrimaryVm, boolean isEvcEnabled) {
        return isDrsEnabled && (!isPrimaryVm && isPerVmAutomationEnabled || isPrimaryVm && isEvcEnabled);
    }

    static enum VmOverrideBehavior {
        VM_OVERRIDES_OPTION_NA_S("vmOverrides.na"),
        DRS_VM_SETTINGS_BEHAVIOR_DISABLED("vmOverrides.drsAutomationLevel.Disabled"),
        DRS_VM_SETTINGS_BEHAVIOR_CLUSTER_DEFAULT("vmOverrides.drsAutomationLevel.Default"),
        FULLY_AUTOMATED("drs.config.automationLevel.fullauto"),
        PARTIALLY_AUTOMATED("drs.config.automationLevel.partialauto"),
        MANUAL("drs.config.automationLevel.manual"),
        RESTART_CONDITION_NONE("ha.config.vm.restart.condition.readiness.none"),
        RESTART_CONDITION_POWER_ON("ha.config.vm.restart.condition.readiness.poweredOn"),
        RESTART_CONDITION_GUEST_HB_DETECTED("ha.config.vm.restart.condition.readiness.guestHbStatusGreen"),
        RESTART_CONDITION_APP_HB_DETECTED("ha.config.vm.restart.condition.readiness.appHbStatusGreen"),
        RESTART_CONDITION_DEFAULT("vmOverrides.haRestartCondition.Default"),
        APD_RECOVERY_DEFAULT("ha.config.vmResponse.vmRemediationIfApdRecovers.default"),
        DISABLED_RESTART_PRIORITY("ha.config.vm.vmRestartPriority.disabled"),
        LOWEST_RESTART_PRIORITY("ha.config.vm.vmRestartPriority.lowest"),
        LOW_RESTART_PRIORITY("ha.config.vm.vmRestartPriority.low"),
        MEDIUM_RESTART_PRIORITY("ha.config.vm.vmRestartPriority.medium"),
        HIGH_RESTART_PRIORITY("ha.config.vm.vmRestartPriority.high"),
        HIGHEST_RESTART_PRIORITY("ha.config.vm.vmRestartPriority.highest"),
        RESTART_PRIORITY_DEFAULT("vmOverrides.haVmRestartPriority.Default"),
        RESTART_PRIORITY_TIMEOUT("vmOverrides.postConditionDelay.format"),
        NONE_ISOLATION_RESPONSE("ha.config.vm.hostIsolationResponse.none"),
        POWER_OFF_ISOLATION_RESPONSE("ha.config.vm.hostIsolationResponse.powerOff"),
        SHUTDOWN_ISOLATION_RESPONSE("ha.config.vm.hostIsolationResponse.shutdown"),
        ISOLATION_RESPONSE_DEFAULT("vmOverrides.haHostIsolationResponse.Default"),
        ENSURE_FT_ISOLATION_RESPONSE("vmOverrides.haHostIsolationResponse.EnsureFT"),
        PDL_PROTECTION_LEVEL_DEFAULT("ha.config.vmResponse.storageProtectionForPdl.default"),
        APD_PROTECTION_LEVEL_DEFAULT("ha.config.vmResponse.storageProtectionForApd.default"),
        DELAY_FOR_APD_DEFAULT("ha.config.vmResponse.delayForApd.default"),
        RESET_VM("ha.config.vmResponse.vmRemediationIfApdRecovers.resetVm"),
        DO_NOT_RESET_VM("ha.config.vmResponse.vmRemediationIfApdRecovers.doNotResetVm"),
        VM_MONITORING_DEFAULT("vmOverrides.haVmMonitoring.Default"),
        VM_MONITORING_DISABLED("ha.config.vmmonitoring.vmMonitoringDisabled"),
        VM_MONITORING_ONLY("ha.config.vmmonitoring.vmMonitoringOnly"),
        VM_AND_APP_MONITORING("ha.config.vmmonitoring.vmAndAppMonitoring"),
        VM_MONITORING_SENSITIVITY_LOW("ha.config.vm.monitoring.sensitivity.low"),
        VM_MONITORING_SENSITIVITY_MEDIUM("ha.config.vm.monitoring.sensitivity.medium"),
        VM_MONITORING_SENSITIVITY_HIGH("ha.config.vm.monitoring.sensitivity.high"),
        VM_MONITORING_SENSITIVITY_CUSTOM("ha.config.vm.monitoring.sensitivity.custom");

        private String key;

        private VmOverrideBehavior(String key) {
            this.key = key;
        }

        public String getLocalizedString(String ... params) {
            return Util.getLocalizedString(this.key, params);
        }

        public static VmOverrideBehavior getConfiguredBehavior(DrsConfigInfo.DrsBehavior drsBehavior) {
            VmOverrideBehavior behavior = null;
            if (DrsConfigInfo.DrsBehavior.manual == drsBehavior) {
                behavior = MANUAL;
            } else if (DrsConfigInfo.DrsBehavior.partiallyAutomated == drsBehavior) {
                behavior = PARTIALLY_AUTOMATED;
            } else if (DrsConfigInfo.DrsBehavior.fullyAutomated == drsBehavior) {
                behavior = FULLY_AUTOMATED;
            }
            return behavior;
        }
    }

    static enum VmMonitoring {
        clusterDefault,
        vmMonitoringDisabled,
        vmMonitoringOnly,
        vmAndAppMonitoring;

    }
}

