/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmInfoRetriever {
    private static final String ALARM_INFO_PROPERTY = "info";
    private static final Log _logger = LogFactory.getLog(AlarmInfoRetriever.class);
    private final DataService _dataService;

    public AlarmInfoRetriever(DataService dataService) {
        this._dataService = dataService;
    }

    public Map<ManagedObjectReference, AlarmInfo> retrieve(AlarmState[] alarmStates) {
        HashSet<ManagedObjectReference> alarmRefs = new HashSet<ManagedObjectReference>();
        for (AlarmState alarmState : alarmStates) {
            alarmRefs.add(alarmState.alarm);
        }
        HashMap<ManagedObjectReference, AlarmInfo> alarmDefinitions = new HashMap<ManagedObjectReference, AlarmInfo>();
        try {
            PropertyValue[] returnedProperties;
            for (PropertyValue propertyValue : returnedProperties = QueryUtil.getProperty((DataService)this._dataService, (Object[])alarmRefs.toArray(new ManagedObjectReference[0]), (String)ALARM_INFO_PROPERTY)) {
                alarmDefinitions.put((ManagedObjectReference)propertyValue.resourceObject, (AlarmInfo)propertyValue.value);
            }
            return alarmDefinitions;
        }
        catch (Exception e) {
            _logger.error((Object)"Error retrieving alarm definitions", (Throwable)e);
            return alarmDefinitions;
        }
    }
}

