/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.SsoServiceException;
import com.vmware.vcenter.apigw.api.sso.SsoServiceLocator;
import com.vmware.vcenter.apigw.api.sso.SsoServicesFederation;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;

public class AdminServiceBase {
    private static final String SSO_ADMIN_SERVICE_KEY = "ssoAdminService";
    private static final String SSO_SOLUTION_USER_ADMIN_SERVICE_KEY = "ssoSolutionUserAdminService";
    private static final String SSO_ADMIN_SERVICE_SYNC_OBJECT_KEY = "ssoAdminServiceSyncObject";
    private SsoServiceLocator _ssoServiceLocator;
    private SsoServiceManager _ssoServiceManager;
    private Boolean _useSolutionUser = false;
    private volatile SsoServicesFederation _ssoSvcFed;
    private SsoAdminService _presetAdminService = null;
    private BackendExceptionTransformer _exceptionTransformer;

    public AdminServiceBase(SsoServiceLocator ssoServiceLocator, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer) {
        Validate.notNull((Object)ssoServiceLocator, (String)"ssoServiceLocator is null");
        Validate.notNull((Object)ssoServiceManager, (String)"ssoServiceManager is null");
        Validate.notNull((Object)transformer, (String)"transformer is null");
        this._ssoServiceLocator = ssoServiceLocator;
        this._ssoServiceManager = ssoServiceManager;
        this._exceptionTransformer = transformer;
    }

    public AdminServiceBase(SsoAdminService presetAdminService) {
        this._presetAdminService = presetAdminService;
    }

    public AdminServiceBase(SsoServiceLocator ssoServiceLocator, SsoServiceManager ssoServiceManager, Boolean useSolutionUser, BackendExceptionTransformer transformer) {
        this(ssoServiceLocator, ssoServiceManager, transformer);
        this._useSolutionUser = useSolutionUser;
    }

    protected Exception transformBackendException(Exception exception) {
        return this._exceptionTransformer.transformException(exception);
    }

    protected SsoServicesFederation getSsoServicesFederation() throws SsoServiceException {
        if (this._ssoSvcFed == null) {
            try {
                SsoDomain localDomain = SsoDomainHelper.getLocal();
                this._ssoSvcFed = this._ssoServiceLocator.getSsoServicesFederation(localDomain);
            }
            catch (Exception ex) {
                throw new SsoServiceException("Failed to retrieve an SsoServicesFederation", (Throwable)ex);
            }
        }
        return this._ssoSvcFed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SsoAdminService getAdminService(HttpSession session) throws SsoServiceException {
        Object syncObj;
        if (this._presetAdminService != null) {
            return this._presetAdminService;
        }
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        Object object = syncObj = SessionUtil.getSyncObject((String)SSO_ADMIN_SERVICE_SYNC_OBJECT_KEY, (HttpSession)session);
        synchronized (object) {
            String sessionKey = this.getSessionKey();
            SsoAdminService srv = (SsoAdminService)SessionUtil.getData((String)sessionKey);
            if (srv == null) {
                SsoDomain localDomain = SsoDomainHelper.getLocal();
                srv = this._useSolutionUser != false ? this._ssoServiceManager.getSolutionAdminService(null, localDomain) : this._ssoServiceManager.getAdminService(null, localDomain);
            }
            return srv;
        }
    }

    protected String getSessionKey() {
        return this._useSolutionUser != false ? SSO_SOLUTION_USER_ADMIN_SERVICE_KEY : SSO_ADMIN_SERVICE_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void releaseResources(HttpSession session) throws SsoServiceException {
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            for (String key : new String[]{SSO_ADMIN_SERVICE_KEY, SSO_SOLUTION_USER_ADMIN_SERVICE_KEY}) {
                SsoAdminService srv = (SsoAdminService)SessionUtil.getData((String)key);
                if (srv == null) continue;
                srv.logout();
                SessionUtil.removeData((String)key, (HttpSession)session);
            }
        }
    }
}

