/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vcenter.apigw.api.sso.SsoServiceException;
import com.vmware.vcenter.apigw.api.sso.SsoServiceLocator;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.sso.admin.IdentityProviderService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import com.vmware.vsphere.client.sso.admin.model.ExportIdentityProviderSpec;
import com.vmware.vsphere.client.sso.admin.model.ImportIdentityProviderSpec;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class IdentityProviderServiceImpl
extends AdminServiceBase
implements IdentityProviderService {
    public IdentityProviderServiceImpl(SsoServiceLocator ssoServiceLocator, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer) {
        super(ssoServiceLocator, ssoServiceManager, transformer);
    }

    @Override
    public void importIdentityProviderConfiguration(ImportIdentityProviderSpec spec) throws SsoServiceException {
        this.validateIdentityProviderSpec(spec);
        ConfigurationManagementService configService = this.getConfigService();
        configService.importSAMLMetadata(spec.xmlConfiguration);
    }

    @Override
    public ExportIdentityProviderSpec exportIdentityProviderConfiguration(ExportIdentityProviderSpec spec) throws SsoServiceException {
        this.validateExportIdentityProviderSpec(spec);
        ExportIdentityProviderSpec result = new ExportIdentityProviderSpec();
        result.idpName = spec.idpName;
        result.metadataUrl = this.getMetadataUrl(spec.idpName);
        return result;
    }

    private String getMetadataUrl(String idpName) throws SsoServiceException {
        return this.getSsoServicesFederation().getWebSsoEndpointInfo().getUri().toString();
    }

    private void validateIdentityProviderSpec(ImportIdentityProviderSpec spec) throws IllegalArgumentException {
        if (spec == null) {
            throw new IllegalArgumentException("The spec should not be null");
        }
        if (StringUtils.isEmpty((CharSequence)spec.xmlConfiguration)) {
            throw new IllegalArgumentException("The provided xml should not be empty");
        }
    }

    private void validateExportIdentityProviderSpec(ExportIdentityProviderSpec spec) throws IllegalArgumentException {
        if (spec == null) {
            throw new IllegalArgumentException("The spec should not be null");
        }
    }

    private final ConfigurationManagementService getConfigService() throws SsoServiceException {
        HttpSession session = SessionUtil.getHttpSession();
        ConfigurationManagementService configService = this.getAdminService(session).getConfigurationManagementService();
        return configService;
    }
}

