/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vcenter.apigw.api.sso.SsoServiceLocator;
import com.vmware.vim.binding.sso.admin.PasswordPolicy;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.sso.admin.PasswordPolicyService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PasswordPolicyServiceImpl
extends AdminServiceBase
implements PasswordPolicyService {
    private static final Log _logger = LogFactory.getLog(PasswordPolicyServiceImpl.class);

    public PasswordPolicyServiceImpl(SsoServiceLocator ssoServiceLocator, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer) {
        super(ssoServiceLocator, ssoServiceManager, transformer);
    }

    @Override
    public PasswordPolicy getPasswordPolicy() throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            return this.getAdminService(session).getPasswordPolicyService().getLocalPasswordPolicy();
        }
        catch (Exception e) {
            _logger.error((Object)"PasswordPolicyServiceImpl.getPasswordPolicy", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void updatePasswordPolicy(PasswordPolicy policy) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            if (policy.passwordLifetimeDays == 0) {
                policy.passwordLifetimeDays = null;
            }
            this.getAdminService(session).getPasswordPolicyService().updateLocalPasswordPolicy(policy);
        }
        catch (Exception e) {
            _logger.error((Object)"PasswordPolicyServiceImpl.updatePasswordPolicy", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }
}

