/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class CheckoutVmPropertyProvider {
    private static final String PROPERTY_LIBRARY_ITEM = "VirtualMachine/config/contentLibItemInfo/contentLibraryItemUuid";
    private static final String PROPERTY_LBRARY_ITEM_VERSION = "VirtualMachine/config/contentLibItemInfo/contentLibraryItemVersion";
    private static final String PROPERTY_TEMPLATE = "VirtualMachine/config/template";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_LBRARY = "library";
    private static final String PROPERTY_LBRARY_NAME = "libraryName";
    private static final String PROPERTY_ID = "id";
    private final QueryService _queryService;

    public CheckoutVmPropertyProvider(QueryServiceFactory qsFactory) {
        this._queryService = qsFactory.getQueryService();
    }

    @DerivedProperty(value="VirtualMachine/isCheckedOutVM")
    public static boolean isCheckedOutVM(@SourceProperty(value="VirtualMachine/config/contentLibItemInfo/contentLibraryItemUuid") String contentLibraryItemUuid) {
        return contentLibraryItemUuid != null;
    }

    @DerivedProperty(value="VirtualMachine/sourceContentLibraryItemUri")
    public static URI getSourceContentLibraryItemUri(@SourceProperty(value="VirtualMachine/config/contentLibItemInfo/contentLibraryItemUuid") String contentLibraryItemUuid, @SourceProperty(value="VirtualMachine/@instanceUuid") String serverGuid) {
        return VapiUriSchemeUtil.createUri((String)"com.vmware.content.library.Item", (String)contentLibraryItemUuid, (String)serverGuid);
    }

    @DerivedProperty(value="VirtualMachine/canCheckin")
    public static boolean getCanCheckin(@SourceProperty(value="VirtualMachine/config/contentLibItemInfo/contentLibraryItemUuid") String itemId, @SourceProperty(value="VirtualMachine/runtime/powerState") VirtualMachine.PowerState powerState) {
        return itemId != null && VirtualMachine.PowerState.poweredOff.equals((Object)powerState);
    }

    @PropertyProvider(value="VirtualMachine/checkedOutFromVmTemplate")
    public Map<String, ManagedObjectReference> getCheckedOutFromVmTemplate(ManagedObjectReference vmRef) {
        ResultSet rs = this._queryService.select(new String[]{PROPERTY_LIBRARY_ITEM, PROPERTY_LBRARY_ITEM_VERSION}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vmRef), new PropertyPredicate(PROPERTY_TEMPLATE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)false)}).fetch();
        if (rs.getItems().isEmpty()) {
            return null;
        }
        ResourceItem libraryItem = (ResourceItem)rs.getItems().get(0);
        String libraryItemUri = (String)libraryItem.get(PROPERTY_LIBRARY_ITEM);
        String libraryItemLatestVersion = (String)libraryItem.get(PROPERTY_LBRARY_ITEM_VERSION);
        if (libraryItemUri == null || libraryItemLatestVersion == null) {
            return null;
        }
        ResultSet rsTemplate = this._queryService.select(new String[]{"@modelKey", PROPERTY_NAME}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(PROPERTY_LIBRARY_ITEM, PropertyPredicate.ComparisonOperator.EQUAL, (Object)libraryItemUri), new PropertyPredicate(PROPERTY_LBRARY_ITEM_VERSION, PropertyPredicate.ComparisonOperator.EQUAL, (Object)libraryItemLatestVersion), new PropertyPredicate(PROPERTY_TEMPLATE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true)}).fetch();
        if (rsTemplate.getItems().isEmpty()) {
            return null;
        }
        ResourceItem latestTemplateItem = (ResourceItem)rsTemplate.getItems().get(0);
        String templateName = (String)latestTemplateItem.get(PROPERTY_NAME);
        ManagedObjectReference templateRef = (ManagedObjectReference)latestTemplateItem.get("@modelKey");
        HashMap<String, ManagedObjectReference> resp = new HashMap<String, ManagedObjectReference>();
        resp.put(templateName, templateRef);
        return resp;
    }

    @PropertyProvider(value="VirtualMachine/managedByLibrary")
    public Map<String, Object> getManagedByLibrary(ManagedObjectReference vmRef) {
        ResultSet vmProperiesRs = this._queryService.select(new String[]{PROPERTY_LIBRARY_ITEM}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vmRef), new PropertyPredicate(PROPERTY_TEMPLATE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true)}).fetch();
        if (vmProperiesRs.getItems().isEmpty()) {
            return null;
        }
        ResourceItem vmPropsItem = (ResourceItem)vmProperiesRs.getItems().get(0);
        String libraryItemId = (String)vmPropsItem.get(PROPERTY_LIBRARY_ITEM);
        if (libraryItemId == null) {
            return null;
        }
        ResultSet libraryItemPropertiesRs = this._queryService.select(new String[]{PROPERTY_LBRARY, PROPERTY_LBRARY_NAME}).from(new String[]{"com.vmware.content.library.Item"}).where(PROPERTY_ID, PropertyPredicate.ComparisonOperator.EQUAL, (Object)libraryItemId).fetch();
        if (libraryItemPropertiesRs.getItems().isEmpty()) {
            return null;
        }
        ResourceItem libraryItemPropertiesItem = (ResourceItem)libraryItemPropertiesRs.getItems().get(0);
        String libraryName = (String)libraryItemPropertiesItem.get(PROPERTY_LBRARY_NAME);
        URI contentLibraryUri = (URI)libraryItemPropertiesItem.get(PROPERTY_LBRARY);
        URI libraryItemUri = (URI)libraryItemPropertiesItem.getKey();
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("libraryItemUri", libraryItemUri);
        resp.put("libraryUri", contentLibraryUri);
        resp.put(PROPERTY_LBRARY_NAME, libraryName);
        return resp;
    }
}

