/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.util;

import com.vmware.content.library.Item;
import com.vmware.content.library.item.TransferEndpoint;
import com.vmware.content.library.item.UpdateSession;
import com.vmware.content.library.item.UpdateSessionModel;
import com.vmware.content.library.item.updatesession.File;
import com.vmware.content.library.item.updatesession.FileTypes;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.ovf.OvfFileInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.library.util.LibraryUtil;
import com.vmware.vsphere.client.libraryItem.model.LibraryItemEndpointInfo;
import com.vmware.vsphere.client.libraryItem.model.LibraryItemResult;
import com.vmware.vsphere.client.libraryItem.specs.ImportLibraryItemSpec;
import com.vmware.vsphere.client.libraryItem.util.TransferUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiAsyncCallback;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;

public class LibraryItemUtil {
    public static String LIBRARY_SERVICE_STRINGS = "libraryservice";
    private static final Log _logger = LogFactory.getLog(LibraryItemUtil.class);

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)LIBRARY_SERVICE_STRINGS, (String)key, (ClassLoader)LibraryUtil.class.getClassLoader());
    }

    public static Exception getLocalizedError(String key) {
        String message = LibraryItemUtil.getLocalizedString(key);
        return ErrorTransformUtil.convertError((String)message);
    }

    public static Boolean isNullOrEmpty(URI uri) {
        Boolean isNullOrEmpty = false;
        if (uri == null || StringUtils.isEmpty((CharSequence)uri.toString())) {
            isNullOrEmpty = true;
        }
        return isNullOrEmpty;
    }

    public static OperationResult triggerUploadContentsAdd(ImportLibraryItemSpec importSpec, String libraryItemId, OperationResult operationResult, Item libraryItemService, UpdateSession updateSession, File updateSessionFile, VapiTaskMonitor vapiTaskMonitor) {
        return LibraryItemUtil.triggerUploadContentsInternal(importSpec, libraryItemId, operationResult, libraryItemService, updateSession, updateSessionFile, vapiTaskMonitor);
    }

    public static OperationResult triggerUploadContentsUpdate(ImportLibraryItemSpec importSpec, String libraryItemId, OperationResult operationResult, Item libraryItemService, UpdateSession updateSession, File updateSessionFile, VapiTaskMonitor vapiTaskMonitor) {
        return LibraryItemUtil.triggerUploadContentsInternal(importSpec, libraryItemId, operationResult, libraryItemService, updateSession, updateSessionFile, vapiTaskMonitor);
    }

    private static OperationResult triggerUploadContentsInternal(ImportLibraryItemSpec importSpec, String libraryItemId, OperationResult operationResult, Item libraryItemService, UpdateSession updateSession, File updateSessionFile, VapiTaskMonitor vapiTaskMonitor) {
        String sessionId = null;
        LibraryItemResult result = new LibraryItemResult();
        List<LibraryItemEndpointInfo> endPointList = null;
        boolean isImportInErrorState = false;
        URI libraryUri = importSpec.target;
        String libraryNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)libraryUri);
        try {
            if (importSpec.transferType.equals(FileTypes.SourceType.PUSH.name())) {
                sessionId = !ArrayUtils.isEmpty((Object[])importSpec.multipleSources) ? LibraryItemUtil.createUploadLocalMultipleFilesSession(libraryItemId, updateSessionFile, updateSession, importSpec) : LibraryItemUtil.createUploadLocalFileSession(libraryItemId, updateSessionFile, updateSession, importSpec);
                endPointList = LibraryItemUtil.getLibraryItemEndPointList(updateSessionFile, sessionId, libraryNodeUuid);
                result.sessionId = sessionId;
                result.endPointList = endPointList;
                operationResult.result = result;
            } else {
                UpdateSessionModel model = LibraryItemUtil.createImportFromURLSession(libraryItemId, updateSessionFile, updateSession, importSpec);
                isImportInErrorState = model.getState() == UpdateSessionModel.State.ERROR;
                operationResult.result = model;
            }
            operationResult.entity = libraryUri;
        }
        catch (Exception e) {
            _logger.error((Object)("Preparing file upload failed. spec = " + ObjectUtil.prettyPrint((Object)importSpec)), (Throwable)e);
            operationResult.error = ErrorTransformUtil.convertError((Exception)e);
        }
        if (operationResult.error == null && !isImportInErrorState) {
            operationResult.task = LibraryItemUtil.getTask(sessionId, vapiTaskMonitor);
        } else {
            String libraryItemNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)libraryUri);
            LibraryItemUtil.deleteLibraryItem(libraryItemId, libraryItemNodeUuid, libraryItemService);
        }
        return operationResult;
    }

    public static List<LibraryItemEndpointInfo> getLibraryItemEndPointList(File updateSessionFile, String sessionId, String libraryNodeUuid) {
        ArrayList<LibraryItemEndpointInfo> endPointList = new ArrayList<LibraryItemEndpointInfo>();
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)libraryNodeUuid);
        List fileInfoList = updateSessionFile.list(sessionId, invConfig);
        for (FileTypes.Info fileInfo : fileInfoList) {
            _logger.info((Object)("Upload end point for source:" + fileInfo.getName() + ":" + fileInfo.getUploadEndpoint().getUri()));
            endPointList.add(new LibraryItemEndpointInfo(fileInfo.getName(), fileInfo.getUploadEndpoint().getUri()));
        }
        return endPointList;
    }

    public static List<LibraryItemEndpointInfo> getOVFExportURIs(List<OvfFileInfo> ovfFileInfos) {
        ArrayList<LibraryItemEndpointInfo> endPointList = new ArrayList<LibraryItemEndpointInfo>(ovfFileInfos.size());
        for (OvfFileInfo fileInfo : ovfFileInfos) {
            URI fileUri = fileInfo.getFileUrl();
            String fileName = fileInfo.getName();
            if (fileUri != null) {
                endPointList.add(LibraryItemUtil.createEndpoint(fileName, fileUri));
                continue;
            }
            _logger.info((Object)("Download url not available for file: " + fileName));
        }
        return endPointList;
    }

    public static LibraryItemEndpointInfo createEndpoint(String fileName, URI fileUri) {
        try {
            URIBuilder uriBuilder = new URIBuilder(fileUri);
            uriBuilder.setPath(fileUri.getPath());
            fileUri = uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            _logger.warn((Object)("Uri was not well formed, export may not work : " + fileUri));
        }
        return new LibraryItemEndpointInfo(fileName, fileUri);
    }

    public static OperationResult deleteLibraryItem(String libraryItemId, String libraryNodeUuid, Item service, VapiTaskMonitor vapiTaskMonitor) {
        OperationResult operationResult = new OperationResult();
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(vapiTaskMonitor, libraryNodeUuid);
        try {
            service.delete(libraryItemId, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            asyncCallback.waitForActivationTask();
            operationResult.task = LibraryItemUtil.getTask(asyncCallback.getActivationId(), vapiTaskMonitor);
        }
        catch (InterruptedException | ExecutionException e) {
            _logger.error((Object)("Deleting library item: " + libraryItemId), (Throwable)e);
            operationResult.error = e;
        }
        return operationResult;
    }

    public static void deleteLibraryItem(String libraryItemId, String libraryItemNodeUuid, Item service) {
        if (libraryItemId == null || libraryItemNodeUuid == null) {
            return;
        }
        try {
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)libraryItemNodeUuid);
            service.delete(libraryItemId, invConfig);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Failed to delete library item with ID: %s.", libraryItemId), (Throwable)e);
        }
    }

    public static FileTypes.AddSpec createAddFileSpec(String fileName, FileTypes.SourceType sourceType, TransferEndpoint endpoint) {
        FileTypes.AddSpec fileSpec = new FileTypes.AddSpec();
        fileSpec.setName(fileName);
        fileSpec.setSourceType(sourceType);
        fileSpec.setSourceEndpoint(endpoint);
        return fileSpec;
    }

    private static UpdateSessionModel createImportFromURLSession(String libraryItemId, File updateSessionFile, UpdateSession updateSession, ImportLibraryItemSpec importSpec) throws Exception {
        List warnings;
        URI source = importSpec.source;
        String sslThumbprint = importSpec.sslThumbprint;
        String transferType = importSpec.transferType;
        boolean isUpdate = importSpec.isUpdate;
        UpdateSessionModel createSpec = new UpdateSessionModel();
        createSpec.setLibraryItemId(libraryItemId);
        String sessionToken = VapiUtil.newClientToken();
        URI libraryUri = importSpec.target;
        String libraryNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)libraryUri);
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)libraryNodeUuid, (String)sessionToken);
        String sessionId = updateSession.create(sessionToken, createSpec, invConfig);
        TransferEndpoint endpoint = new TransferEndpoint();
        endpoint.setSslCertificateThumbprint(sslThumbprint);
        endpoint.setUri(source);
        String fileName = TransferUtil.getSourceFileName(source);
        InvocationConfig noActIdInvConfig = VapiUtil.newInvocationConfig((String)libraryNodeUuid);
        if (isUpdate) {
            List fileInfoList = updateSessionFile.list(sessionId, noActIdInvConfig);
            for (FileTypes.Info fileInfo : fileInfoList) {
                updateSessionFile.remove(sessionId, fileInfo.getName(), noActIdInvConfig);
            }
        }
        FileTypes.AddSpec fileSpec = LibraryItemUtil.createAddFileSpec(fileName, FileTypes.SourceType.valueOf((String)transferType), endpoint);
        updateSessionFile.add(sessionId, fileSpec, noActIdInvConfig);
        _logger.info((Object)String.format("Created import session from URL with ID: %s for library item with ID: %s.", sessionId, libraryItemId));
        UpdateSessionModel model = updateSession.get(sessionId, noActIdInvConfig);
        while (model != null && model.getPreviewInfo() != null && (model.getPreviewInfo().getState().toString() == "PREPARING" || model.getPreviewInfo().getState().toString() == "UNAVAILABLE")) {
            Thread.sleep(1000L);
            model = updateSession.get(sessionId, noActIdInvConfig);
        }
        List list = warnings = model.getPreviewInfo() != null ? model.getPreviewInfo().getWarnings() : null;
        if (warnings == null || warnings.size() == 0) {
            updateSession.complete(sessionId, noActIdInvConfig);
            _logger.info((Object)String.format("Session with ID: %s completed successfully.", sessionId));
        }
        return model;
    }

    private static String createUploadLocalFileSession(String libraryItemId, File updateSessionFile, UpdateSession updateSession, ImportLibraryItemSpec importSpec) {
        URI source = importSpec.source;
        String transferType = importSpec.transferType;
        boolean isUpdate = importSpec.isUpdate;
        UpdateSessionModel createSpec = new UpdateSessionModel();
        createSpec.setLibraryItemId(libraryItemId);
        String sessionToken = VapiUtil.newClientToken();
        URI libraryUri = importSpec.target;
        String libraryNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)libraryUri);
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)libraryNodeUuid, (String)sessionToken);
        String sessionId = updateSession.create(sessionToken, createSpec, invConfig);
        String fileName = TransferUtil.getSourceFileName(source);
        InvocationConfig noActIdInvConfig = VapiUtil.newInvocationConfig((String)libraryNodeUuid);
        if (isUpdate) {
            List fileInfoList = updateSessionFile.list(sessionId, noActIdInvConfig);
            for (FileTypes.Info fileInfo : fileInfoList) {
                updateSessionFile.remove(sessionId, fileInfo.getName(), noActIdInvConfig);
            }
        }
        try {
            if (importSpec.addManifest) {
                FileTypes.AddSpec mfSpec = LibraryItemUtil.createAddFileSpec(TransferUtil.getSourceFileNameWithoutExt(source) + ".mf", FileTypes.SourceType.valueOf((String)transferType), null);
                updateSessionFile.add(sessionId, mfSpec, noActIdInvConfig);
            }
            if (importSpec.addCertificate) {
                FileTypes.AddSpec certSpec = LibraryItemUtil.createAddFileSpec(TransferUtil.getSourceFileNameWithoutExt(source) + ".cert", FileTypes.SourceType.valueOf((String)transferType), null);
                updateSessionFile.add(sessionId, certSpec, noActIdInvConfig);
            }
            FileTypes.AddSpec fileSpec = LibraryItemUtil.createAddFileSpec(fileName, FileTypes.SourceType.valueOf((String)transferType), null);
            updateSessionFile.add(sessionId, fileSpec, noActIdInvConfig);
            _logger.info((Object)String.format("Created import session from local file with ID: %s for library item with ID: %s.", sessionId, libraryItemId));
        }
        catch (Exception e) {
            updateSession.cancel(sessionId, noActIdInvConfig);
            _logger.info((Object)String.format("Cancelling import session from local file with ID: %s for library item with ID: %s. There was an error while creating or updating a file content.", sessionId, libraryItemId));
            throw e;
        }
        return sessionId;
    }

    private static String createUploadLocalMultipleFilesSession(String libraryItemId, File updateSessionFile, UpdateSession updateSession, ImportLibraryItemSpec importSpec) {
        String transferType = importSpec.transferType;
        boolean isUpdate = importSpec.isUpdate;
        UpdateSessionModel createSpec = new UpdateSessionModel();
        createSpec.setLibraryItemId(libraryItemId);
        String sessionToken = VapiUtil.newClientToken();
        URI libraryUri = importSpec.target;
        String libraryNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)libraryUri);
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)libraryNodeUuid, (String)sessionToken);
        String sessionId = updateSession.create(sessionToken, createSpec, invConfig);
        InvocationConfig noActIdInvConfig = VapiUtil.newInvocationConfig((String)libraryNodeUuid);
        if (isUpdate) {
            List fileInfoList = updateSessionFile.list(sessionId, noActIdInvConfig);
            Iterator iterator = fileInfoList.iterator();
            while (iterator.hasNext()) {
                FileTypes.Info fileInfo = (FileTypes.Info)iterator.next();
                updateSessionFile.remove(sessionId, fileInfo.getName(), noActIdInvConfig);
            }
        }
        try {
            for (URI file : importSpec.multipleSources) {
                String fileName = TransferUtil.getSourceFileName(file);
                FileTypes.AddSpec fileSpec = LibraryItemUtil.createAddFileSpec(fileName, FileTypes.SourceType.valueOf((String)transferType), null);
                updateSessionFile.add(sessionId, fileSpec, noActIdInvConfig);
                _logger.info((Object)String.format("Created import session from local file %s with ID: %s for library item with ID: %s.", fileName, sessionId, libraryItemId));
            }
        }
        catch (Exception e) {
            updateSession.cancel(sessionId, noActIdInvConfig);
            _logger.info((Object)String.format("Cancelling import session from local file with ID: %s for library item with ID: %s. There was an error while creating or updating a file content.", sessionId, libraryItemId));
            throw e;
        }
        return sessionId;
    }

    private static ManagedObjectReference getTask(String sessionID, VapiTaskMonitor vapiTaskMonitor) {
        ManagedObjectReference task = null;
        try {
            String activationID = LibraryItemUtil.getTaskActivationId(sessionID);
            task = vapiTaskMonitor.waitForActivationTask(activationID, null);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Failed to retrieve task for session with ID: %s.", sessionID), (Throwable)e);
        }
        return task;
    }

    private static String getTaskActivationId(String sessionID) {
        String activationID = null;
        if (sessionID != null) {
            String[] parts = sessionID.split(":");
            activationID = parts.length > 0 ? parts[0] : null;
        }
        return activationID;
    }
}

