/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.versioning.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.library.util.LibraryUtil;
import com.vmware.vsphere.client.libraryItem.versioning.data.CheckoutTemplateClusterData;
import com.vmware.vsphere.client.libraryItem.versioning.data.CheckoutTemplateHostData;
import com.vmware.vsphere.client.libraryItem.versioning.data.CheckoutTemplateResourcePoolData;
import com.vmware.vsphere.client.libraryItem.versioning.data.CheckoutTemplateVappData;
import com.vmware.vsphere.client.libraryItem.versioning.spec.CheckoutTemplateComputeResourceSpec;
import com.vmware.vsphere.client.vm.api.DatastoreMirrorsInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class CheckoutTemplateComputeResourceValidator
implements MutationProvider {
    private static final String ASSIGN_VM_TO_POOL_PRIVILEGE = "Resource.AssignVMToPool";
    private static final String VM_DATASTORES_PROPERTY = "vmDatastoresInfo";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;

    public CheckoutTemplateComputeResourceValidator(QueryBindingServiceFactory queryBindingServiceFactory, QueryServiceFactory queryServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._queryService = queryServiceFactory.getQueryService();
    }

    public ValidationResult validate(CheckoutTemplateComputeResourceSpec checkSpec) {
        List<DatastoreMirrorsInfo> vmDatastoresInfo = this.fetchDatastores(checkSpec.vmRef);
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)checkSpec.targetRef, HostSystem.class)) {
            return this.validateHost(checkSpec, vmDatastoresInfo);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)checkSpec.targetRef, ResourcePool.class)) {
            return this.validateRp(checkSpec, vmDatastoresInfo);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)checkSpec.targetRef, VirtualApp.class)) {
            return this.validateVapp(checkSpec, vmDatastoresInfo);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)checkSpec.targetRef, ClusterComputeResource.class)) {
            return this.validateCluster(checkSpec, vmDatastoresInfo);
        }
        ValidationResult result = new ValidationResult();
        String errMsg = LibraryUtil.getLocalizedString("destinationValidation.invalidSelection");
        result.error = ErrorTransformUtil.convertError((String)errMsg);
        return result;
    }

    private List<DatastoreMirrorsInfo> fetchDatastores(ManagedObjectReference vmRef) {
        if (vmRef == null) {
            return Collections.emptyList();
        }
        ResultSet result = this._queryService.select(new String[]{VM_DATASTORES_PROPERTY}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vmRef).fetch();
        List resultItems = result.getItems();
        if (resultItems.isEmpty()) {
            return Collections.emptyList();
        }
        DatastoreMirrorsInfo[] dsMirrorsInfo = (DatastoreMirrorsInfo[])((ResourceItem)resultItems.get(0)).get(VM_DATASTORES_PROPERTY);
        return Arrays.asList(dsMirrorsInfo);
    }

    private ValidationResult validateVapp(CheckoutTemplateComputeResourceSpec checkSpec, List<DatastoreMirrorsInfo> vmDatastoresInfo) {
        ValidationResult result = new ValidationResult();
        CheckoutTemplateVappData vappData = (CheckoutTemplateVappData)this._queryBindingService.prepare(CheckoutTemplateVappData.class).fetch((Object)checkSpec.targetRef);
        if (!this.hasAssignVmToPoolPrivilige(vappData.privileges)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.VirtualAppNoPrivilege");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!this.hasAllDatastores(vmDatastoresInfo, vappData.datastores)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.NoAccessToAllTemplateDatastores");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        return result;
    }

    private ValidationResult validateRp(CheckoutTemplateComputeResourceSpec checkSpec, List<DatastoreMirrorsInfo> vmDatastoresInfo) {
        ValidationResult result = new ValidationResult();
        CheckoutTemplateResourcePoolData rpData = (CheckoutTemplateResourcePoolData)this._queryBindingService.prepare(CheckoutTemplateResourcePoolData.class).fetch((Object)checkSpec.targetRef);
        if (!this.hasAssignVmToPoolPrivilige(rpData.privileges)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.ResourcePoolNoPrivilege");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!this.hasAllDatastores(vmDatastoresInfo, rpData.datastores)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.NoAccessToAllTemplateDatastores");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        return result;
    }

    private ValidationResult validateCluster(CheckoutTemplateComputeResourceSpec checkSpec, List<DatastoreMirrorsInfo> vmDatastoresInfo) {
        ValidationResult result = new ValidationResult();
        CheckoutTemplateClusterData clusterData = (CheckoutTemplateClusterData)this._queryBindingService.prepare(CheckoutTemplateClusterData.class).fetch((Object)checkSpec.targetRef);
        if (!clusterData.drsEnabled) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.nonDrsCluster");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!this.hasAssignVmToPoolPrivilige(clusterData.rpPrivileges)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.ClusterNoPrivilege");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!this.hasAllDatastores(vmDatastoresInfo, clusterData.datastores)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.NoAccessToAllTemplateDatastores");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        return result;
    }

    private ValidationResult validateHost(CheckoutTemplateComputeResourceSpec checkSpec, List<DatastoreMirrorsInfo> vmDatastoresInfo) {
        ValidationResult result = new ValidationResult();
        CheckoutTemplateHostData hostData = (CheckoutTemplateHostData)((Object)this._queryBindingService.prepare(CheckoutTemplateHostData.class).fetch((Object)checkSpec.targetRef));
        if (!this.isHostAvailable(hostData)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.HostNotConnected");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!this.hasAssignVmToPoolPrivilige(hostData.rpPrivileges)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.HostNoPrivilege");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        if (!this.hasAllDatastores(vmDatastoresInfo, hostData.datastores)) {
            String errMsg = LibraryUtil.getLocalizedString("destinationValidation.NoAccessToAllTemplateDatastores");
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        return result;
    }

    private boolean isHostAvailable(CheckoutTemplateHostData hostData) {
        boolean isHostConnected = hostData.connectionState == null || hostData.connectionState == HostSystem.ConnectionState.connected;
        boolean isHostInMaintenanceMode = hostData.inMaintenanceMode;
        boolean isHostInTransition = false;
        if (hostData.disabledMethods != null) {
            String[] disabledMethods = hostData.disabledMethods;
            List<String> arrayList = Arrays.asList(disabledMethods);
            isHostInTransition = arrayList.contains("EnterMaintenanceMode_Task") && arrayList.contains("ExitMaintenanceMode_Task");
        }
        return isHostConnected && !isHostInMaintenanceMode && !isHostInTransition;
    }

    private boolean hasAssignVmToPoolPrivilige(String[] privileges) {
        return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{ASSIGN_VM_TO_POOL_PRIVILEGE}, (String[])privileges);
    }

    private boolean hasAllDatastores(List<DatastoreMirrorsInfo> vmDatastoresInfo, ManagedObjectReference[] resourceDatastores) {
        if (vmDatastoresInfo == null || vmDatastoresInfo.size() == 0) {
            return true;
        }
        if (ArrayUtils.isEmpty((Object[])resourceDatastores)) {
            return false;
        }
        for (DatastoreMirrorsInfo vmDsInfo : vmDatastoresInfo) {
            if (ArrayUtils.contains((Object[])resourceDatastores, (Object)vmDsInfo.ref)) continue;
            if (ArrayUtils.isEmpty((Object[])vmDsInfo.mirrors)) {
                return false;
            }
            boolean datastoreFound = false;
            for (ManagedObjectReference datastoreMirror : vmDsInfo.mirrors) {
                if (!ArrayUtils.contains((Object[])resourceDatastores, (Object)datastoreMirror)) continue;
                datastoreFound = true;
                break;
            }
            if (datastoreFound) continue;
            return false;
        }
        return true;
    }
}

