/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.versioning.impl;

import com.vmware.vcenter.vm_template.library_items.CheckOuts;
import com.vmware.vcenter.vm_template.library_items.CheckOutsTypes;
import com.vmware.vcenter.vm_template.library_items.Versions;
import com.vmware.vcenter.vm_template.library_items.VersionsTypes;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.libraryItem.versioning.specs.CheckinVmSpec;
import com.vmware.vsphere.client.libraryItem.versioning.specs.CheckoutTemplateSpec;
import com.vmware.vsphere.client.libraryItem.versioning.specs.DeleteTemplateSpec;
import com.vmware.vsphere.client.libraryItem.versioning.specs.DiscardVmSpec;
import com.vmware.vsphere.client.libraryItem.versioning.specs.RevertSpec;
import com.vmware.vsphere.client.vapi.tasks.VapiAsyncCallback;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersioningMutationProvider
implements MutationProvider {
    private static Log _logger = LogFactory.getLog(VersioningMutationProvider.class);
    private CheckOuts _checkOutsService;
    private ObjectReferenceService _objectReferenceService;
    private Versions _versionsService;
    private VapiTaskMonitor _vapiTaskMonitor;

    public VersioningMutationProvider(CheckOuts checkoutsService, ObjectReferenceService objectReferenceService, Versions versionsService) {
        this._checkOutsService = checkoutsService;
        this._objectReferenceService = objectReferenceService;
        this._versionsService = versionsService;
    }

    public void setVapiTaskMonitor(VapiTaskMonitor vapiTaskMonitor) {
        this._vapiTaskMonitor = vapiTaskMonitor;
    }

    public OperationResult apply(ManagedObjectReference vmRef, CheckinVmSpec spec) {
        OperationResult result = new OperationResult();
        try {
            URI templateUri = new URI(spec.templateId);
            result.entity = templateUri;
            String nodeUid = VapiUriSchemeUtil.getNodeUuid((URI)templateUri);
            VapiAsyncCallback asyncCallback = this.constructAsyncCallback(nodeUid);
            CheckOutsTypes.CheckInSpec checkInSpec = new CheckOutsTypes.CheckInSpec();
            checkInSpec.setMessage(spec.note);
            String templateId = VapiUriSchemeUtil.getId((URI)templateUri);
            this._checkOutsService.checkIn(templateId, CisIdConverter.toGlobalCisId((ManagedObjectReference)vmRef, (String)vmRef.getServerGuid()), checkInSpec, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            result.error = e;
            String vmId = ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef);
            _logger.error((Object)String.format("Failed to check vm%s to template %s", vmId, spec.templateId), (Throwable)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryItemUri, CheckoutTemplateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = libraryItemUri;
        try {
            String objectType;
            String libraryItemId = VapiUriSchemeUtil.getId((URI)libraryItemUri);
            String libraryItemNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)libraryItemUri);
            VapiAsyncCallback asyncCallback = this.constructAsyncCallback(libraryItemNodeUuid);
            CheckOutsTypes.CheckOutSpec checkOutSpec = new CheckOutsTypes.CheckOutSpec();
            checkOutSpec.setName(spec.vmName);
            checkOutSpec.setPoweredOn(Boolean.valueOf(spec.powerOnVm));
            CheckOutsTypes.PlacementSpec placementSpec = new CheckOutsTypes.PlacementSpec();
            placementSpec.setFolder(spec.folderId);
            Object computeResourceRef = this._objectReferenceService.getReference(spec.computeResourceId);
            switch (objectType = this._objectReferenceService.getResourceObjectType(computeResourceRef)) {
                case "HostSystem": {
                    placementSpec.setHost(spec.computeResourceId);
                    break;
                }
                case "ClusterComputeResource": {
                    placementSpec.setCluster(spec.computeResourceId);
                    break;
                }
                case "ResourcePool": 
                case "VirtualApp": {
                    placementSpec.setResourcePool(spec.computeResourceId);
                    break;
                }
                default: {
                    _logger.error((Object)String.format("Unsupported compute resource type %s", objectType));
                }
            }
            checkOutSpec.setPlacement(placementSpec);
            this._checkOutsService.checkOut(libraryItemId, checkOutSpec, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            result.error = e;
            _logger.error((Object)String.format("Failed to check out template %s to vm %s", libraryItemUri.toString(), spec.vmName), (Throwable)e);
        }
        return result;
    }

    public OperationResult apply(URI templateUri, RevertSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = templateUri;
        try {
            String nodeUid = VapiUriSchemeUtil.getNodeUuid((URI)templateUri);
            VapiAsyncCallback asyncCallback = this.constructAsyncCallback(nodeUid);
            VersionsTypes.RollbackSpec rollbackSpec = new VersionsTypes.RollbackSpec();
            rollbackSpec.setMessage(spec.note);
            String templateId = VapiUriSchemeUtil.getId((URI)templateUri);
            this._versionsService.rollback(templateId, spec.versionId, rollbackSpec, asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
            result.result = templateUri;
        }
        catch (Exception e) {
            result.error = e;
            _logger.error((Object)String.format("Failed to revert template to version %s", spec.versionId), (Throwable)e);
        }
        return result;
    }

    public OperationResult remove(URI templateUri, DeleteTemplateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = templateUri;
        try {
            String templateId = VapiUriSchemeUtil.getId((URI)templateUri);
            String nodeUid = VapiUriSchemeUtil.getNodeUuid((URI)templateUri);
            VapiAsyncCallback asyncCallback = this.constructAsyncCallback(nodeUid);
            this._versionsService.delete(templateId, spec.versionId, asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            result.error = e;
            _logger.error((Object)String.format("Failed to delete template with version %s", spec.versionId), (Throwable)e);
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference mor, DiscardVmSpec spec) {
        OperationResult result = new OperationResult();
        try {
            String vmId = CisIdConverter.toGlobalCisId((ManagedObjectReference)mor, (String)mor.getServerGuid());
            URI templateUri = new URI(spec.templateId);
            result.entity = templateUri;
            String nodeUid = VapiUriSchemeUtil.getNodeUuid((URI)templateUri);
            VapiAsyncCallback asyncCallback = this.constructAsyncCallback(nodeUid);
            String templateId = VapiUriSchemeUtil.getId((URI)templateUri);
            this._checkOutsService.delete(templateId, vmId, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            result.error = e;
            _logger.error((Object)String.format("Failed to discard VM %s", ManagedObjectUtil.morefToString((ManagedObjectReference)mor)));
        }
        return result;
    }

    protected <T> VapiAsyncCallback<T> constructAsyncCallback(String nodeUid) {
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(this._vapiTaskMonitor, nodeUid);
        return asyncCallback;
    }
}

