/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.lacp;

import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.dvs.api.featureupgrade.ValidationCheckResult;
import com.vmware.vsphere.client.dvs.lacp.LacpUpgradePrerequisitesValidator;
import com.vmware.vsphere.client.networking.util.I18nUtil;

public class LacpPropertyProvider
implements PropertyProviderBean {
    private static final String LOAD_BALANCE_MODE_DEFAULT = VmwareDistributedVirtualSwitch.LacpLoadBalanceAlgorithm.srcIp.name();
    private static final String PROP_NUMBER_OF_UPLINKS = "config.uplinkPortPolicy[@type='DVSNameArrayUplinkPortPolicy'].uplinkPortName._length";
    private static final String PROP_LACP_POLICY_ENABLE = "lacpV1Enabled";
    private static final String PROP_LACP_POLICY_MODE = "config.defaultPortConfig[@type='VMwareDVSPortSetting'].lacpPolicy.mode.value";
    private DataService _dataService;
    private final LacpUpgradePrerequisitesValidator _upgradeValidator;

    @type(value="VmwareDistributedVirtualSwitch")
    public ValidationCheckResult[] getLacpUpgradePrerequisites(ManagedObjectReference dvsRef) throws Exception {
        return this._upgradeValidator.validatePrerequisites(dvsRef);
    }

    @type(value="VmwareDistributedVirtualSwitch")
    public VmwareDistributedVirtualSwitch.LacpGroupConfig getUpgradeLag(ManagedObjectReference dvsRef) throws Exception {
        String mode = this.findExistingLacpMode(dvsRef);
        if (mode == null) {
            return null;
        }
        Integer numberOfUplinks = (Integer)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)PROP_NUMBER_OF_UPLINKS);
        if (numberOfUplinks == null) {
            return null;
        }
        VmwareDistributedVirtualSwitch.LacpGroupConfig lag = new VmwareDistributedVirtualSwitch.LacpGroupConfig(null, I18nUtil.text("lacp.upgrade.defaultLagName", new String[0]), mode, numberOfUplinks, LOAD_BALANCE_MODE_DEFAULT, new VmwareDistributedVirtualSwitch.LagVlanConfig(), new VmwareDistributedVirtualSwitch.LagIpfixConfig(), null, null, null);
        return lag;
    }

    @type(value="VmwareDistributedVirtualSwitch")
    public Boolean getIsLacpConfigured(ManagedObjectReference dvsRef) throws Exception {
        return this._upgradeValidator.validateLacpEnabled(dvsRef);
    }

    private String findExistingLacpMode(ManagedObjectReference dvsRef) throws Exception {
        PropertyConstraint lacpEnabledConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)PROP_LACP_POLICY_ENABLE, (Comparator)Comparator.EQUALS, (Object)"true");
        ObjectIdentityConstraint dvsConstraint = QueryUtil.createObjectIdentityConstraint((Object)dvsRef);
        RelationalConstraint dvsToPgConstraint = QueryUtil.createRelationalConstraint((String)"uplinkPortgroup", (Constraint)dvsConstraint, (Boolean)true, (String)DistributedVirtualPortgroup.class.getSimpleName());
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{dvsToPgConstraint, lacpEnabledConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec uplinkPgQuery = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{PROP_LACP_POLICY_MODE});
        ResultSet rsLacpData = QueryUtil.getData((DataService)this._dataService, (QuerySpec)uplinkPgQuery);
        if (rsLacpData == null || rsLacpData.items == null || rsLacpData.items.length != 1) {
            return null;
        }
        ResultItem props = rsLacpData.items[0];
        if (props == null || props.properties == null || props.properties.length != 1 || props.properties[0] == null || !(props.properties[0].value instanceof String)) {
            return null;
        }
        return (String)props.properties[0].value;
    }

    public LacpPropertyProvider(DataService dataService, LacpUpgradePrerequisitesValidator upgradeValidator) {
        if (upgradeValidator == null) {
            throw new IllegalArgumentException("Parameter 'upgradeValidator' is required.");
        }
        this._dataService = dataService;
        this._upgradeValidator = upgradeValidator;
    }
}

