/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.lacp.commands;

import com.vmware.vim.binding.vim.BoolPolicy;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.TaskCommand;
import com.vmware.vsphere.client.dvs.lacp.specs.LacpLegacyConfigRemoveCommandSpec;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.Map;

public class LacpLegacyConfigRemoveCommand
extends TaskCommand {
    private static final String PROP_LEGACY_LACP_ENABLE = "lacpV1Enabled";
    private static final String PROP_CONFIG_VERSION = "config.configVersion";
    private final DataService _dataService;

    public LacpLegacyConfigRemoveCommand(LacpLegacyConfigRemoveCommandSpec spec, DataService dataService) {
        this.setCommandSpec(spec);
        this._dataService = dataService;
    }

    protected Task launch() throws Exception {
        int lacpUplinkPgCount;
        ManagedObjectReference dvsRef = this.getCommandSpec().mor;
        RelationalConstraint uplinkPgConstraint = QueryUtil.createRelationalConstraint((String)"uplinkPortgroup", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)dvsRef), (Boolean)true, (String)DistributedVirtualPortgroup.class.getSimpleName());
        PropertyConstraint legacyLacpConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)PROP_LEGACY_LACP_ENABLE, (Comparator)Comparator.EQUALS, (Object)true);
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{uplinkPgConstraint, legacyLacpConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{PROP_CONFIG_VERSION});
        Map<Object, Map<String, Object>> rs = Util.resultSetToMap(QueryUtil.getData((DataService)this._dataService, (QuerySpec)query));
        int n = lacpUplinkPgCount = rs == null ? 0 : rs.size();
        if (lacpUplinkPgCount != 1) {
            throw new Exception("Unexpected number of LACP-enabled uplink port groups: " + Integer.toString(lacpUplinkPgCount));
        }
        Map.Entry<Object, Map<String, Object>> ri = rs.entrySet().iterator().next();
        ManagedObjectReference uplinkPgRef = (ManagedObjectReference)ri.getKey();
        DistributedVirtualPortgroup.ConfigSpec spec = new DistributedVirtualPortgroup.ConfigSpec();
        spec.configVersion = (String)ri.getValue().get(PROP_CONFIG_VERSION);
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy portConfig = new VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy();
        portConfig.lacpPolicy = new VmwareDistributedVirtualSwitch.UplinkLacpPolicy();
        portConfig.lacpPolicy.inherited = false;
        portConfig.lacpPolicy.enable = new BoolPolicy(false, Boolean.valueOf(false));
        spec.defaultPortConfig = portConfig;
        DistributedVirtualPortgroup pg = (DistributedVirtualPortgroup)ManagedObjectUtil.getManagedObject((ManagedObjectReference)uplinkPgRef);
        ManagedObjectReference taskRef = pg.reconfigure(spec);
        return (Task)ManagedObjectUtil.getManagedObject((ManagedObjectReference)taskRef);
    }
}

