/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.ports;

import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vsphere.client.dvs.api.spec.DistributedVirtualPortFilterSpec;
import org.apache.commons.lang3.ArrayUtils;

public final class DistributedVirtualPortQuerySpecBuilder {
    private static final String DVPORT_TYPE = "DVPort";
    private static final String DVPORT_FILTER = "portFilterCriteria";
    private String _name;
    private String[] _properties;
    private ManagedObjectReference _dvsRef;
    private ManagedObjectReference[] _portgroups;
    private ManagedObjectReference[] _hosts;
    private ManagedObjectReference[] _vms;
    private PortCriteria _portCriteria;
    private Boolean _connected;
    private Boolean _inside;
    private String[] _portKey;
    private String[] _portgroupKey;

    public DistributedVirtualPortQuerySpecBuilder queryName(String name) {
        this._name = name;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder propertyNames(String ... properties) {
        this._properties = properties;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder dvs(ManagedObjectReference dvsRef) {
        this._dvsRef = dvsRef;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder filterPortgroups(ManagedObjectReference[] portgroups) {
        this._portgroups = portgroups;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder filterHosts(ManagedObjectReference[] hosts) {
        this._hosts = hosts;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder filterVms(ManagedObjectReference[] vms) {
        this._vms = vms;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder filterCriteria(PortCriteria portCriteria) {
        this._portCriteria = portCriteria;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder filterConnected(boolean connected) {
        this._connected = connected;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder filterInside(boolean inside) {
        this._inside = inside;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder filterPortgroupKey(String[] portgroupKey) {
        this._portgroupKey = portgroupKey;
        return this;
    }

    public DistributedVirtualPortQuerySpecBuilder filterPortKey(String[] portKey) {
        this._portKey = portKey;
        return this;
    }

    public QuerySpec build() {
        if (this._dvsRef == null) {
            throw new IllegalStateException("Property cannot be null: dvs");
        }
        if (ArrayUtils.isEmpty((Object[])this._properties)) {
            throw new IllegalStateException("Property not initialized: propertyNames");
        }
        boolean isPortCriteriaParmeterSpecified = this._connected != null || this._inside != null || this._portgroupKey != null || this._portKey != null;
        DistributedVirtualPortFilterSpec filter = new DistributedVirtualPortFilterSpec();
        filter.dvs = this._dvsRef;
        filter.hosts = this._hosts;
        filter.vms = this._vms;
        filter.portgroups = this._portgroups;
        if (this._portCriteria != null) {
            if (isPortCriteriaParmeterSpecified) {
                throw new IllegalStateException("Cannot specify both portCriteria and filter parameter from the portCriteria.");
            }
            filter.portCriteria = this._portCriteria;
        } else if (isPortCriteriaParmeterSpecified) {
            filter.portCriteria = new PortCriteria();
            filter.portCriteria.connected = this._connected;
            filter.portCriteria.inside = this._inside;
            filter.portCriteria.portgroupKey = this._portgroupKey;
            filter.portCriteria.portKey = this._portKey;
        }
        Constraint constraint = new Constraint();
        constraint.targetType = DVPORT_TYPE;
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.propertyName = DVPORT_FILTER;
        paramSpec.parameter = filter;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = this._properties;
        propertySpec.parameters = new ParameterSpec[]{paramSpec};
        propertySpec.type = DVPORT_TYPE;
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = new ResultSpec();
        querySpec.name = this._name;
        return querySpec;
    }
}

