/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.host.commands;

import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.FutureCommand;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.network.host.api.spec.NetSysUpdateNetConfigCommandSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class NetSysUpdateNetConfigCommand
extends FutureCommand {
    public NetSysUpdateNetConfigCommand(NetSysUpdateNetConfigCommandSpec commandSpec) {
        this.setCommandSpec((BaseCommandSpec)commandSpec);
    }

    protected ClientFutureImpl<?> launch() throws Exception {
        NetSysUpdateNetConfigCommandSpec commadSpec = (NetSysUpdateNetConfigCommandSpec)this.getCommandSpec();
        NetworkSystem ns = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)commadSpec.mor);
        ClientFutureImpl future = new ClientFutureImpl();
        if (this._arguments instanceof Map) {
            Map hostToPortsMap = (Map)this._arguments;
            this.updatePnicSpecs(hostToPortsMap, commadSpec.modifiedPnics);
        }
        ns.updateNetworkConfig(commadSpec.networkConfig, ConfigChange.Mode.modify.toString(), (Future)future);
        return future;
    }

    private void updatePnicSpecs(Map<ManagedObjectReference, ArrayList<DistributedVirtualPort>> hostToPortsMap, String[] modifiedPnics) {
        HashSet<String> modifiedPnicsSet = new HashSet<String>();
        if (modifiedPnics != null) {
            for (String pnicName : modifiedPnics) {
                modifiedPnicsSet.add(pnicName);
            }
        }
        if (hostToPortsMap != null) {
            HostProxySwitch.Config proxySwitchConfig;
            NetSysUpdateNetConfigCommandSpec commandSpec = (NetSysUpdateNetConfigCommandSpec)this.getCommandSpec();
            ArrayList<DistributedVirtualPort> ports = hostToPortsMap.get(commandSpec.hostRef);
            if (commandSpec.networkConfig != null && !ArrayUtils.isEmpty((Object[])commandSpec.networkConfig.proxySwitch) && (proxySwitchConfig = commandSpec.networkConfig.proxySwitch[commandSpec.networkConfig.proxySwitch.length - 1]) != null && proxySwitchConfig.spec != null && proxySwitchConfig.spec.backing instanceof HostMember.PnicBacking) {
                HostMember.PnicBacking pnicBacking = (HostMember.PnicBacking)proxySwitchConfig.spec.backing;
                if (pnicBacking.pnicSpec != null) {
                    block1: for (HostMember.PnicSpec pnicSpec : pnicBacking.pnicSpec) {
                        if (pnicSpec == null || !modifiedPnicsSet.contains(pnicSpec.pnicDevice) || pnicSpec.uplinkPortKey == null) continue;
                        String dvUplink = pnicSpec.uplinkPortKey;
                        pnicSpec.uplinkPortKey = null;
                        for (DistributedVirtualPort dvPort : ports) {
                            if (dvPort.config == null || dvPort.config.name == null || !dvPort.config.name.equals(dvUplink)) continue;
                            pnicSpec.uplinkPortKey = dvPort.key;
                            continue block1;
                        }
                    }
                }
            }
        }
    }
}

