/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.host.iscsi.commands;

import com.vmware.vim.binding.vim.host.IscsiManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.FutureCommand;
import com.vmware.vsphere.client.network.host.iscsi.specs.UnbindVnicCommandSpec;
import com.vmware.vsphere.client.networking.util.Util;

public class UnbindVnicCommand
extends FutureCommand {
    private final DataService _dataService;

    public UnbindVnicCommand(UnbindVnicCommandSpec commandSpec, DataService dataService) {
        this.setCommandSpec(commandSpec);
        this._dataService = dataService;
    }

    protected ClientFutureImpl<Void> launch() throws Exception {
        UnbindVnicCommandSpec spec = (UnbindVnicCommandSpec)this.getCommandSpec();
        ManagedObjectReference iscsiManagerMor = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)spec.mor, (String)"iscsiManager");
        IscsiManager iscsiManager = (IscsiManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)iscsiManagerMor);
        if (iscsiManager == null) {
            String errorMessage = Util.getLocalizedString("iscsi.iscsiManagerNotFoundError");
            throw new Exception(errorMessage);
        }
        ClientFutureImpl future = new ClientFutureImpl();
        iscsiManager.unbindVnic(spec.iscsiHbaName, spec.vnicDevice, spec.forceRemoval, (Future)future);
        return future;
    }
}

